<?php

foreach ($_GET as &$val) {
    $val = htmlspecialchars($val);
}

$hasSubscription = $boek === false || $ebook === false;

$formName = isset($_GET['pay_name']) ? $_GET['pay_name'] : '';
$formEmail = isset($_GET['pay_email']) ? $_GET['pay_email'] : '';
$formPostal = isset($_GET['pay_postal']) ? $_GET['pay_postal'] : '';
$formStreet = isset($_GET['pay_street']) ? $_GET['pay_street'] : '';
$formStreetNumber = isset($_GET['pay_street_number']) ? $_GET['pay_street_number'] : '';
$formPlace = isset($_GET['pay_place']) ? $_GET['pay_place'] : '';
$formCountry = isset($_GET['pay_country']) ? $_GET['pay_country'] : 'Nederland';
$formQuantity = isset($_GET['pay_quantity']) ? $_GET['pay_quantity'] : '';
$formMethod = isset($_GET['pay_method']) ? $_GET['pay_method'] : '';
$formIdealIssuer = isset($_GET['pay_ideal_issuer']) ? $_GET['pay_ideal_issuer'] : '';
$geoAuthKey = GEO_AUTH_KEY;

?>

<script type="text/javascript">
    function gotoAlt(chkbox) {
        var name = document.getElementById("name").value;
        var email = document.getElementById("email").value;
        var paymethod = $('[name=payment_method]:checked').val();
        var idealIssuer = document.getElementById("ideal_issuer").value;
        var pstr = 'pay_name='.concat(name)
            .concat('&pay_email=').concat(email)
            .concat('&pay_method=').concat(paymethod);

        if (idealIssuer) {
            pstr = pstr.concat('&pay_ideal_issuer=').concat(idealIssuer)
        }

        <?php if (IS_FYSIEK): ?>
            var postal = document.getElementById("postal").value;
            var streetNumber = document.getElementById("street_number").value;
            var street = document.getElementById("street").value;
            var city = document.getElementById("city").value;
            var country = document.getElementById("country").value;
            var quantity = document.getElementById("quantity") ? document.getElementById("quantity").value : "1";
            pstr = pstr
                .concat('&pay_postal=').concat(postal)
                .concat('&pay_street=').concat(street)
                .concat('&pay_street_number=').concat(streetNumber)
                .concat('&pay_place=').concat(city)
                .concat('&pay_country=').concat(country)
                .concat('&quantity=').concat(quantity)
            ;
        <?php endif ;?>
        if (chkbox.checked) {
            window.location = '?' + pstr;
        } else {
            <?php if (IS_FYSIEK): ?>
                window.location = '?boek&' + pstr;
            <?php else: ?>
                window.location = '?ebook&' + pstr;
            <?php endif?>
        }
    }
</script>
<div id="div_session_write"></div>
<div class="table_payment">
    <h4><strong><?php if (IS_FYSIEK && !IS_VIDEO): ?>Op welk adres wil je het boek ontvangen?<?php else: ?>Hoe wil je betalen?<?php endif ?></strong></h4>
    <form id="payment_form" name="payment_form" method="post"
          action="<?php echo(!$hasSubscription ? "paymentgateway_dps_cpp.php" : "paymentgateway_ups_old.php"); ?>">

        <?php if (isset($form_payment_top) && $form_payment_top)
            include realpath(__DIR__ . '/payment_methods_partial.php');
        ?>
        <?php if (!isset($form_show_name) || $form_show_name): ?>
        <p><strong>Naam:</strong><br>
            <input name="name" type="text" id="name" value="<?php echo $formName; ?>" size="30">
        </p>
        <?php else :?>
            <input name="name" type="hidden" id="name" value="Naam">
        <?php endif ?>
        <p><strong>E-mailadres:</strong><br>
            <?php if (!IS_FYSIEK && !IS_VIDEO): ?>
                <span class="small">(hierop ontvang je het ebook + bonussen)</span><br>
            <?php elseif (!IS_FYSIEK && IS_VIDEO): ?>
                <span class="small">(hierop ontvang je de link naar de video's)</span><br>
            <?php endif ?>
            <input name="email" type="text" id="email" value="<?php echo $formEmail; ?>" size="30">
        </p>

        <?php if (IS_FYSIEK): ?>
        <?php
            $showStreetFields = $formCountry === 'België' || ($formPostal !== '' && $formStreetNumber !== '');
        ?>
            <p><strong>Postcode:</strong><br>
                <input name="postal" type="text" id="postal" value="<?php echo $formPostal; ?>"
                       onkeyup="this.value=this.value.split(' ').join('')" size="30">
            </p>
            <p id="street_number_wrapper"><strong>Huisnummer en toevoeging:</strong><br>
                <input name="street_number" type="text" id="street_number" value="<?php echo $formStreetNumber; ?>" size="30">
            </p>
            <p id="street_wrapper" <?php if (!$showStreetFields):?>style="display: none;"<?php endif ?>><strong>Straat:</strong><br>
                <input name="street" type="text" id="street" value="<?php echo $formStreet; ?>" size="30">
            </p>
            <p id="city_wrapper" <?php if (!$showStreetFields):?>style="display: none;"<?php endif ?>><strong>Plaats:</strong><br>
                <input name="city" type="text" id="city" value="<?php echo $formPlace; ?>" size="30">
            </p>
            <p id="country_wrapper" <?php if (!$showStreetFields || $formCountry !== 'België'):?>style="display: none;"<?php endif ?>><strong>Land:</strong>
                <br>
                <select name="country" id="country" disabled="disabled">
                    <option value=''>Kies je land...</option>
                    <option<?php echo $formCountry == 'Nederland' ? ' selected' : ''; ?>>Nederland</option>
                    <option<?php echo $formCountry == 'België' ? ' selected' : ''; ?>>België</option>
                </select><br>
                <span class="small">* Het fysieke boek is alleen leverbaar in Nederland of België. Woon je ergens anders? Kies dan voor de <a
                            href="digitaal.php">digitale editie.</a></span>
        <?php endif ?>

        <?php if (!isset($form_payment_top) || !$form_payment_top)
            include realpath(__DIR__ . '/payment_methods_partial.php');
        ?>

        <p>
            <input name="button-styled" type="button" class="button-styled" id="button-styled"
                   onClick="checkform(this.form);" value="Betalen &amp; Direct Toegang »">
        </p>
    </form>
    <script src="//senhpayments.nl/js/jquery-1.10.2.js"></script>
    <script src="//senhpayments.nl/js/iban.js"></script>
    <script language="javascript" type="text/javascript">
        function isEmail(email) {
            // see for a strict regex use http://stackoverflow.com/questions/46155/validate-email-address-in-javascript#46181
            return /^\S+@\S+\.\S+$/.test(email);
        }
        function checkform(f) {
            var ret = true;
            if ((ret) && ( document.getElementById("name").value.length == 0 )) {
                ret = false;
                var msg = "Je bent vergeten je naam in te vullen.";
            }
            if ((ret) && ( document.getElementById("email").value.length == 0 )) {
                ret = false;
                var msg = "Je bent vergeten je e-mailadres in te vullen.";
            }
            if ((ret) && (!isEmail(document.getElementById("email").value))) {
                ret = false;
                var msg = "Je hebt een incorrect e-mailadres ingevuld. Controleer je e-mailadres.";
            }

            <?php if (IS_FYSIEK): ?>
                if (ret) {
                    var postal = document.getElementById("postal").value.split(' ').join('');
                    var country = document.getElementById("country").value;
                    if (country === 'Nederland') {
                        if (ret) {
                            if (parseInt(postal) == postal) {
                                ret = false;
                                var msg = "De postcode en het land corresponderen niet met elkaar";
                            }
                        }
                        if (ret) {
                            if (postal.length > 6 || postal.length < 6 || parseInt(postal.substr(0, 4)) != postal.substr(0, 4) || !/^[a-z]+$/i.test(postal.substr(4, 2))) {
                                ret = false;
                                var msg = "Vul een geldige postcode in.";
                            }
                        }
                    } else if (country === 'België') {
                        if (ret) {
                            if (parseInt(postal.substr(0, 4)) == postal.substr(0, 4) && /^[a-z]+$/i.test(postal.substr(4, 2))) {
                                ret = false;
                                var msg = "De postcode en het land corresponderen niet met elkaar";
                            }
                        }
                        if (ret) {
                            if (postal.length > 4 || postal.length < 4) {
                                ret = false;
                                var msg = "Vul een geldige postcode in.";
                            }
                        }
                    } else {
                        ret = false;
                        var msg = "Vul je land in.";
                    }
                }

                if ((ret) && ( document.getElementById("street_number").value.length == 0 )) {
                    ret = false;
                    var msg = "Je bent vergeten je huisnummer in te vullen.";
                }


                if ((ret) && ( document.getElementById("street").value.length == 0 )) {
                    ret = false;
                    var msg = "Je bent vergeten je straat in te vullen.";
                }


            <?php endif ?>

            if ((ret) && ( $('#ibanbox').is(':visible') && document.getElementById("iban").value.length == 0 )) {
                ret = false;
                var msg = "Je bent vergeten je rekeningnummer in te vullen.";
            }

            if ((ret) && ( $('#ibanbox').is(':visible') && !IBAN.isValid(document.getElementById("iban").value) )) {
                ret = false;
                var msg = "De ingevulde IBAN is niet juist.";
            }
            if ((ret) && (document.getElementById('payment_method_ideal').checked) && ( document.getElementById("ideal_issuer").options[document.getElementById("ideal_issuer").selectedIndex].value == "" )) {
                ret = false;
                var msg = "Je moet eerst je bank kiezen uit het keuzemenu om te betalen met iDEAL.";
            }
            if (ret) f.submit();
            else alert(msg);
        }

        $(function () {

            $('#payment_form').change(function (e) {
                if (e.target === $('#ideal_issuer')[0]) {
                    $('#payment_method_ideal')[0].checked = true;
                    $('#payment_method_ideal').attr('selected', 'selected');
                }

                var paymentMethod = $('input[name="payment_method"]:checked').val();
                if (
                    <?php if ($hasSubscription): ?>paymentMethod === 'bancontact/mrcash' || <?php endif ?>
                    paymentMethod === 'directdebit/sepa-once' ||
                    paymentMethod === 'directdebit/sepa-recurring'
                ) {
                    $('#ibanbox').show();
                } else {
                    $('#ibanbox').hide();
                }
            }).trigger('change');

            <?php if (IS_FYSIEK): ?>

                var GEO_AUTH_KEY = '<?= $geoAuthKey ?>';

                var postalElement = $('[name=postal');
                var streetElement = $('[name=street');
                var streetNumberElement = $('[name=street_number');
                var cityElement = $('[name=city');
                var countryElement = $('[name=country');
                var countryWrapper = $('#country_wrapper');
                var cityWrapper = $('#city_wrapper');
                var streetWrapper = $('#street_wrapper');

                // init
                showHideStreetFields(<?= $showStreetFields ?>);

                postalElement.on('change', function() {
                    showHideCountry();
                    autoComplete();
                });

                streetNumberElement.on('change', function() {
                    autoComplete();
                });

                function showHideStreetFields(show) {
                    if (show) {
                        streetWrapper.show();
                        cityWrapper.show();
                    } else {
                        streetWrapper.hide();
                        cityWrapper.hide();
                    }
                }

                function showHideCountry() {
                    if (!isValidDutchPostal()) {
                        countryElement.val('België');
                        countryWrapper.show();
                        countryElement.attr('disabled', 'disabled');
                        countryElement[0].disabled = true;
                        showHideStreetFields(true);
                    } else {
                        countryElement.val('Nederland');
                        countryWrapper.hide();
                    }
                }

                function isValidDutchPostal() {
                    var postal = getPostal();
                    return (
                        postal.length === 6 &&
                        parseInt(postal.substr(0, 4)) == postal.substr(0, 4) &&
                        /^[a-z]+$/i.test(postal.substr(4, 2)));
                }

                function getPostal() {
                    return postalElement.val().split(' ').join('');
                }

                function getStreetNumber() {
                    return streetNumberElement.val().trim();
                }

                function getStreetNumberWithoutExtension() {
                    var streetNumber = getStreetNumber();

                    // keeps only first part of streetNumber
                    var separators = ['-', '+', ' '];
                    for (var i = 0; i < separators.length; i++) {
                        var separator = separators[i];
                        var index = streetNumber.indexOf(separator);
                        if (index > -1) {
                            streetNumber = streetNumber.split(separator)[0];
                        }
                    }

                    // allow only numerical (filters out the a of 23a)
                    var pattern = /[0-9]/g;
                    var match = streetNumber.match(pattern);
                    if (!match) {
                        return '';
                    }

                    return match.join('');
                }

                function getStreetNumberExtension() {
                    var streetNumber = getStreetNumber();

                    // find extensions like (23 1, 23 a, 23 - 1, 23-1, 23-a)
                    var separators = ['-', '+', ' '];
                    for (var i = 0; i < separators.length; i++) {
                        var separator = separators[i];
                        var index = streetNumber.indexOf(separator);
                        if (index > -1) {
                            streetNumber = streetNumber.substr(index + 1).trim();
                        }
                    }

                    if (streetNumber !== getStreetNumber()) {
                        return streetNumber;
                    }

                    // extension attached (23a)
                    var pattern = /[a-zA-Z]/g;
                    var match = streetNumber.match(pattern);
                    if (!match) {
                        return '';
                    }

                    return match.join('');
                }

                function shouldAutoComplete() {
                    return isValidDutchPostal() && streetNumberElement.val().length > 0;
                }

                function autoComplete() {
                    if (!shouldAutoComplete()) {
                        return null;
                    }

                    doAutoComplete();
                }

                function doAutoComplete() {
                    var postal = getPostal();
                    var streetNumber = getStreetNumberWithoutExtension();
//                    var streetNumberExtension = getStreetNumberExtension();

                    var url = 'https://api.pro6pp.nl/v1/autocomplete?' +
                        'auth_key=' + GEO_AUTH_KEY +
                        '&nl_sixpp=' + postal +
                        '&streetnumber=' + streetNumber;// +
//                        '&extension=' + streetNumberExtension; /

                    $.ajax({
                        url: url,
                        method: 'GET'
                    })
                    .success(function(data) {
                        if (data.status !== 'ok') {
                            return null;
                        }

                        data = data.results[0];
                        var street = data.street;
                        var city = data.municipality;
                        streetElement.val(street);
                        cityElement.val(city);
                    })
                    .error(function() {
                    })
                    .done(function() {
                        showHideStreetFields(true);
                    })

                }

                streetElement.on('keyup change', function () {
                    if ($(this).val() != $(this).val().replace(/[^a-z0-9 -]/gi, '')) {
                        $(this).val($(this).val().replace(/[^a-z0-9 -]/gi, ''));
                    }
                });

            <?php endif ?>

        });



    </script>

</div>