<?php

$errors = array(
	'success' => 'OK',
	'failed' => 'Het is niet gelukt uw bericht te verzenden. Probeer het later nog een keer.',
	'recaptcha' => 'Typ de captcha code juist over.',
	'general' => 'Je hebt niet alle velden ingevuld. Controleer de velden.',
	'email' => 'Je e-mailadres blijkt niet te kloppen. Controleer je e-mailadres.'
);

$sites_configs = array(
	'vetverbrandgeheimen.nl' => array(
		'organization_name' => 'Helpdesk Richard Ridder',
		'organization_email' => 'info@vetverbrandgeheimen.nl',
		'errors' => $errors
	),
	'afslankreceptenbijbel.nl' => array(
		'organization_name' => 'Afslankreceptenbijbel',
		'organization_email' => 'info@afslankreceptenbijbel.nl',
		'errors' => $errors
	),
	'strakkebuikbijbel.nl' => array(
		'organization_name' => 'Strakkebuikbijbel.nl',
		'organization_email' => 'info@strakkebuikbijbel.nl',
		'errors' => $errors
	)
);

// enable crossdomain ajax requests
function send_access_headers() {
	header('Access-Control-Allow-Origin: ' . $_SERVER['HTTP_ORIGIN']);
    header('Access-Control-Allow-Methods: GET, POST');
    header('Access-Control-Max-Age: 1000');
    header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
}
send_access_headers();

function get_siteconf() {
	global $sites_configs;
	$domain = parse_url($_SERVER['HTTP_REFERER'], PHP_URL_HOST);
	if ($conf = $sites_configs[$domain]) {
		return $conf;
	}
	die('siteconf not found');
}

$siteconf = get_siteconf();

function handle_cmd() {
	switch($_POST['cmd']) {
		case 'linkruil':
			handle_linkruil();
	}
}
handle_cmd();


function handle_linkruil() {
	global $siteconf;

	if (senh_recaptcha_check()) {

		$err = null;

		if (!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) $err = $siteconf['errors']['email'];
		else if (strlen($_POST['name']) < 3 || !$_POST['email'] || !$_POST['website'] || !$_POST['message']) $err = $siteconf['errors']['general'];
		
		if (!$err) {

			$subject = 'Linkruil';
			$body = senh_mail_simplebody(array(
				'Van' => $_POST['name'] . ' (' . $_POST['email'] . ')',
				'Website' => $_POST['website'],
				'Bericht' => $_POST['message']
			));

			if (senh_mail('pr@senhdigitalehulpmiddelen.nl', $_POST['email'], $_POST['name'], $subject, $body)) {
				if (senh_mail($siteconf['organization_email'], $_POST['email'], $_POST['name'], $subject, $body)) {
					$err = $siteconf['errors']['success'];
				}
			}
		}

		echo $err ?: $siteconf['errors']['failed'];

	} else {
		echo $siteconf['errors']['recaptcha'];
	}
}