<?php

use DI\ContainerBuilder;
use DI\Container;

if (session_id() == '') {
    session_start();
}

define('PROJECT_ROOT_DIR', realpath(__DIR__.'/..'));
define('LOG_DIR', PROJECT_ROOT_DIR.'/var/log');
define('CACHE_DIR', PROJECT_ROOT_DIR.'/var/cache');
define('ENV_DEV', 'ENV_DEV');
define('ENV_PROD', 'ENV_PROD');

if (file_exists(realpath(__DIR__.'/init_local.php'))) {
    require_once realpath(__DIR__.'/init_local.php');
}

if (!defined('ENV')) {
    define('ENV', ENV_PROD);
}

if (!defined('PROJECT_PUBLIC_DIR')) {
    define('PROJECT_PUBLIC_DIR', PROJECT_ROOT_DIR.'/public_html');
}

if (!defined('SENHPAYMENTS_PUBLIC_DIR')) {
    define('SENHPAYMENTS_PUBLIC_DIR', PROJECT_PUBLIC_DIR);
}

if (!defined('APP_DIR')) {
    define('APP_DIR', PROJECT_ROOT_DIR.'/app');
}

if (!defined('CONFIG_DIR')) {
    define('CONFIG_DIR', APP_DIR.'/config');
}

if (!defined('BLACKLIST_DIR')) {
    define('BLACKLIST_DIR', APP_DIR.'/blacklist');
}

if (!defined('CONTACTFORM_INCLUDES_DIR')) {
    define('CONTACTFORM_INCLUDES_DIR', APP_DIR.'/contactformulier');
}

if (!defined('LIB_DIR')) {
    define('LIB_DIR', PROJECT_ROOT_DIR.'/vendor/senh/lib');
}

if (!defined('LIB_SRC_DIR')) {
    define('LIB_SRC_DIR', LIB_DIR.'/src');
}

if (!defined('LIB_GATEWAYS_DIR')) {
    define('LIB_GATEWAYS_DIR', LIB_SRC_DIR.'/gateways');
}

if (!defined('DB_HOST')) {
    define('DB_HOST', 'localhost');
}

if (!defined('DB_USER')) {
    define('DB_USER', 'salespages_sales');
}

if (!defined('DB_PASSWORD')) {
    define('DB_PASSWORD', 'xO!iue#j9fFo!vePc7');
}

if (!defined('DB_NAME')) {
    define('DB_NAME', 'salespages_sales');
}

if (!defined('SERVER_TIME_ZONE')) {
    define('SERVER_TIME_ZONE', 'Europe/Amsterdam');
}

if (!defined('PAYMENT_TEST_MODE')) {
    define('PAYMENT_TEST_MODE', false);
}

if (!defined('PAYMENT_TEST_IBAN')) {
    define('PAYMENT_TEST_IBAN', false);
}

if (!defined('EMAIL_SUPPORT')) {
    define('EMAIL_SUPPORT', 'info@senhuitgeverij.nl');
}

if (!defined('EMAIL_TECHGUYS')) {
    define('EMAIL_TECHGUYS', 'info@senhuitgeverij.nl,info@websiteopmaat.nl');
}

if (!defined('SENH_PAYMENTS_URL')) {
    define('SENH_PAYMENTS_URL', 'https://senhpayments.nl');
}

define('POSTBACK_URL_DEFAULT', SENH_PAYMENTS_URL.'/postbacks/global/default.php');

if (!defined('PAYMENT_API_KEY')) {
    define('PAYMENT_API_KEY', 'e8bcacece58fbd4fecb9137b3d72a3cf');
}

if (!defined('ACTIVECAMPAIGN_URL')) {
    define('ACTIVECAMPAIGN_URL', 'https://shuitgeverij.api-us1.com');
}

if (!defined('ACTIVECAMPAIGN_API_KEY')) {
    define('ACTIVECAMPAIGN_API_KEY', '6df59ff1092a83e8158ca883afc52177758e69bd898d3ff3692452fc51aa1d8b4d070092');
}

if (!defined('ACTIVECAMPAIGN_AFVALLEN_KLANTEN_LIST_ID')) {
    define('ACTIVECAMPAIGN_AFVALLEN_KLANTEN_LIST_ID', 6);
}

if (!defined('ACTIVECAMPAIGN_AFVALLEN_KLANTEN_LIST_ID_DE')) {
    define('ACTIVECAMPAIGN_AFVALLEN_KLANTEN_LIST_ID_DE', 32);
}


if (!defined('PRODUCT_ID_ARB_DIGITAAL')) {
    define('PRODUCT_ID_ARB_DIGITAAL', 38520);
}

if (!defined('PRODUCT_ID_ARB_FYSIEK')) {
    define('PRODUCT_ID_ARB_FYSIEK', 21142);
}

if (!defined('PRODUCT_ID_SMT_DIGITAAL')) {
    define('PRODUCT_ID_SMT_DIGITAAL', 47094);
}

if (!defined('PRODUCT_ID_SBB_DIGITAAL')) {
    define('PRODUCT_ID_SBB_DIGITAAL', 20138);
}

if (!defined('PRODUCT_ID_SBB_FYSIEK')) {
    define('PRODUCT_ID_SBB_FYSIEK', 37542);
}

if (!defined('PRODUCT_ID_SAB_DIGITAAL')) {
    define('PRODUCT_ID_SAB_DIGITAAL', 46945);
}

if (!defined('PRODUCT_ID_SAB_FYSIEK')) {
    define('PRODUCT_ID_SAB_FYSIEK', 46948);
}

if (!defined('PRODUCT_ID_S15M_DIGITAAL')) {
    define('PRODUCT_ID_S15M_DIGITAAL', 52221);
}

if (!defined('PRODUCT_ID_S15M_FYSIEK')) {
    define('PRODUCT_ID_S15M_FYSIEK', 49151);
}

if (!defined('PRODUCT_ID_S5I_DIGITAAL')) {
    define('PRODUCT_ID_S5I_DIGITAAL', 54722);
}

if (!defined('PRODUCT_ID_S5I_FYSIEK')) {
    define('PRODUCT_ID_S5I_FYSIEK', 52861);
}

if (!defined('PRODUCT_ID_BDA_DIGITAAL')) {
    define('PRODUCT_ID_BDA_DIGITAAL', 54752);
}

if (!defined('PRODUCT_ID_BDA_FYSIEK')) {
    define('PRODUCT_ID_BDA_FYSIEK', 54746);
}

if (!defined('PRODUCT_ID_GTE_MND_FYSIEK')) {
    define('PRODUCT_ID_GTE_MND_FYSIEK', 55209);
}

if (!defined('PRODUCT_ID_GTE_3MND_FYSIEK')) {
    define('PRODUCT_ID_GTE_3MND_FYSIEK', 56095);
}

if (!defined('PRODUCT_ID_GTE_6MND_FYSIEK')) {
    define('PRODUCT_ID_GTE_6MND_FYSIEK', 56519);
}

if (!defined('PRODUCT_ID_GMN_MND_FYSIEK')) {
    define('PRODUCT_ID_GMN_MND_FYSIEK', 57518);
}

if (!defined('PRODUCT_ID_GMN_3MND_FYSIEK')) {
    define('PRODUCT_ID_GMN_3MND_FYSIEK', 57606);
}

if (!defined('PRODUCT_ID_GMN_6MND_FYSIEK')) {
    define('PRODUCT_ID_GMN_6MND_FYSIEK', 58009);
}

if (!defined('PRODUCT_ID_JMQUIZ')) {
    define('PRODUCT_ID_JMQUIZ', 69738);
}

if (!defined('GEO_AUTH_KEY')) {
    define('GEO_AUTH_KEY', 'sjKzDcQnMUci8F5j');
}

if (!defined('GOOGLE_RECAPTCHA_SITE')) {
    define('GOOGLE_RECAPTCHA_SITE', '6Lf5XDQUAAAAABnCm_bGcVSXEL5jt-Bg1CuOkDRX');
}

if (!defined('GOOGLE_RECAPTCHA_SECRET')) {
    define('GOOGLE_RECAPTCHA_SECRET', '6Lf5XDQUAAAAAKJRQa-idpz46SAD04d11qneR3LM');
}

if (!defined('USE_SENH_ERROR_HANDLER')) {
    define('USE_SENH_ERROR_HANDLER', false);
}


//require_once PROJECT_ROOT_DIR.'/senh.fn.php';
require_once LIB_SRC_DIR .'/functions/senh.fn.php';
require LIB_GATEWAYS_DIR . '/fn.php';
require_once PROJECT_ROOT_DIR.'/vendor/autoload.php';

if (USE_SENH_ERROR_HANDLER) {
    $errorHandler = \Senh\Errors\ErrorHandler::getInstance();
    $errorHandler->handleErrors();
    $errorHandler->logRequest();
}


/**
 * @var Container $container
 */
global $container;
$container = (new ContainerBuilder())->build();

// for convenience, instantiate services that are used all over the place in include scripts
$internalProductManager = $container->get(\Senh\Lib\Managers\InternalProductManager::class);
$pricesHelper = $container->get(\Senh\Lib\Prices\PricesHelper::class);
$countDownHelper = $container->get(\Senh\Lib\Prices\CountDownHelper::class);
$bonusesFactory = $container->get(\Senh\Lib\Bonuses\BonusesFactory::class);
$kortingFactory = $container->get(\Senh\Lib\Prices\KortingFactory::class);
$nextSellHelper = $container->get(\Senh\Lib\NextSell\NextSellHelper::class);

include_once CONFIG_DIR.'/internalProductModels.php';
$internalProductManager->setInternalProductModels($internalProductModels);

include_once CONFIG_DIR.'/kortingModels.php';
$kortingFactory->setAvailableKortingModels($kortingModels);