// Bestaat de cookie myClock, gebruik dan de waaarde uit de cookie voor de deadline
if(document.cookie && document.cookie.match('myClock')){
  // haal deadline waarde op uit cookie
  var deadline = document.cookie.replace(/(?:(?:^|.*;\s*)myClock\s*\=\s*([^;]*).*$)|^.*$/, "$1");
}

// zo niet, maak dan een nieuwe deadline aan
// en sla deze op in de cookie myClock
else{
  var timeInDays = 7;
  var currentTime = Date.parse(new Date());
  var deadline = new Date(currentTime + timeInDays*24*3600*1000);

  // Sla deadline op in cookie
  document.cookie = 'myClock=' + deadline + '; path=/; domain=.fitness-tips.nl';
}

function getTimeRemaining(endtime){
  var t = Date.parse(endtime) - Date.parse(new Date());
  var seconds = Math.floor( (t/1000) % 60 );
  var minutes = Math.floor( (t/1000/60) % 60 );
  var hours = Math.floor( (t/(1000*60*60)) % 24 );
  var days = Math.floor( t/(1000*60*60*24) );
  return {
    'total': t,
    'days': days,
    'hours': hours,
    'minutes': minutes,
    'seconds': seconds
  };
}


function initializeClock(id, endtime){
  var clock = document.getElementById(id);
  var daysSpan = clock.querySelector('.days');
  var hoursSpan = clock.querySelector('.hours');
  var minutesSpan = clock.querySelector('.minutes');
  var secondsSpan = clock.querySelector('.seconds');

  $(".buy-banner.countdown").css({'display':'inherit'});

  function updateClock(){
    var t = getTimeRemaining(endtime);

    daysSpan.innerHTML = t.days;
    hoursSpan.innerHTML = ('0' + t.hours).slice(-2);
    minutesSpan.innerHTML = ('0' + t.minutes).slice(-2);
    secondsSpan.innerHTML = ('0' + t.seconds).slice(-2);


    if(t.total<=0){
      clearInterval(timeinterval);
      daysSpan.innerHTML = '0';
      hoursSpan.innerHTML = '0';
      minutesSpan.innerHTML = '0';
      secondsSpan.innerHTML = '0';
      $("#korting").val("nee");
    }
  }
  updateClock(); // run function once at first to avoid delay
  var timeinterval = setInterval(updateClock,1000);
}