<?php

class SelectQuerySenh extends SelectQuery
{
    public function addSelectQueryWhere(SelectQuerySenh $partial)
    {
        $condition = "({$partial->buildWhere()})";
        $parameters = $partial->getWhereParameters();
        $parameters = array_merge(array($condition), $parameters);
        call_user_func_array(array($this, 'where'), $parameters);

        return $this;
    }

    public function setWhereGlue($andOr = 'AND')
    {
        $this->clauses['WHERE'] = ' ' . $andOr . ' ';
    }

    public function getWhere()
    {
        return $this->statements['WHERE'];
    }

    public function getWhereParameters()
    {
        return $this->parameters['WHERE'];
    }

    protected function buildWhere()
    {
        $separator = $this->clauses['WHERE'];
        return implode($separator, $this->statements['WHERE']);
    }
}