<?php

namespace Senh\Lib\Models;

class InternalProductPropertiesModel
{
    const PRODUCT_CATEGORY_FOOD = 'PRODUCT_CATEGORY_FOOD';
    const PRODUCT_CATEGORY_BOOK = 'PRODUCT_CATEGORY_BOOK';
    const PRODUCT_CATEGORY_PROGRAM = 'PRODUCT_CATEGORY_PROGRAM';
    const PRODUCT_TYPE_DIGITAL = 'PRODUCT_TYPE_DIGITAL';
    const PRODUCT_TYPE_PHYSICAL = 'PRODUCT_TYPE_PHYSICAL';

    /**
     * see consts PRODUCT_CATEGORY_..
     * @var string
     */
    protected $productCategory;

    /**
     * see consts PRODUCT_TYPE_..
     * @var string
     */
    protected $productType;

    /**
     * @var array
     */
    protected $prices;

    /**
     * @var array
     */
    protected $commissions;

    /**
     * @var string[]: ac list tags
     */
    protected $listTags;

    /**
     * ac list id
     * @var int|null
     */
    protected $listId;

    /**
     * InternalProductPropertiesModel constructor.
     * @param string $productCategory
     * @param string $productType
     * @param int|array $prices
     * @param int|array $commissions
     * @param string|string[] $listTags
     * @param int|string|null $listId
     */
    public function __construct(
        $productCategory,
        $productType,
        $prices,
        $commissions,
        $listTags = null,
        $listId = null
    )
    {
        $this->productCategory = $productCategory;
        $this->productType = $productType;
        $this->prices = (array)$prices;
        $this->commissions = (array)$commissions;
        $this->listTags = $listTags ? (array)$listTags : null;
        $this->listId = $listId;
    }

    /**
     * @return string
     */
    public function getProductCategory()
    {
        return $this->productCategory;
    }

    /**
     * @param string $productCategory
     */
    public function setProductCategory($productCategory)
    {
        $this->productCategory = $productCategory;

        return $this;
    }

    /**
     * @return string
     */
    public function getProductType()
    {
        return $this->productType;
    }

    /**
     * @param string $productType
     */
    public function setProductType($productType)
    {
        $this->productType = $productType;

        return $this;
    }

    /**
     * @return array
     */
    public function getPrices()
    {
        return $this->prices;
    }

    public function getPrice($variant = null)
    {
        return isset($this->prices[$variant]) ? $this->prices[$variant] : reset($this->prices);
    }

    /**
     * @param array|int $prices
     */
    public function setPrices($prices)
    {
        $this->prices = (array)$prices;

        return $this;
    }

    /**
     * @return array
     */
    public function getCommissions()
    {
        return $this->commissions;
    }

    public function getCommission($variant = null)
    {
        return isset($this->commissions[$variant]) ? $this->commissions[$variant] : reset($this->commissions);
    }


    /**
     * @param array|int $commissions
     */
    public function setCommissions($commissions)
    {
        $this->commissions = (array)$commissions;

        return $this;
    }

    /**
     * @return array
     */
    public function getListTags()
    {
        return $this->listTags;
    }

    /**
     * @param array|string $listTags
     */
    public function setListTags($listTags)
    {
        $this->listTags = (array)$listTags;

        return $this;
    }

    /**
     * @return int
     */
    public function getListId()
    {
        return $this->listId;
    }

    /**
     * @param int $listId
     */
    public function setListId($listId)
    {
        $this->listId = $listId;

        return $this;
    }

}
