<?php

/**
 * Class SaleModel
 * Pay pro sale model
 */
class SaleModel extends BaseModel
{

    /**
     * States
     * Alle overige statusen kan je hetzelfde beschouwen als 'active'.
     */
    const STATUS_OPEN = 'open'; // Nog geen betaling ontvangen
    const STATUS_ACTIVE = 'active'; // Bezig met verwerken van de betaling
    const STATUS_CANCELED = 'cancelled'; // Betaling is geannuleerd
    const STATUS_COMPLETED = 'completed'; // Betaling is succesvol en het saldo is geupdate in je account
    const STATUS_PAUSED = 'paused'; // Betaling tijdelijk stop gezet

    /**
     * @var SequenceModel[]
     */
    protected $sequences;

    /**
     * @var array
     */
    protected $originalData;

    /**
     * @var int
     */
    protected $totalPausedDays;

    /**
     * @var int
     */
    protected $amountTotal;

    /**
     * @var string
     */
    protected $description;

    /**
     * @var string
     */
    protected $invoiceMethod;

    /**
     * @var int
     */
    protected $lastSuccessfulSeq;

    /**
     * @var string
     */
    protected $city;

    /**
     * @var int
     */
    protected $productId;

    /**
     * @var DateTime
     */
    protected $date;

    /**
     * @var string
     */
    protected $iban;

    /**
     * @var string
     */
    protected $periodDuration;

    /**
     * @var int
     */
    protected $priceRecurring;

    /**
     * @var string
     */
    protected $currentStatus;

    /**
     * @var int
     */
    protected $amountTotalAffiliate;

    /**
     * @var int
     */
    protected $priceInitial;

    /**
     * @var string
     */
    protected $countryCode;

    /**
     * @var int
     */
    protected $amountAffiliateRecurring;

    /**
     * @var int
     */
    protected $amountAffiliateInitial;

    /**
     * @var int
     */
    protected $affiliate;

    /**
     * @var string
     */
    protected $orderQuantity;

    /**
     * @var string
     */
    protected $total;

    /**
     * @var string
     */
    protected $numberOfPeriods;

    /**
     * @var int
     */
    protected $vat;

    /**
     * @var int
     */
    protected $currentNumberOfPeriods;

    /**
     * @var string
     */
    protected $remarks;

    /**
     * @var string
     */
    protected $fullName;

    /**
     * @var string
     */
    protected $email;

    /**
     * @var string
     */
    protected $ibanCountry;

    /**
     * @var bool
     */
    protected $externalAffiliateSale;

    /**
     * SaleModel constructor.
     *
     * @param array $data
     */
    public function __construct($data)
    {
        $this->originalData = $data;
        $this->id = ModelHelper::fixPayproId($data['id']);
        $this->description = $data['description'];
        $this->totalPausedDays = (int)$data['total_paused_days'];
        $this->amountTotal = (int)$data['amount_total'];
        $this->invoiceMethod = isset($data['invoice_method']) ? $data['invoice_method'] : $data['invoicemethod'];
        $this->lastSuccessfulSeq = (int)$data['last_successful_seq'];
        $this->city = ($data['city']) == 'Plaats' ? null: $data['city'];
        $this->productId = (int)$data['product_id'];
        $this->date = ModelHelper::fromPayproDate($data['date']);
        $this->iban = $data['iban'];
        $this->ibanCountry = $this->iban ? substr($this->iban, 0, 2) : null;
        $this->ibanCountry = isset($data['iban_country']) ? $data['iban_country'] : $this->ibanCountry;
        $this->ibanCountry = $this->ibanCountry ? strtoupper($this->ibanCountry) : null;
        $this->periodDuration = $data['period_duration'];
        $this->priceRecurring = (int)$data['price_recurring'];
        $this->currentStatus = $data['current_status'];
        $this->amountTotalAffiliate = (int)$data['amount_total_affiliate'];
        $this->priceInitial = (int)$data['price_initial'];
        $this->countryCode = $data['country_code'];
        if (!$this->countryCode && isset($data['postal'])) {
            if (StringHelper::isDutchPostalCode($data['postal'])) {
                $this->countryCode = 'NL';
            } elseif (StringHelper::isBelgianPostalCode($data['postal'])) {
                $this->countryCode = 'BE';
            }
        }
        $this->amountAffiliateRecurring = (int)$data['amount_affiliate_recurring'];
        $this->amountAffiliateInitial = (int)$data['amount_affiliate_initial'];
        $this->affiliate = (int) $data['affiliate'];
        $this->orderQuantity = $data['order_quantity'];
        $this->total = $data['total'];
        $this->numberOfPeriods = $data['number_of_periods'];
        $this->vat = (int) $data['vat'];
        $this->currentNumberOfPeriods = (int) $data['current_number_of_periods'];
        $this->remarks = $data['remarks'];
        $this->email = $data['emailaddress'];
        $this->fullName = trim($data['firstname'].' '.$data['lastname']);
    }

    public function getSequence($sequenceNumber)
    {
        if ($this->sequences) {
            foreach ($this->getSequences() as $sequence) {
                if ($sequence->getSequenceNumber() == $sequenceNumber) {
                    return $sequence;
                }
            }
        }

        return null;
    }

    /**
     * @return SequenceModel[]
     */
    public function getSequences()
    {
        return $this->sequences;
    }

    /**
     * @param SequenceModel[] $sequences
     */
    public function setSequences($sequences)
    {
        if ($sequences) {
            foreach ($sequences as $sequence) {
                $sequence->setSale(($this));
            }
        }

        $this->sequences = $sequences;
    }

    /**
     * @return array
     */
    public function getOriginalData()
    {
        return $this->originalData;
    }

    /**
     * @param array $originalData
     */
    public function setOriginalData($originalData)
    {
        $this->originalData = $originalData;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return int
     */
    public function getTotalPausedDays()
    {
        return $this->totalPausedDays;
    }

    /**
     * @param int $totalPausedDays
     */
    public function setTotalPausedDays($totalPausedDays)
    {
        $this->totalPausedDays = $totalPausedDays;
    }

    /**
     * @return int
     */
    public function getAmountTotal()
    {
        return $this->amountTotal;
    }

    /**
     * @param int $amountTotal
     */
    public function setAmountTotal($amountTotal)
    {
        $this->amountTotal = $amountTotal;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string $description
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }

    public function getProductName()
    {
        $descriptionToName = array(
            'ETM-Edwin Edinga' => 'Ex Terug Methode',
            'ETM door Edwin Edinga' => 'Ex Terug Methode',
            'CEC-Chris Coster' => 'Complete Ejaculatie Controle',
            'CEC door Chris Coster' => 'Complete Ejaculatie Controle',
            'CEC2-Chris Coster' => 'Complete Erectie Controle',
            'CEC2 door Chris Coster' => 'Complete Erectie Controle',
            'Afslank Receptenbijb' => 'Afslank Receptenbijbel',
            'AfslankReceptenbijbel' => 'Afslank Receptenbijbel',
            'AfslankReceptenbijb' => 'Afslank Receptenbijbel',
            'GeldGorillaGeheimen' => 'Geld Gorilla Geheimen',
            'Geld Gorilla Geheimen' => 'Geld Gorilla Geheimen',
            'DRSM-Jonathan Oscar' => 'De Revolutionaire Seks Methode',
            'DRSM door JonathanOscar' => 'De Revolutionaire Seks Methode',
            'VVV-Jonathan Oscar' => 'Vandaag Vrouwen Versieren',
            'VVV door JonathanOscar' => 'Vandaag Vrouwen Versieren',
            'IDF-Jonathan Oscar' => 'Internet Dating Formule',
            'IDF door JonathanOscar' => 'Internet Dating Formule',
            'HUVP-Jonathan Oscar ' => 'Het Ultieme Versier Programma',
            'Het Ultieme Versier Programma' => 'Het Ultieme Versier Programma',
            'SmoothieReceptenbijb' => 'Smoothie Receptenbijbel',
            'Smoothie Receptenbijbel' => 'Smoothie Receptenbijbel',
            'VetVerbrandGeheimen' => 'Vet Verbrand Geheimen',
            'Vet Verbrand Geheimen' => 'Vet Verbrand Geheimen',
            'Strakke Buik Bijbel' => 'Strakke Buik Bijbel',
            'Buikspieren Bijbel' => 'Strakke Buik Bijbel',
            'Vlug Bevrucht' => 'Vlug Bevrucht',
            'SZ-Simon Zomerdijk' => 'Sociaal Zelfvertrouwen',
            'SZ door Simon Zomerdijk' => 'Sociaal Zelfvertrouwen',
            'ETG Programma' => 'Ex Terug Geheimen Programma',
            'OK Programma' => 'Orgasme Koning Programma',
            'AllesGroeneSmoothies' => 'Alles Over Groene Smoothies',
            'Alles Over Groene Smoothies' => 'Alles Over Groene Smoothies',
            'Gespierde God' => 'Gespierde God',
            'Zorgeloos Zwanger' => 'Zorgeloos Zwanger',
            'LV-Edwin Edinga' => 'Liefdesverdriet Voorbij',
            'IS-Edwin Edinga' => 'Ideaal Seksleven',
            'Ideaal Seksleven' => 'Ideaal Seksleven',
            'Verover en Houd Hem' => 'Verover en Houd Hem',
            'UltiemeAfslankProgr' => 'Het Ultieme Afslank Programma',
            'Het Ultieme Afslank Programma' => 'Het Ultieme Afslank Programma',
            'WinstMaximalisator' => 'De Ultieme Winst Maximalisator',
            'De Ultieme Winst Maximalisator' => 'De Ultieme Winst Maximalisator',
            'BuikspierSuccesform' => 'Buikspier Succesformule',
            'Buikspier Succesformule' => 'Buikspier Succesformule',
            'IdealeRelatieProgr' => 'Het Ideale Relatie Programma',
            'Ideale Relatie Programma' => 'Het Ideale Relatie Programma',
            'AltijdBeheersingProg' => 'Het Voor Altijd Beheersing Programma',
            'HVAB Programma' => 'Het Voor Altijd Beheersing Programma',
            'BuikprobleemOpgelost' => 'Buikproblemen Opgelost',
            'Buikproblemen Opgelost' => 'Buikproblemen Opgelost',
            'SmoothieAfslankbijb' => 'Smoothie Afslankbijbel',
            'SlankMetToetjes' => 'Slank Met Toetjes',
            'SlankIn15Minuten' => 'Slank In 15 Minuten',
            'SlankIn5Ingred' => 'Slank In 5 Ingrediënten',
            'LekkerZwangerWorden' => 'Lekker Zwanger Worden',
        );

        $productName = $this->getDescription();
        foreach ($descriptionToName as $description => $name) {
            if (strpos(strtolower($this->getDescription()),strtolower($description)) !== false) {
                $productName = $name;
                break;
            }
        }

        return $productName;
    }

    /**
     * @return string
     */
    public function getInvoiceMethod()
    {
        return $this->invoiceMethod;
    }

    /**
     * @param string $invoiceMethod
     */
    public function setInvoiceMethod($invoiceMethod)
    {
        $this->invoiceMethod = $invoiceMethod;
    }

    /**
     * @return int
     */
    public function getLastSuccessfulSeq()
    {
        return $this->lastSuccessfulSeq;
    }

    /**
     * @param int $lastSuccessfulSeq
     */
    public function setLastSuccessfulSeq($lastSuccessfulSeq)
    {
        $this->lastSuccessfulSeq = $lastSuccessfulSeq;
    }

    /**
     * @return string
     */
    public function getCity($allowPlaceholder = true)
    {
        if ($allowPlaceholder) {
            return $this->city;
        }

        return trim($this->city) !== 'Plaats' && trim($this->city) !== 'NOT PROVIDED' ? $this->city : null;
    }

    /**
     * @param string $city
     */
    public function setCity($city)
    {
        $this->city = $city;
    }

    /**
     * @return int
     */
    public function getProductId()
    {
        return $this->productId;
    }

    /**
     * @param int $productId
     */
    public function setProductId($productId)
    {
        $this->productId = $productId;
    }

    /**
     * @return DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param DateTime $date
     */
    public function setDate($date)
    {
        $this->date = $date;
    }

    /**
     * @return string
     */
    public function getIban()
    {
        return $this->iban;
    }

    /**
     * @param string $iban
     */
    public function setIban($iban)
    {
        $this->iban = $iban;
    }

    public function hasIban()
    {
        return $this->iban !== null;
    }

    /**
     * @return string
     */
    public function getPeriodDuration()
    {
        return $this->periodDuration;
    }

    /**
     * @param string $periodDuration
     */
    public function setPeriodDuration($periodDuration)
    {
        $this->periodDuration = $periodDuration;
    }

    /**
     * @return int
     */
    public function getPriceRecurring()
    {
        return $this->priceRecurring;
    }

    /**
     * @param int $priceRecurring
     */
    public function setPriceRecurring($priceRecurring)
    {
        $this->priceRecurring = $priceRecurring;
    }

    /**
     * @return string
     */
    public function getCurrentStatus()
    {
        return $this->currentStatus;
    }

    /**
     * @param string $currentStatus
     */
    public function setCurrentStatus($currentStatus)
    {
        $this->currentStatus = $currentStatus;
    }

    /**
     * @return int
     */
    public function getAmountTotalAffiliate()
    {
        return $this->amountTotalAffiliate;
    }

    /**
     * @param int $amountTotalAffiliate
     */
    public function setAmountTotalAffiliate($amountTotalAffiliate)
    {
        $this->amountTotalAffiliate = $amountTotalAffiliate;
    }

    /**
     * @return int
     */
    public function getPriceInitial()
    {
        return $this->priceInitial;
    }

    /**
     * @param int $priceInitial
     */
    public function setPriceInitial($priceInitial)
    {
        $this->priceInitial = $priceInitial;
    }

    /**
     * @return string
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }

    /**
     * @param string $countryCode
     */
    public function setCountryCode($countryCode)
    {
        $this->countryCode = $countryCode;
    }

    /**
     * @return int
     */
    public function getAmountAffiliateRecurring()
    {
        return $this->amountAffiliateRecurring;
    }

    /**
     * @param int $amountAffiliateRecurring
     */
    public function setAmountAffiliateRecurring($amountAffiliateRecurring)
    {
        $this->amountAffiliateRecurring = $amountAffiliateRecurring;
    }

    /**
     * @return int
     */
    public function getAmountAffiliateInitial()
    {
        return $this->amountAffiliateInitial;
    }

    /**
     * @param int $amountAffiliateInitial
     */
    public function setAmountAffiliateInitial($amountAffiliateInitial)
    {
        $this->amountAffiliateInitial = $amountAffiliateInitial;
    }

    /**
     * @return int
     */
    public function getAffiliate()
    {
        return $this->affiliate;
    }

    /**
     * @param int $affiliate
     */
    public function setAffiliate($affiliate)
    {
        $this->affiliate = $affiliate;
    }

    /**
     * @return string
     */
    public function getOrderQuantity()
    {
        return $this->orderQuantity;
    }

    /**
     * @param string $orderQuantity
     */
    public function setOrderQuantity($orderQuantity)
    {
        $this->orderQuantity = $orderQuantity;
    }

    /**
     * @return string
     */
    public function getTotal()
    {
        return $this->total;
    }

    /**
     * @param string $total
     */
    public function setTotal($total)
    {
        $this->total = $total;
    }

    /**
     * @return string
     */
    public function getNumberOfPeriods()
    {
        return $this->numberOfPeriods;
    }

    /**
     * @param string $numberOfPeriods
     */
    public function setNumberOfPeriods($numberOfPeriods)
    {
        $this->numberOfPeriods = $numberOfPeriods;
    }

    /**
     * @return int
     */
    public function getVat()
    {
        return $this->vat;
    }

    /**
     * @param int $vat
     */
    public function setVat($vat)
    {
        $this->vat = $vat;
    }

    /**
     * @return int
     */
    public function getCurrentNumberOfPeriods()
    {
        return $this->currentNumberOfPeriods;
    }

    /**
     * @param int $currentNumberOfPeriods
     */
    public function setCurrentNumberOfPeriods($currentNumberOfPeriods)
    {
        $this->currentNumberOfPeriods = $currentNumberOfPeriods;
    }

    /**
     * @return string
     */
    public function getRemarks()
    {
        return $this->remarks;
    }

    /**
     * @param string $remarks
     */
    public function setRemarks($remarks)
    {
        $this->remarks = $remarks;
    }

    /**
     * @return string
     */
    public function getFullName()
    {
        return $this->fullName;
    }

    /**
     * @param string $fullName
     */
    public function setFullName($fullName)
    {
        $this->fullName = $fullName;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     */
    public function setEmail($email)
    {
        $this->email = $email;
    }

    /**
     * True for both recurring AND fixed numberOfPeriods > 1
     * @return bool
     */
    public function hasMultiplePayments()
    {
        return $this->numberOfPeriods !== 1;
    }

    public function hasStatusCompleted()
    {
        return $this->currentStatus === self::STATUS_COMPLETED;
    }

    public function hasStatusOpen()
    {
        return $this->currentStatus === self::STATUS_OPEN;
    }

    /**
     * Alle overige statusen kan je hetzelfde beschouwen als 'active'.
     * @return bool
     */
    public function hasStatusActive()
    {
        return
            $this->currentStatus !== self::STATUS_CANCELED &&
            $this->currentStatus !== self::STATUS_COMPLETED &&
            $this->currentStatus !== self::STATUS_OPEN &&
            $this->currentStatus !== self::STATUS_PAUSED;
    }

    /**
     * @param string $ibanCountry
     */
    public function setIbanCountry($ibanCountry)
    {
        $this->ibanCountry = $ibanCountry;
    }


    public function getIbanCountry()
    {
        return $this->ibanCountry;
    }

    /**
     * @return bool
     */
    public function isOpname()
    {
        return $this->amountTotal < 0;
    }
}