<?php

class TransactionModel extends BaseModel
{
    const DESCRIPTION_STORNERINGSKOSTEN = 'Storneringskosten';

    /**
     * The db id
     * @var int
     */
    protected $id;

    /**
     * @var int
     */
    protected $sequenceId;

    /**
     * @var SequenceModel
     */
    protected $sequence;

    /**
     * @var int
     */
    protected $saleId;

    /**
     * @var SaleModel
     */
    protected $sale;

    /**
     * @var int
     */
    protected $transactionId;

    /**
     * In case of orphan transactions (without a sequence), a single transaction can be attached
     * @var TransactionModel
     */
    protected $transaction;

    /**
     * @var int
     */
    protected $sequenceNumber;

    /**
     * @var
     */
    protected $description;

    /**
     * @var int
     */
    protected $amount;

    /**
     * @var int
     */
    protected $costs;

        /**
     * @var DateTime
     */
    protected $date;

    /**
     * @var int
     */
    protected $payproInternalId;

    /**
     * @var int
     */
    protected $balanceBefore;

    /**
     * @var DateTime
     */
    protected $createdAt;

    /**
     * @var DateTime
     */
    protected $updatedAt;

    /**
     * @var array
     */
    protected $originalData;

    /**
     * SaleModel constructor.
     *
     * @param array $data
     */
    public function __construct($data)
    {
        $this->originalData = $data;

        $this->id = null;
        $this->sequenceId = null;
        $this->sequenceNumber = (int)$data['sequence_number'];
        $this->saleId = ModelHelper::fixPayproId($data['sale_id']);
        $this->amount = (int)$data['amount'];
        $this->costs = (int)$data['costs'];
        $this->date = ($data['date'] instanceof DateTime) ? $data['date'] : DateHelper::fromIsoDateFormat($data['date']);
        $this->description = $data['description'];
        $this->payproInternalId = (int)$data['paypro_internal_id'];
        $this->balanceBefore = (int)$data['balance_before'];
    }

    /**
     * @return SequenceModel
     */
    public function getSequence()
    {
        return $this->sequence;
    }

    /**
     * @param SequenceModel $sequence
     */
    public function setSequence($sequence)
    {
        $this->sequence = $sequence;
    }

    /**
     * @return SaleModel
     */
    public function getSale()
    {
        return $this->sale;
    }

    /**
     * @param SaleModel $sale
     */
    public function setSale($sale)
    {
        $this->sale = $sale;
    }

    /**
     * @return int
     */
    public function getSaleId()
    {
        return $this->saleId;
    }

    /**
     * @param int $saleId
     */
    public function setSaleId($saleId)
    {
        $this->saleId = $saleId;
    }

    /**
     * @return int
     */
    public function getSequenceId()
    {
        return $this->sequenceId;
    }

    /**
     * @param int $sequenceId
     */
    public function setSequenceId($sequenceId)
    {
        $this->sequenceId = $sequenceId;
    }

    /**
     * @return int
     */
    public function getSequenceNumber()
    {
        return $this->sequenceNumber;
    }

    /**
     * @param int $sequenceNumber
     */
    public function setSequenceNumber($sequenceNumber)
    {
        $this->sequenceNumber = $sequenceNumber;
    }

    /**
     * @return int
     */
    public function getTransactionId()
    {
        return $this->transactionId;
    }

    /**
     * @param int $transactionId
     */
    public function setTransactionId($transactionId)
    {
        $this->transactionId = $transactionId;
    }

    /**
     * @return TransactionModel
     */
    public function getTransaction()
    {
        return $this->transaction;
    }

    /**
     * @param TransactionModel $transaction
     */
    public function setTransaction($transaction)
    {
        $this->transaction = $transaction;
    }

    /**
     * @return mixed
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param mixed $description
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }

    /**
     * @return int
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param int $amount
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;
    }

    /**
     * @return int
     */
    public function getCosts()
    {
        return $this->costs;
    }

    /**
     * @param int $costs
     */
    public function setCosts($costs)
    {
        $this->costs = $costs;
    }

    /**
     * @return DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param DateTime $date
     */
    public function setDate($date)
    {
        $this->date = $date;
    }

    /**
     * @return int
     */
    public function getPayproInternalId()
    {
        return $this->payproInternalId;
    }

    /**
     * @param int $payproInternalId
     */
    public function setPayproInternalId($payproInternalId)
    {
        $this->payproInternalId = $payproInternalId;
    }

    /**
     * @return int
     */
    public function getBalanceBefore()
    {
        return $this->balanceBefore;
    }

    /**
     * @param int $balanceBefore
     */
    public function setBalanceBefore($balanceBefore)
    {
        $this->balanceBefore = $balanceBefore;
    }

    /**
     * @return array
     */
    public function getOriginalData()
    {
        return $this->originalData;
    }

    /**
     * @param array $originalData
     */
    public function setOriginalData($originalData)
    {
        $this->originalData = $originalData;
    }
}