<?php

if (!function_exists('get_sale_defaults')) {
	trigger_error('function get_sale_defaults() is not yet implemented', E_USER_ERROR);
}

// opdr 97
if (isset($_GET['kortingscode'])) {
	$p = explode('?id=', $_GET['kortingscode']);
	$_GET['kortingscode'] = current($p);
	$_GET['id'] = $p[1];
}

// limit length of ?pn=
if (isset($_GET['pn'])) {
	$_GET['pn'] = substr($_GET['pn'], 0, 3);
}

if ($_COOKIE['pn'] && !isset($_GET['pn'])) {
	$_GET['pn'] = substr($_COOKIE['pn'], 0, 3);
} else if (!isset($_COOKIE['pn']) && isset($_GET['pn'])) {
	setcookie('pn', substr($_GET['pn'], 0, 3), time()+3600*24*365);
}

function get_aff_id() {
	if (isset($_GET['id'])) {
		setcookie('affid', $_GET['id'], time()+3600*12);
		return $_GET['id'];
	}
	return $_COOKIE['affid'] ?: null;
}

/**
 * Bootstrap multiple packages
 * @param $saleIds
 * @param $currentSaleId
 * @param array $blacklists
 * @param string|null $variant : if not null override this property on each sale
 */
function sale_bootstrap_multiple($saleIds, $currentSaleId, $blacklists = array(), $variant = 'default')
{
    foreach ($saleIds as $saleId) {
        sale_bootstrap($saleId, $blacklists, $variant);
    }

    sale_id($currentSaleId);
}

/**
 * @param $sale_id
 * @param array $blacklists
 * @param string|null $variant : if not null override
 */
function sale_bootstrap($sale_id, $blacklists = array(), $variant = 'default') {
	sale_id($sale_id);
	sale_setup();
    $productId = get_sale()['productID'];
    if ($variant !== null) {
        set_sale_data('variant', $variant);
        set_variant_for_product_id($productId, $variant);
    }

	foreach ($blacklists as $blacklist) {
		include_blacklist_affiliate($blacklist);
	}

	sale_setup_done();
}

function sale_empty()
{
    $sale_id = null;
    if (isset($_SESSION['sale_id'])) {
        unset($_SESSION['sale_id']);
    }

    if (isset($_SESSION['sale'])) {
        unset($_SESSION['sale']);
    }

}

/**
 * @param array|null $sale_setup
 * @param bool $refresh
 */
function sale_setup(array $sale_setup = null, $refresh = false) {
	global $sale_id;

	if (!isset($sale_id)) {
		trigger_error('sale_id() has not yet been set, sale_id is required', E_USER_ERROR);
	}

	// set session lifetime 365 days
	// session_set_cookie_params(3600*24*365, "/");
    if (session_id() == '') {
        session_start();
    }

	// remember last sale_id
	$_SESSION['sale_id'] = $sale_id;

	if ($refresh || !isset($_SESSION['sale'][$sale_id])) {
		// set sale defaults
		$sale = get_sale_defaults();

		if ($_GET['pn']) {
			//$sale['productName'] .= ' ' . $_GET['pn'];
			$sale['pn'] = $_GET['pn'];
		}

		$_SESSION['sale'][$sale_id] = $sale;
	} else {
		$sale = $_SESSION['sale'][$sale_id];

		if ($_COOKIE['pn'] != $_GET['pn']) {
			$sale['pn'] = $_COOKIE['pn'] . ' ' . $_GET['pn'];
		}
	}

	if (is_array($sale_setup)) {
		$sale = array_merge($sale, $sale_setup);
	}

	update_product_name();

	handle_affiliate($sale);
	$_SESSION['sale'][$sale_id] = $sale;
}

function get_sale($other_sale_id = null) {
	global $sale_id;
	return $_SESSION['sale'][$other_sale_id ?: $sale_id];
}

function get_sale_data($data) {
	$sale = get_sale();
	return $sale[$data];
}

function set_sale_data($key, $value, $other_sale_id = null) {
	global $sale_id;
	$_SESSION['sale'][$other_sale_id ?: $sale_id][$key] = $value;
}

function set_variant_for_product_id($productId, $variant)
{
    $_SESSION['variants'][$productId] = $variant;
}

function get_variant_for_product_id($productId)
{
    return isset($_SESSION['variants']) && isset($_SESSION['variants'][$productId]) ? $_SESSION['variants'][$productId] : null;
}

function sale_id($id = null) {
	global $sale_id;
	if ($id === null) return $sale_id;
	$sale_id = $id;
	$_SESSION['sale_id'] = $sale_id;
}

// opdr 144, vergeet oude namen en stappen
//function sale_add_to_product_name($add_name, $step) {
	/*$addproductnames = get_sale_data('addproductnames');
	$newproductnames = array();
	for ($i = 0; $i < $step; $i++) {
		if (isset($addproductnames[$i])) {
			$newproductnames[$i] = $addproductnames[$i];
		}
	}
	$newproductnames[$step] = $add_name;
	set_sale_data('addproductnames', $newproductnames);*/

//	set_sale_data('addproductname', $add_name . ' ' . $step);

//	update_product_name();
//}

function sale_set_orderpage_id($id) {
	set_sale_data('orderpageid', $id);
	update_product_name();
}

function sale_set_salepage_id($id, $other_sale_id = null) {
    $_SESSION['fallback_salepageid'] = $id;
    set_sale_data('salepageid', $id, $other_sale_id);
    update_product_name();
}

function sale_get_salepage_id() {
    $id = get_sale_data('salepageid');
    if (!$id) {
        $id = $_SESSION['fallback_salepageid'];
    }

    return $id;
}

function update_product_name() {
	$defaults = get_sale_defaults();
	set_sale_data('productName', $defaults['productName'] . ' ' . get_sale_data('pn') . ' ' . sale_get_salepage_id() . ' ' . get_sale_data('orderpageid'));
	//set_sale_data('productName', $defaults['productName'] . ' ' . get_sale_data('pn') . ' ' . join(get_sale_data('addproductnames') ?: array(), ' '));
}

function handle_affiliate(&$sale) {
	$id = $_GET['kortingscode'] ?: get_aff_id();
	//handle affiliating
	if (isset($id)) {
		// find affiliate
		if (function_exists('get_affiliates')) {
			$affs = get_affiliates();
			if ($aff = $affs[$id]) {
				// override sale data with affiliate data
				$sale = array_merge($sale, $aff);
			}
		}
	}
}

function enable_blacklist_affiliate($affIds) {
	global $blacklists_affiliates;
	if (!isset($blacklists_affiliates)) {
		$blacklists_affiliates = array();
	}

	if (!is_array($affIds)) {
		die('enable_blacklist_affiliate expects array');
	}

	$blacklists_affiliates = array_merge($blacklists_affiliates, $affIds);

	if ($affId = get_aff_id()) {
		if (in_array($affId, $affIds)) {
			set_sale_data('aff_comm_onetime', 0);
            // [rb] put in session, so that the KortingFactory undo affiliate value
            global $sale_id;
            $_SESSION['sale'][$sale_id]['is_blacklisted_affiliate'] = true;
            $_SESSION['sale'][$sale_id]['aff_comm_onetime_overwrite'] = 0;
		}
	}
}

function is_external_salefn() {
	return !is_dir(BLACKLIST_DIR);
}

function include_blacklist_affiliate($file) {
	if (is_external_salefn()) {
		load_external_blacklist_affiliate($file);
		return;
	}
    $path = BLACKLIST_DIR.'/'.$file.'.php';
	if (!file_exists($path))
		die('ERROR: BLACKLIST FILE (' . $file . ') NOT FOUND');
	require_once($path);
}

function load_external_blacklist_affiliate($file) {
	$path = 'https://senhpayments.nl/api/?action=blacklist&blacklist=' . $file;
	$blacklist_options = json_decode(@file_get_contents($path), true);
	if (empty($blacklist_options)) {
		die('ERROR: BLACKLIST (' . $file . ') IS EMPTY');
	}
	enable_blacklist_affiliate($blacklist_options['blacklist']);
	set_commisions_affiliate($blacklist_options['commisions']);
}

function set_commisions_affiliate($affs_coms) {
	global $commissions_affiliates;
	if (!isset($commissions_affiliates)) {
		$commissions_affiliates = array();
	}

	if (!is_array($affs_coms)) {
		die('set_commisions_affiliate expects array');
	}

	$commissions_affiliates = array_merge($commissions_affiliates, array_keys($affs_coms));

	if ($affId = get_aff_id()) {
		if (isset($affs_coms[$affId])) {
			set_sale_data('aff_comm_onetime', $affs_coms[$affId]);
            // [rb] put in session, so that the PricesHelper can use this to undo / redo kortingen
			global $sale_id;
            $_SESSION['sale'][$sale_id]['is_blacklisted_affiliate'] = false;
            $_SESSION['sale'][$sale_id]['aff_comm_onetime_overwrite'] = $affs_coms[$affId];
		}
	}
}

function sale_setup_done() {
	global $blacklists_affiliates;
	global $commissions_affiliates;
	if ($affId = get_aff_id()) {
		$affs = get_affiliates();
		if ((is_array($blacklists_affiliates) && !in_array($affId, $blacklists_affiliates) && is_array($commissions_affiliates) && !in_array($affId, $commissions_affiliates)) && empty($blacklists_affiliates) && !isset($affs[$affId])) {
			$defaults = get_sale_defaults();
			set_sale_data('aff_comm_onetime', $defaults['aff_comm_onetime']);
		}

		//only redirect when ?id has been set
		if (isset($_GET['id'])) {
			$redirectUrl = '//' . $_SERVER['HTTP_HOST'] . str_replace('?' . $_SERVER['QUERY_STRING'], '', $_SERVER['REQUEST_URI']);
			header('Location: ' . $redirectUrl);
			die();
		}
	}
}

if (!defined('SALE_ORDER_LINK')) {
	define('SALE_ORDER_LINK', 'beveiligde-bestelpagina/');
}

function printOrderLink($print = true) {
	$orderLink = SALE_ORDER_LINK;
	if ($print == false) return $orderLink;
	echo $orderLink;
}