<?php

namespace Senh\Lib\Models;

use DI\ContainerBuilder;
use Senh\Lib\Managers\InternalProductManager;
use PHPUnit\Framework\TestCase;
use DI\Container;

/**
 * @coversDefaultClass \Senh\Lib\Helpers\FileHelper
 */
class InternalProductModelTest extends TestCase
{

    /**
     * @var Container
     */
    protected $container;

    /**
     * @var InternalProductManager
     */
    protected $internalProductManager;

    protected function setUp()
    {
        $builder = new ContainerBuilder();
        $this->container = $builder->build();

        require __DIR__.'/../config/internalProductModels.php';
        $this->internalProductManager = $this->container->get(InternalProductManager::class);
        $this->internalProductManager->setInternalProductModels($config['internalProductModels']);
    }

    public function testGetPrice1()
    {
        $internalProduct = $this->internalProductManager->getSingle(TEST_PRODUCT_ID_BOOK_DIGITAL);
        $this->assertSame(10, $internalProduct->getPrice1());

        $internalProduct = $this->internalProductManager->getSingle(TEST_PRODUCT_ID_VARIANTS);
        $this->assertSame(10, $internalProduct->getPrice1('a'));
        $this->assertSame(11, $internalProduct->getPrice1('b'));
    }

    public function testGetcommission1()
    {
        $internalProduct = $this->internalProductManager->getSingle(TEST_PRODUCT_ID_BOOK_DIGITAL);
        $this->assertSame(20, $internalProduct->getcommission1());

        $internalProduct = $this->internalProductManager->getSingle(TEST_PRODUCT_ID_VARIANTS);
        $this->assertSame(20, $internalProduct->getcommission1('a'));
        $this->assertSame(21, $internalProduct->getcommission1('b'));
    }

    public function testGetListTags1()
    {
        $internalProduct = $this->internalProductManager->getSingle(TEST_PRODUCT_ID_BOOK_DIGITAL);
        $this->assertSame(['tag_1', 'tag_2'], $internalProduct->getListTags1());
    }

    public function testGetPriceN()
    {
        $internalProduct = $this->internalProductManager->getSingle(TEST_PRODUCT_ID_BOOK_DIGITAL);
        $this->assertSame(110, $internalProduct->getPriceN());

        $internalProduct = $this->internalProductManager->getSingle(TEST_PRODUCT_ID_VARIANTS);
        $this->assertSame(110, $internalProduct->getPriceN('a'));
        $this->assertSame(111, $internalProduct->getPriceN('b'));
    }

    public function testGetcommissionN()
    {
        $internalProduct = $this->internalProductManager->getSingle(TEST_PRODUCT_ID_BOOK_DIGITAL);
        $this->assertSame(120, $internalProduct->getcommissionN());

        $internalProduct = $this->internalProductManager->getSingle(TEST_PRODUCT_ID_VARIANTS);
        $this->assertSame(120, $internalProduct->getcommissionN('a'));
        $this->assertSame(121, $internalProduct->getcommissionN('b'));
    }

    public function testGetListTagsN()
    {
        $internalProduct = $this->internalProductManager->getSingle(TEST_PRODUCT_ID_BOOK_DIGITAL);
        $this->assertSame(['tag_n'], $internalProduct->getListTagsN());
    }
}
