<?php

require_once realpath(__DIR__ . '/../') . '/init.php';

global $container;
$nextSellHelper = $container->get(\Senh\Lib\NextSell\NextSellHelper::class);
$countryHelper = $container->get(\Senh\Lib\Geo\CountryHelper::class);

foreach ($_GET as &$val) {
    $val = htmlspecialchars($val);
}

$hasSubscription = (defined('HAS_SUBSCRIPTION') && HAS_SUBSCRIPTION) || $boek === false || $ebook === false;
$isMossTest = (isset($isMossTest)) ? $isMossTest && !IS_FYSIEK : false;
$showConditionsCheckbox = defined('SHOW_CONDITIONS_CHECKBOX') && SHOW_CONDITIONS_CHECKBOX;

$formName = isset($_GET['pay_name']) ? $_GET['pay_name'] : '';
$formEmail = isset($_GET['pay_email']) ? $_GET['pay_email'] : '';
$formMethod = isset($_GET['pay_method']) ? $_GET['pay_method'] : '';
$formIdealIssuer = isset($_GET['pay_ideal_issuer']) ? $_GET['pay_ideal_issuer'] : '';
$formStraat = isset($_GET['pay_straat']) ? $_GET['pay_straat'] : '';
$formPostcode = isset($_GET['pay_postcode']) ? $_GET['pay_postcode'] : '';
$formPlaats = isset($_GET['pay_plaats']) ? $_GET['pay_plaats'] : '';
$formCountry = isset($_GET['pay_country']) ? $_GET['pay_country'] : '';
$formQuantity = isset($_GET['pay_quantity']) ? $_GET['pay_quantity'] : '';

$formActionUrl = !empty($formActionUrl) ? $formActionUrl : (!$hasSubscription ? "paymentgateway_dps_cpp.php" : "paymentgateway_ups_old.php");

$showBuyAgainWarning = false;
$originalReturnUrl = null;
if (
    $nextSellHelper->hasValidSessionData() &&
    $_SESSION['sale_id'] == $nextSellHelper->getCheckoutInternalSaleId() // could be a physical book after a digital one
) {
    $sale = $nextSellHelper->fetchSale()->getSale();
    if (
        $sale &&
        $sale->hasStatusCompleted() &&
        time() - $sale->getDate()->getTimestamp() < (60 * 60)
    ) {
        $showBuyAgainWarning = true;
        $originalReturnUrl = $nextSellHelper->getOriginalReturnUrl();
    }
}

$userIp = ($_SERVER['HTTP_X_FORWARDED_FOR'] ?: $_SERVER['REMOTE_ADDR']);
$ipdat = @json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=" . $userIp));
$ipCountryCode = @$ipdat->geoplugin_countryCode ?: null;
$ipCountryName = $countryHelper->getNameByCountryCode($ipCountryCode);

if ($isMossTest) {
    $firstCountries = array(
        'NL' => 'Nederland',
        'BE' => 'België',
        'AN' => 'Nederlandse Antillen',
        'SR' => 'Suriname',
        '' => '',
    );

    // get all countries and remove the ones defined above
    $countries = $countryHelper->getList();
    foreach ($firstCountries as $countryCode => $countryName) {
        if (isset($countries[$countryCode])) {
            unset($countries[$countryCode]);
        }
    }

    // merge
    $countries = array_merge($firstCountries, $countries);
}

?>

<style>
    input[type=text] {
        box-sizing: border-box;
        height: 22px;
        width: 218px;
    }
    select,
    option {
        box-sizing: border-box;
        min-height: 22px;
    }

    #country {
        width: 218px;
    }
</style>

<script type="text/javascript">
    function gotoAlt(chkbox, base_url) {
        var name = document.getElementById("name").value;
        var email = document.getElementById("email").value;
        var paymethod = $('[name=payment_method]:checked').val();
        var idealIssuer = document.getElementById("ideal_issuer").value;
        var pstr = 'pay_name='.concat(name)
            .concat('&pay_email=').concat(email)
            .concat('&pay_method=').concat(paymethod);

        if (idealIssuer) {
            pstr = pstr.concat('&pay_ideal_issuer=').concat(idealIssuer)
        }

        <?php if (IS_FYSIEK || $isMossTest): ?>
        var country = document.getElementById("country").value;
        pstr = pstr.concat('&pay_country=').concat(country);
        <?php endif ;?>

        <?php if (IS_FYSIEK): ?>
        var address = document.getElementById("address").value;
        var postal = document.getElementById("postal").value;
        var city = document.getElementById("city").value;
        var quantity = document.getElementById("quantity") ? document.getElementById("quantity").value : "1";
        pstr = pstr
            .concat('&pay_straat=').concat(address)
            .concat('&pay_postcode=').concat(postal)
            .concat('&pay_plaats=').concat(city)
            .concat('&quantity=').concat(quantity)
        ;
        <?php endif ;?>

        if (base_url !== undefined) {
            window.location = base_url + pstr;
            return;
        }

        if (chkbox.checked) {
            window.location = '?' + pstr;
        } else {
            <?php if (IS_FYSIEK): ?>
            window.location = '?boek&' + pstr;
            <?php else: ?>
            window.location = '?ebook&' + pstr;
            <?php endif?>
        }
    }
</script>
<div id="div_session_write"></div>
<div class="table_payment">
    <h4><strong><?php if (IS_FYSIEK && !IS_VIDEO): ?>Op welk adres wil je het product ontvangen?<?php else: ?>Hoe wil je betalen?<?php endif ?></strong></h4>
    <form id="payment_form" name="payment_form" method="post"
          action="<?= $formActionUrl ?>">

        <?php if (isset($form_payment_top) && $form_payment_top)
            include realpath(__DIR__ . '/payment_methods_partial.php');
        ?>

        <?php if (!isset($form_show_name) || $form_show_name): ?>
            <p><strong>Naam:</strong><br>
                <input name="name" type="text" id="name" value="<?php echo $formName; ?>" size="30">
            </p>
        <?php else :?>
            <input name="name" type="hidden" id="name" value="Naam">
        <?php endif ?>
        <p><strong>E-mailadres:</strong><br>
            <?php if (!IS_FYSIEK && !IS_VIDEO): ?>
                <span class="small">(hierop ontvang je het ebook + bonussen)</span><br>
            <?php elseif (!IS_FYSIEK && IS_VIDEO): ?>
                <span class="small">(hierop ontvang je de link naar de video's)</span><br>
            <?php endif ?>
            <input name="email" type="text" id="email" value="<?php echo $formEmail; ?>" size="30">
        </p>

        <?php if ($isMossTest): ?>
            <p><strong>In welk land woon je?</strong><br>
                <br>
                <select name="country" id="country">
                    <option value='' <?php echo !$formCountry ? 'selected' : ''; ?>>Kies je land...</option>
                    <?php
                    $countryToSelect = $formCountry ?: $ipCountryName;
                    ?>
                    <?php foreach ($countries as $countryCode => $countryLabel): ?>
                        <option <?php echo $countryToSelect && $countryToSelect == $countryLabel ? 'selected' : ''; ?>><?= $countryLabel ?></option>
                    <?php endforeach; ?>
                </select><br>
            </p>
        <?php endif ?>

        <?php if (IS_FYSIEK): ?>
        <p><strong>Straat, huisnummer en toevoeging:</strong><br>
            <input name="address" type="text" id="address" value="<?php echo $formStraat; ?>" size="30">
        </p>
        <p><strong>Postcode:</strong><br>
            <input name="postal" type="text" id="postal" value="<?php echo $formPostcode; ?>"
                   onkeyup="this.value=this.value.split(' ').join('')" size="30">
        </p>
        <p><strong>Plaats:</strong><br>
            <input name="city" type="text" id="city" value="<?php echo $formPlaats; ?>" size="30">
        </p>
        <p><strong>Land:</strong>
            <br>
            <select name="country" id="country">
                <option value=''>Kies je land...</option>
                <option<?php echo $formCountry == 'Nederland' ? ' selected' : ''; ?>>Nederland</option>
                <option<?php echo $formCountry == 'België' ? ' selected' : ''; ?>>België</option>
            </select><br>
            <span class="small">* Dit product is alleen leverbaar in Nederland of België.</span>
            <span id="country_be_info" class="small" style="display: none;"><br>** De verzending naar België duurt circa 1 tot 2 werkdagen.</span>
            <?php endif ?>

            <?php if (!isset($form_payment_top) || !$form_payment_top)
                include realpath(__DIR__ . '/payment_methods_partial.php');
            ?>

            <?php if ($showConditionsCheckbox): ?>
        <p>
            <input id="approve_conditions" name="approve_conditions" type="checkbox">
            <label for="approve_conditions">Ik ga akkoord met de <a href="/algemene-voorwaarden.pdf" target="_blank">algemene voorwaarden</a> (waaronder de
                niet-goed-geld-terug-garantie).</label>
        </p>
    <?php endif ?>

        <p>
            <input name="button-styled" type="button" class="button-styled" id="button-styled"
                   onClick="checkform(this.form);" value="Betalen &amp; Direct Toegang »">
        </p>
    </form>
    <script src="//senhpayments.nl/js/jquery-1.10.2.js"></script>
    <script src="//senhpayments.nl/js/iban.js"></script>
    <script language="javascript" type="text/javascript">

        function isEmail(email) {
            // see for a strict regex use http://stackoverflow.com/questions/46155/validate-email-address-in-javascript#46181
            return /^\S+@\S+\.\S+$/.test(email);
        };

        function checkform(f) {
            var ret = true;
            if ((ret) && ( document.getElementById("name").value.length == 0 )) {
                ret = false;
                var msg = "Je bent vergeten je naam in te vullen.";
            }
            if ((ret) && ( document.getElementById("email").value.length == 0 )) {
                ret = false;
                var msg = "Je bent vergeten je e-mailadres in te vullen.";
            }
            if ((ret) && (!isEmail(document.getElementById("email").value))) {
                ret = false;
                var msg = "Je hebt een incorrect e-mailadres ingevuld. Controleer je e-mailadres.";
            }

            <?php if ($isMossTest): ?>
            if ((ret) && ( document.getElementById("country").value.length == 0 )) {
                ret = false;
                var msg = "Je bent vergeten in te vullen waar je woont.";
            }
            <?php endif ?>

            <?php if (IS_FYSIEK): ?>
            if ((ret) && ( document.getElementById("address").value.length == 0 )) {
                ret = false;
                var msg = "Je bent vergeten je adres in te vullen.";
            }

            var address_parts = document.getElementById("address").value.split(' ');
            if ((ret) && ( isNaN(parseInt(address_parts[address_parts.length - 1])) && isNaN(parseInt(address_parts[address_parts.length - 2])) )) {
                ret = false;
                var msg = "Je bent vergeten je huisnummer in te vullen.";
            }

            if (ret) {
                var postal = document.getElementById("postal").value.split(' ').join('');
                var country = document.getElementById("country").value;
                if (country == 'Nederland') {
                    if (ret) {
                        if (parseInt(postal) == postal) {
                            ret = false;
                            var msg = "De postcode en het land corresponderen niet met elkaar";
                        }
                    }
                    if (ret) {
                        if (postal.length > 6 || postal.length < 6 || parseInt(postal.substr(0, 4)) != postal.substr(0, 4) || !/^[a-z]+$/i.test(postal.substr(4, 2))) {
                            ret = false;
                            var msg = "Vul een geldige postcode in.";
                        }
                    }
                } else if (country == 'België') {
                    if (ret) {
                        if (parseInt(postal.substr(0, 4)) == postal.substr(0, 4) && /^[a-z]+$/i.test(postal.substr(4, 2))) {
                            ret = false;
                            var msg = "De postcode en het land corresponderen niet met elkaar";
                        }
                    }
                    if (ret) {
                        if (postal.length > 4 || postal.length < 4) {
                            ret = false;
                            var msg = "Vul een geldige postcode in.";
                        }
                    }
                } else {
                    ret = false;
                    var msg = "Vul je land in.";
                }
            }
            <?php endif ?>

            if ((ret) && ( $('#ibanbox').is(':visible') && document.getElementById("iban").value.length == 0 )) {
                ret = false;
                var msg = "Je bent vergeten je rekeningnummer in te vullen.";
            }

            if ((ret) && ( $('#ibanbox').is(':visible') && !IBAN.isValid(document.getElementById("iban").value) )) {
                ret = false;
                var msg = "De ingevulde IBAN is niet juist.";
            }
            if ((ret) && (document.getElementById('payment_method_ideal').checked) && ( document.getElementById("ideal_issuer").options[document.getElementById("ideal_issuer").selectedIndex].value == "" )) {
                ret = false;
                var msg = "Je moet eerst je bank kiezen uit het keuzemenu om te betalen met iDEAL.";
            }
            <?php if ($showConditionsCheckbox): ?>
            if (ret && !document.getElementById('approve_conditions').checked) {
                ret = false;
                var msg = "Je moet eerst akkoord gaan met de algemene voorwaarden.";
            }
            <?php endif ?>

            <?php if ($showBuyAgainWarning): ?>
            if (ret) {
                ret = confirm("Weet je zeker dat je nóg een keer hetzelfde product wilt aanschaffen? \n\n" +
                    "Klik op `Annuleren` om terug te keren naar de bedankpagina.\n" +
                    "Klik op `OK` om door te gaan met de betaling.\n");
                if (!ret) {
                    top.location = '<?= $originalReturnUrl ?>';
                }
            }
            <?php endif ?>

            if (ret) {
                f.submit();

                $(f).find('*').prop('disabled', true);
                $('#button-styled').val('Bezig met verzenden...');
            }
            else if (msg) {
                alert(msg);
            }
        }

        $(function () {

            $('[name=address]').on('keyup change', function () {
                if ($(this).val() != $(this).val().replace(/,/g , '')) {
                    $(this).val($(this).val().replace(/,/g , ''));
                }
            });

            $('#payment_form').change(function (e) {
                if (e.target === $('#ideal_issuer')[0]) {
                    $('#payment_method_ideal')[0].checked = true;
                    $('#payment_method_ideal').attr('selected', 'selected');
                }

                var paymentMethod = $('input[name="payment_method"]:checked').val();
                if (
                    <?php if ($hasSubscription): ?>paymentMethod === 'bancontact/mrcash' || <?php endif ?>
                    paymentMethod === 'directdebit/sepa-once' ||
                    paymentMethod === 'directdebit/sepa-recurring'
                ) {
                    $('#ibanbox').show();
                } else {
                    $('#ibanbox').hide();
                }

                <?php if (IS_FYSIEK): ?>
                var country = document.getElementById("country").value;
                if (country === 'België') {
                    $('#country_be_info').show();
                } else {
                    $('#country_be_info').hide();
                }
                <?php endif ?>
            }).trigger('change');

        });

    </script>

</div>