<?php

function create_packages($details_digital, $details_product, $style, $showNoBonusesButton = false) {
    ?>
    <div class="packages-container" style="<?php echo $style; ?>">
        <div class="packages">
            <div class="package-container">
                <div class="package<?php if (!is_array($details_product)) { ?> popular<?php } ?>">
                    <span class="package-label">&nbsp;</span>
                    <div class="package-title"><?php echo @$details_digital['title'] ?: 'Digitaal'; ?></div>
                    <div class="package-price">&euro; <?php echo $details_digital['price']; ?></div>
                    <ul class="package-details">
                        <?php echo implode($details_digital['details'], ''); ?>
                    </ul>
                    <div>
                        <a href="<?php echo $details_digital['url']; ?>" title="IN DEN WARENKORB LEGEN" class="buybtn"><img src="//senhpayments.nl/packages/icon-bucket.gif" width="34" height="34" /> IN DEN WARENKORB LEGEN</a>
                        <?php if ($showNoBonusesButton): ?>
                            <a class="package__no-bonuses" href="<?= StringHelper::addParameters($details_digital['url'], array('ebook' => null, 'zonder' => null)) ?>">Ik wil het ebook zonder bonussen</a>
                        <?php endif ?>
                    </div>
                </div>
                <img src="https://senhpayments.nl/digitalehulpmiddelen/images/guarantee_bigsn-de.png" width="140" height="103" style="margin-top:10px;" />
            </div>
            <?php if (is_array($details_product)) { ?>
                <div class="package-container">
                    <div class="package popular" style="padding-bottom:10px">
                        <span class="package-label"><span>Populairst</span></span>
                        <div class="package-title">Fysiek + Digitaal</div>
                        <div class="package-price">&euro; <?php echo $details_product['price']; ?></div>
                        <ul class="package-details">
                            <?php echo implode($details_product['details'], ''); ?>
                        </ul>
                        <div>
                            <a href="<?php echo $details_product['url']; ?>" title="IN DEN WARENKORB LEGEN" class="buybtn"><img src="//senhpayments.nl/packages/icon-bucket.gif" width="34" height="34" /> IN DEN WARENKORB LEGEN</a>
                        </div>
                        <?php if ($showNoBonusesButton): ?>
                            <a class="package__no-bonuses" href="<?= StringHelper::addParameters($details_product['url'], array('boek' => null, 'zonder' => null)) ?>">Ik wil het boek zonder bonussen</a>
                        <?php endif ?>
                        <p>* Vóór 12:00 uur besteld, morgen discreet in huis</p>
                    </div>
                </div>
            <?php } ?>
        </div>
        <img class="package-payments" src="https://senhpayments.nl/digitalehulpmiddelen/images/betaal-logos-de.png" width="178" height="35" />
    </div>
    <?php
}