<?php

class DbHandler
{

    /**
     * @var PDO
     */
    protected $pdo;

    /**
     * @var FluentPDOSenh
     */
    protected $fpdo;

    /**
     * Call this method to get singleton
     *
     * @return DbHandler
     */
    public static function getInstance()
    {
        static $instance = null;
        if ($instance === null) {
            $instance = new self();
        }

        return $instance;
    }

    protected function __construct()
    {
        $this->connect();
    }

    protected function connect()
    {
        $this->pdo = new PDO('mysql:dbname=' . DB_NAME . ';host=' . DB_HOST, DB_USER, DB_PASSWORD);
        $this->fpdo = new FluentPDOSenh($this->pdo);
    }

    /**
     * @return PDO
     */
    public function getPdo()
    {
        return $this->pdo;
    }

    public function getFpdo()
    {
        return $this->fpdo;
    }
}