<?php

class PostbackModel extends SaleModel
{

    const TYPE_VERKOOP = 'Verkoop';

    /**
     * @var string
     */
    protected $type;

    /**
     * PostbackModel constructor.
     *
     * @param array $data
     */
    public function __construct($data)
    {
        parent::__construct($data);
        $this->type = $data['type'];
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $type
     */
    public function setType($type)
    {
        $this->type = $type;
    }

    public function isTypeVerkoop()
    {
        return $this->type === self::TYPE_VERKOOP;
    }
}