<?php

/**
 * Used when akkoord_termijnen is required?
 * @param $sale
 */
function senh_blackhole_api($sale, $test_mode=false) {
	$url = 'https://www.paypro.nl/product/' . $sale['productID'] . '/?payment_system=' . urlencode($sale['payment_system']) . '&transaction[email]=' . urlencode($sale['email']) . '&transaction[name]=' . urlencode($sale['name']) . '&transaction_details[accountno]=' . urlencode($sale['iban']) . '&transaction_details[address]=' . urlencode($sale['consumer_address']) . '&transaction_details[zipcode]=' . urlencode($sale['consumer_postal']) . '&transaction_details[city]=' . urlencode($sale['consumer_city']) . '&akkoord_termijnen=1';
	if ($test_mode === true) {
		$url .= '&test_mode=1';
	}
	if (isset($sale['price'])) {
		$quantity = isset($sale['order_quantity']) ? $sale['order_quantity'] : 1;
		$url .= '&amount=' . $quantity * $sale['price'];
	}
	$a = file_get_contents($url);
	echo '<div style="display:none">' . $a . '</div><script>$("html").append("<base href=\"https://www.paypro.nl/\">");$("form").submit()</script>';
	die();
}

function senh_parse_countrycode($country) {
	$country_codes = array(
		'Nederland' => 'NL',
		'Netherlands' => 'NL',
		'België' => 'BE',
		'Belgium' => 'BE'
	);
	return $country_codes[$country] ?: 'unknown';
}

function senh_update_product_subscription($product_id, $update_params) {
	$api = new PayProApi('update_product_subscription');
	$api->set_param('product_id', $product_id);

	foreach ($update_params as $key => $val) {
		$api->set_param($key, $val);
	}

	$returned = $api->execute();
}

function senh_delete_product_subscription($product_id) {
	$api = new PayProApi('delete_product_subscription');
	$api->set_param('product_id', $product_id);
	$returned = $api->execute();
}

function senh_update_product($product_id, $update_params) {
	$api = new PayProApi('update_product');
	$api->set_param('product_id', $product_id);

	foreach ($update_params as $key => $val) {
		$api->set_param('parameter', $key);
		$api->set_param('value', (string) $val);
		$returned = $api->execute();
	}
}

/**
 * @param int $productid
 * @param string $productName
 * @param string $payMethod
 * @param int $orderQuantity
 * @param int $amount
 * @param int $vat
 * @param ConsumerModel $consumer
 * @param bool $approveMachtiging
 * @param string $returnUrl
 * @param string $postbackUrl
 * @param bool $testMode
 */
function senh_do_product_payment2(
    $productid,
    $productName,
    $payMethod,
    $orderQuantity,
    $amount,
    $vat,
    $consumer,
    $approveMachtiging,
    $returnUrl,
    $postbackUrl = null,
    $testMode = false,
    $handlePaymentResult = true
) {

    $api = new PayProApi('create_product_payment');
    $api->set_param('product_id', $productid);
    $api->set_param('description', $productName);
    $api->set_param('pay_method', $payMethod);
    $api->set_param('order_quantity', $orderQuantity);
    $api->set_param('amount', $amount);
    $api->set_param('vat', $vat);


    $api->set_param('consumer_name', $consumer->getName());
    $api->set_param('consumer_email', $consumer->getEmail());
    $api->set_param('consumer_address', $consumer->getAddress());
    $api->set_param('consumer_postal', $consumer->getPostal());
    $api->set_param('consumer_city', $consumer->getCity());
    $api->set_param('consumer_country', $consumer->getCountryCode() ?: senh_parse_countrycode($consumer->getCountry()));

    if ($consumer->getIban()) {
        $api->set_param('consumer_accountno', $consumer->getIban());
    }

    if ($approveMachtiging !== null) {
        $api->set_param('approve_machtiging', ($approveMachtiging === true) ? 'true' : 'false');
    }

    $api->set_param('return_url', $returnUrl);

    if ($postbackUrl) {
        $api->set_param('postback_url', $postbackUrl);
    }

    if ($testMode) {
        $api->set_param('test_mode', true);
    }

    $r = $api->execute();
    if ($handlePaymentResult) {
        senh_handle_payment_result($r, $returnUrl);
    } else {
        return $r;
    }
}

function senh_do_product_payment(
    $product_id,
    $product_name,
    $pay_method,
    $consumer_data,
    $return_url,
    $single_payment,
    $postback_url = null,
    $test_mode = false
) {

	if (!$pay_method) return;

	$api = new PayProApi('create_product_payment');
	$api->set_param('product_id', $product_id);
	$api->set_param('description', $product_name);
	$api->set_param('pay_method', $pay_method);
	$api->set_param('consumer_name', $consumer_data['name']);
	$api->set_param('consumer_email', $consumer_data['email']);
	$api->set_param('return_url', $return_url);
	$api->set_param('vat', isset($consumer_data['vat']) ? $consumer_data['vat'] : 21);

	if ($test_mode === true) {
		$api->set_param('test_mode', true);
	}

	if (isset($consumer_data['order_quantity'])) {
		$api->set_param('order_quantity', $consumer_data['order_quantity']);
	}

	if (isset($consumer_data['amount'])) {
		$api->set_param('amount', $consumer_data['amount']);
	}

	if ($single_payment) {
		$api->set_param('send_membership', false);
	}

	if ($postback_url) {
		$api->set_param('postback_url', $postback_url);
	}

	if ($pay_method == 'directdebit/sepa-once' || $pay_method == 'directdebit/sepa-recurring' || $pay_method == 'bancontact/mrcash') {
		if ($consumer_data['accountno']) {
			$api->set_param('consumer_accountno', $consumer_data['accountno']);
			$api->set_param('approve_machtiging', 'true');
		}
	}

	// consumer data
	$api->set_param('consumer_address', $consumer_data['address']);
	$api->set_param('consumer_postal', $consumer_data['postal']);
	$api->set_param('consumer_city', $consumer_data['city']);
	$api->set_param('consumer_country', senh_parse_countrycode($consumer_data['country']));

	$r = $api->execute();
	senh_handle_payment_result($r, $return_url);
}

function senh_do_payment(
    $product_id,
    $product_name,
    $pay_method,
    $consumer_data,
    $return_url,
    $single_payment,
    $postback_url = null,
    $test_mode = false
) {

	if (!$pay_method) return;

	$api = new PayProApi('create_product_payment');
	$api->set_param('product_id', $product_id);
	$api->set_param('description', $product_name);
	$api->set_param('pay_method', $pay_method);
	$api->set_param('consumer_name', $consumer_data['name']);
	$api->set_param('consumer_email', $consumer_data['email']);
	$api->set_param('return_url', $return_url);
	$api->set_param('vat', isset($consumer_data['vat']) ? $consumer_data['vat'] : 21);

	if ($test_mode === true) {
		$api->set_param('test_mode', true);
	}

	if (isset($consumer_data['amount'])) {
		$api->set_param('amount', $consumer_data['amount']);
	}

	if ($single_payment) {
		$api->set_param('send_membership', false);
	}

    if ($postback_url) {
        $api->set_param('postback_url', $postback_url);
    }

    if ($pay_method == 'directdebit/sepa-once' || $pay_method == 'directdebit/sepa-recurring' || $pay_method == 'bancontact/mrcash') {
		if ($consumer_data['accountno']) {
			$api->set_param('consumer_accountno', $consumer_data['accountno']);
			$api->set_param('approve_machtiging', 'true');
		}
	}

	// consumer data
	$api->set_param('consumer_address', $consumer_data['address']);
	$api->set_param('consumer_postal', $consumer_data['postal']);
	$api->set_param('consumer_city', $consumer_data['city']);
	$api->set_param('consumer_country', senh_parse_countrycode($consumer_data['country']));

	$r = $api->execute();
	senh_handle_payment_result($r, $return_url);
}

function senh_handle_payment_result($r, $return_url) {
	if (!$r || !isset($r['return']) || $r['errors'] == false) die('');

	if (isset($r['return']['sale_id'])) {
		header('Location: ' . $return_url);
	} else if (!defined('PAYMENTGATEWAY_EXTERNAL')) {
		header('Location: ' . $r['return']['payment_url']);
	} else {
		echo "<script>top.location='" . $r['return']['payment_url'] . "'</script>";
	}

	die();
}

function senh_get_paypro_membership_pay_method($pay_method) {
	switch($pay_method) {
		case 'mistercash':
		case 'bancontact':
			return 'bancontact/mrcash';
		case 'paypal-termijnen':
		case 'paypal':
			return 'paypal/recurring';
		case 'doorlopende-machtiging':
			return 'directdebit/sepa-recurring';
		case 'visa':
			return 'creditcard/visa';
		case 'mastercard':
			return 'creditcard/mastercard';

		// ideal
		case '31':
		case '761':
		case '721':
		case '801':
		case '21':
		case '771':
		case '751':
		case '511':
		case '161':
		
		
		case 'ideal/ABNANL2A':
		case 'ideal/ASNBNL21':
		case 'ideal/INGBNL2A':
		case 'ideal/KNABNL2H':
		case 'ideal/RABONL2U':
		case 'ideal/RBRBNL21':
		case 'ideal/SNSBNL2A':
		case 'ideal/TRIONL2U':
		case 'ideal/FVLBNL22':
			return 'idealabbo';
	}
}

function senh_get_paypro_single_pay_method($pay_method) {
	switch($pay_method) {
		case 'mistercash':
		case 'bancontact':
		case 'bancontact/mrcash':
			return 'bancontact/mrcash';
		case 'paypal-termijnen':
		case 'paypal':
		case 'paypal/direct':
			return 'paypal/direct';
		case 'eenmalige-machtiging':
		case 'directdebit/sepa-once':
			return 'directdebit/sepa-once';
		case 'visa':
			return 'creditcard/visa';
		case 'mastercard':
			return 'creditcard/mastercard';

		// ideal
		case '31':
			return 'ideal/ABNANL2A';
		case '761':
			return 'ideal/ASNBNL21';
		case '721':
			return 'ideal/INGBNL2A';
		case '801':
			return 'ideal/KNABNL2H';
		case '21':
			return 'ideal/RABONL2U';
		case '771':
			return 'ideal/RBRBNL21';
		case '751':
			return 'ideal/SNSBNL2A';
		case '511':
			return 'ideal/TRIONL2U';
		case '161':
			return 'ideal/FVLBNL22';
			
			
		case 'ideal/ABNANL2A':
			return 'ideal/ABNANL2A';
		case 'ideal/ASNBNL21':
			return 'ideal/ASNBNL21';
		case 'ideal/INGBNL2A':
			return 'ideal/INGBNL2A';
		case 'ideal/KNABNL2H':
			return 'ideal/KNABNL2H';
		case 'ideal/RABONL2U':
			return 'ideal/RABONL2U';
		case 'ideal/RBRBNL21':
			return 'ideal/RBRBNL21';
		case 'ideal/SNSBNL2A':
			return 'ideal/SNSBNL2A';
		case 'ideal/TRIONL2U':
			return 'ideal/TRIONL2U';
		case 'ideal/FVLBNL22':
			return 'ideal/FVLBNL22';
	}
}

function do_iban_check($iban) { return;
	if ($iban == 'NL18INGB0005469041') {
		echo '<script>alert("De ingevulde IBAN staat op onze naam. Het is strafbaar om een IBAN in te vullen die niet op jouw naam staat. Niet alleen laat je dan iemand anders voor de kosten opdraaien maar je pleegt ook identiteitsfraude.");window.history.go(-1);</script>';
		die();
	}
}

function payproapi($cmd) {
	$apikey = "df5185cb84b44b1943470e2bc4f15456";
	$url = "&command={$cmd}&apikey={$apikey}";
	$result = file_get_contents2("http://www.paypro.nl/post_api/",$url);
	$r = json_decode($result,true);
	return $r;
}

function file_get_contents2($url,$fields="") {
	$ch = curl_init();
	if (strlen($fields)<>1) {
		curl_setopt($ch,CURLOPT_POST, 1);
		curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
		curl_setopt($ch,CURLOPT_HTTPHEADER, Array( 'Content-Type: application/x-www-form-urlencoded' ) );
	}
	//curl_setopt($ch,CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch,CURLOPT_TIMEOUT,15);
	curl_setopt($ch,CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.2; Trident/4.0; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729)");
	curl_setopt($ch,CURLOPT_COOKIEFILE, "cookie.txt");
	curl_setopt($ch,CURLOPT_COOKIEJAR, "cookie.txt");
	curl_setopt($ch,CURLOPT_URL,$url);
	curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
	$result = curl_exec($ch);
	/*echo curl_error($ch);	$curlinfo = curl_getinfo($ch); print_r($curlinfo);*/
	curl_close($ch);
	return $result;
}

/**
 * @param $saleId
 * @param $vat
 *
 * @return bool: success
 */
function senh_update_sale($saleId, $vat) {
    $api = new PayProApi('update_sale');
    $api->set_param('sale_id', $saleId);
    $api->set_param('vat', $vat);
    $r = $api->execute();

    return $r['error'] == 'false' || strpos($r['return'], 'Vat updated in sale #') !== false; // todo paypro bug
}

/**
 * @param string $listType: sales, affiliate_sales, products
 * @param int $limit
 *
 * @return null
 */
function senh_get_list($listType = 'sales', $limit = null) {
	$api = new PayProApi('list');
	$api->set_param('list_type', $listType);
	if (!is_null($limit)) {
		$api->set_param('limit', $limit);
	}
	$r = $api->execute();

	if ($r['errors'] === 'true') {
		return null;
	}

	return $r['return'];
}

/**
 * @param int $limit
 * @return null|array
 */
function senh_get_sales_list($limit = null) {
	return senh_get_list('sales', $limit);
}

/**
 * @param $email
 * @param $productId: if provided, the sale must also match that
 *
 * @return null|SaleModel
 */
function senh_get_sale_by_email($email, $productId = null) {
	$ids = senh_get_sales_list(20);
	if (!is_array($ids)) {
		return null;
	}

	foreach ($ids as $id) {
		$sale = senh_get_sale($id);
		if ($sale === null) continue;

		if (strtolower($sale->getEmail()) == strtolower($email)) {
			if ($productId === null) {
				return $sale;
			}
			if ($sale->getProductId() == $productId) {
				return $sale;
			}
		}
	}

	return null;
}

/**
 * @param $id
 *
 * @return null|SaleModel
 */
function senh_get_sale($id) {
	$api = new PayProApi('get_sale');
	$api->set_param('sale_id', $id);
	$r = $api->execute();
	if ($r['errors'] === 'true') return null;

	return new SaleModel($r['return']);
}

function senh_get_sale_by_hash($hash) {
    $api = new PayProApi('get_sale');
    $api->set_param('payment_hash', $hash);
    $r = $api->execute();
    if ($r['errors'] === 'true') return null;

    return new SaleModel($r['return']);
}

/**
 * use for testing only
 *
 * @return null|SaleModel
 */
function senh_get_last_sale() {
    $list = senh_get_sales_list(1);

    $api = new PayProApi('get_sale');
    $api->set_param('sale_id', $list[0]);
    $r = $api->execute();
    if ($r['errors'] === 'true') return null;

    return new SaleModel($r['return']);
}

/**
 * @param SaleModel $sale
 * @param $period
 * @return null|SequenceModel
 */
function senh_get_sequence(SaleModel $sale, $period) {
    $api = new PayProApi('get_sequence');
    $api->set_param('sale_id', $sale->getId());
    $api->set_param('sequence_number', $period);
    $r = $api->execute();

    if ($r['errors'] === 'true') return null;

    $sequence = new SequenceModel($r['return']);
    $sequence->setSale($sale);

    return $sequence;
}

/**
 * @param int $saleId
 * @param int $period
 * @return null|SequenceModel
 */
function senh_get_sequence_flat($saleId, $period) {
    $api = new PayProApi('get_sequence');
    $api->set_param('sale_id', $saleId);
    $api->set_param('sequence_number', $period);
    $r = $api->execute();

    if ($r['errors'] === 'true') return null;

    return $r['return'];
}

/**
 * @param SaleModel $sale
 * @return SequenceModel[]
 */
function senh_get_all_sequences(SaleModel $sale) {
    $sequences = array();
    for ($period = 1; $period < $sale->getCurrentNumberOfPeriods() + 1; $period++) {
        $sequence = senh_get_sequence($sale, $period);
        if (!$sequence) {
            continue;
        }

        $sequences[] = $sequence;
    }

    return $sequences;

}

/**
 * Paypro endpoint seems to ignore minutes and only takes days
 *
 * @param DateTime $dateFrom
 * @param DateTime $dateTo
 * @return null|TransactionModel[]
 */
function senh_get_transactions(DateTime $dateFrom, DateTime $dateTo)
{
    $api = new PayProApi('get_transactions');
    $api->set_param('date_from', DateHelper::toPayproTransactionFormat($dateFrom));
    $api->set_param('date_to', DateHelper::toPayproTransactionFormat($dateTo));
    $r = $api->execute();

    if ($r['errors'] === 'true') return null;

    $transactions = array();
    foreach (array_reverse($r['return']['transactions']) as $row) {
        $transactions[] = new TransactionModel($row);
    }

    return $transactions;
}

/**
 * Paypro endpoint seems to ignore minutes and only takes days
 *
 * @param DateTime $dateFrom
 * @param DateTime $dateTo
 * @return null|TransactionModel[]
 */
function senh_get_all_pay_methods()
{
    $api = new PayProApi('get_all_pay_methods');
    $r = $api->execute();

    if ($r['errors'] === 'true') return null;

    return $r['return'];
}


class PayProApi {
	var $command;
	var $params = array();
	var $apikey;

	public static $lastError;

	function __construct($command=null, $params=null) {
		$this->apikey = PAYMENT_API_KEY;
		$this->command = $command;
		if (is_array($params)) {
			$this->params = $params;
		}
	}

	function execute() {
		$data_to_post = array(
			"apikey"  => $this->apikey,
			"command" => $this->command,
			"params"  => json_encode($this->params)
		);

		$url = 'https://www.paypro.nl/post_api/';

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data_to_post));
		$response = json_decode(curl_exec($ch), true);
		curl_close($ch);
		$params = array();

		if (
		    is_array($response) &&
            array_key_exists('errors', $response) &&
            array_key_exists('return', $response) &&
            $response['errors'] === 'true'
        ) {
		    self::$lastError = $response['return'];
        }

		return $response;
	}

	function set_param($param, $value) {
		$this->params[$param] = $value;
	}

}