<?php

use Senh\Lib\NextSell\NextSellHelper;

/**
 * @var \DI\Container $container ;
 */
global $container;
$nextSellHelper = $container->get(NextSellHelper::class);
$internalProductmanager = $container->get(\Senh\Lib\Managers\InternalProductManager::class);
$pricesHelper = $container->get(\Senh\Lib\Prices\PricesHelper::class);

const FALLBACK_ADDRESS = 'Adres 99';
const FALLBACK_POSTAL = '1234AB';
const FALLBACK_CITY = ' Plaats';
$paymentTestMode = defined('PAYMENT_TEST_MODE') && PAYMENT_TEST_MODE === true;

if (session_id() == '') {
    session_start();
}

function handleError()
{
    echo "<script>alert('Er ging iets fout, probeer het nog eens.');history.go(-1);</script>";
    die();
}

if (isset($_POST['sale_id']) && $_POST['sale_id'] != $_SESSION['sale_id']) {
    handleError();
}

if (!function_exists('get_sale')) {
    function get_sale()
    {
        return $_SESSION['sale'][$_SESSION['sale_id']];
    }
}

$sale = get_sale() ?: die();

$paymentMethod = $_POST['payment_method'];
$paymentMethod = $paymentMethod === 'ideal' ? $_POST['ideal_issuer'] : $paymentMethod;

$consumerName = $_POST['name'];
$consumerEmail = $_POST['email'];

// for auto-complete checkout pages the address is plit up in street and street_number
if (isset($_POST['street']) && isset($_POST['street_number'])) {
    $consumerAddress = $_POST['street'] . ' ' . $_POST['street_number'];
} else {
    $consumerAddress = $_POST['address'];
}

$consumerAddress = $consumerAddress ?: FALLBACK_ADDRESS;
$consumerPostal = $_POST['postal'] ? str_replace(' ', '', $_POST['postal']) : FALLBACK_POSTAL;
$consumerCity = $_POST['city'] ?: FALLBACK_CITY;
$consumerCountry = $_POST['country'];
$consumerCountryCode = isset($_POST['country_code']) ? $_POST['country_code'] : null;
$consumerIban = $_POST['iban'] ? str_replace(' ', '', $_POST['iban']) : null;

if (!$paymentMethod || !$consumerEmail) {
    handleError();
}

if (!$consumerCountry && !$consumerCountryCode) {
    $ipdat = @json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=" . ($_SERVER['HTTP_X_FORWARDED_FOR'] ?: $_SERVER['REMOTE_ADDR'])));
    $consumerCountry = @$ipdat->geoplugin_countryName ?: 'unknown';
    $consumerCountryCode = @$ipdat->geoplugin_countryCode ?: null;
}

if (!$consumerCountryCode && $consumerCountry) {
    $consumerCountryCode = senh_parse_countrycode($consumerCountry);
    $consumerCountryCode = $consumerCountryCode !== 'unknown' ? $consumerCountryCode : null;
}

$consumer = new ConsumerModel(
    $consumerName,
    $consumerEmail,
    $consumerAddress,
    $consumerPostal,
    $consumerCity,
    $consumerCountry,
    $consumerCountryCode,
    $consumerIban
);

$variant = $pricesHelper->getSessionSaleVariant();
$isFysiek = $consumerAddress !== FALLBACK_ADDRESS && $consumerPostal !== FALLBACK_POSTAL && $consumerCity !== FALLBACK_CITY;

$orderQuantity = isset($_POST['quantity']) && $_POST['quantity'] ? $_POST['quantity'] : 1;
$productId = $sale['productID'];
$internalProduct = $internalProductmanager->getSingle($productId);
$productName = $sale['productName'];
$price = $pricesHelper->getCurrentVariantPrice1(null) !== null ? $pricesHelper->getCurrentVariantPrice1(null) : $sale['price'];
$price1 = $price * $orderQuantity;
$priceN = $pricesHelper->getCurrentVariantPriceN(null) !== null ? $pricesHelper->getCurrentVariantPriceN(null) : $sale['price_memb'];
$numberOfPeriods = $sale['number_of_periods'];
$timeType = $sale['time_type'];
$timeMultiplier = $sale['time_multiplier'];

if (!$consumer->getCountryCode() && $internalProduct) {
    // make a last best guess for a consumer's country code
    $consumer->setCountryCode($internalProduct->getProductCountryCode());
}

/*
 * Determine the vat rate
 * for recurring products, vat may need to be changed in the payments service's web hook
 * (eg: physical book with digital program or digital book with food supplement)
 */
$productCategory = null;
$productType = null;
if ($internalProduct) {
    // by internal product
    $productCategory = $internalProduct->getProductCategory1();
    $productType = $internalProduct->getProductType1();
}

if (!$productCategory || !$productType) {
    // fallback
    $productCategory = \Senh\Lib\Models\InternalProductPropertiesModel::PRODUCT_CATEGORY_BOOK;
    $productType = isset($isFysiek) && $isFysiek
        ? \Senh\Lib\Models\InternalProductPropertiesModel::PRODUCT_TYPE_PHYSICAL
        : \Senh\Lib\Models\InternalProductPropertiesModel::PRODUCT_TYPE_DIGITAL;
}

$vat = VatHelper::getVatPercentageByCategoryAndType(
    $productCategory,
    $productType,
    null,
    $consumer->getCountryCode()
);

$initiateWithIdeal = $paymentMethod == 'doorlopende-machtiging' ? 'false' : 'true';
$initiateWithBancontact = $paymentMethod == 'mistercash' ? 'true' : 'false';
$commission = $pricesHelper->getCurrentVariantCommission1(null) !== null ? $pricesHelper->getCurrentVariantCommission1(null) : $sale['aff_comm_onetime'];
$affiliateCommission1 = $commission * $orderQuantity;
$affiliateCommissionN = $pricesHelper->getCurrentVariantCommissionN(null) !== null ? $pricesHelper->getCurrentVariantCommissionN(null) : $sale['aff_comm_memb'];

$postbackUrl = isset($sale['postback_url']) ? $sale['postback_url'] : POSTBACK_URL_DEFAULT;

if (file_exists('/home/salespages/domains/senhpayments.nl/public_html/abandoning/abandoning.php')) {
    @require_once('/home/salespages/domains/senhpayments.nl/public_html/abandoning/abandoning.php');
    @$abandoning = new abandoning();
    @$abandoning->add_abandoning($consumerEmail, $consumerName, $_SERVER["HTTP_HOST"]);
    @$abandoning->set_cookie($consumerEmail, $productName);
}

do_iban_check($consumerIban); // when invalid, echoes js alert and exits

$approveMachtiging = false;
$returnUrl = $sale['return_url_onetime'];

// fixme: this only works for a very specific testing ENV, instead setup return url in the sale's setup array
if (ENV == 'ENV_DEV') {
    $returnUrl = str_replace('.fr', '.test', $returnUrl);
    $returnUrl = str_replace('.de', '.test', $returnUrl);
    $returnUrl = str_replace('https', 'http', $returnUrl);
}

if (HAS_PRODUCT_SUBSCRIPTION) {
    $approveMachtiging = true;
    $returnUrl = $sale['return_url_memb'];
    // fixme: this only works for a very specific testing ENV, instead setup return url in the sale's setup array
    if (ENV == 'ENV_DEV') {
        $returnUrl = str_replace('.fr', '.test', $returnUrl);
        $returnUrl = str_replace('.de', '.test', $returnUrl);
        $returnUrl = str_replace('https', 'http', $returnUrl);
    }
    senh_update_product_subscription($productId, array(
        'price_1' => $price1,
        'price_n' => $priceN,
        'number_of_periods' => $numberOfPeriods,
        'time_type' => $timeType,
        'time_multiplier' => $timeMultiplier,
        'initiate_with_ideal' => $initiateWithIdeal, // todo perhaps not required?
        'initiate_with_bancontact' => $initiateWithBancontact, // todo: not documented!
        'affiliate_commission_1' => $affiliateCommission1,
        'affiliate_commission_n' => $affiliateCommissionN
    ));

} else {
    senh_delete_product_subscription($productId);
    senh_update_product($productId, array(
        'price_c' => $price1,
        'affiliate_commission_c' => $affiliateCommission1
    ));
}

$r = senh_do_product_payment2(
    $productId,
    $productName,
    $paymentMethod,
    $orderQuantity,
    $price1,
    $vat,
    $consumer,
    $approveMachtiging,
    $returnUrl,
    $postbackUrl,
    $paymentTestMode,
    false
);

$paymentHash = isset($r['return']['payment_hash']) ? $r['return']['payment_hash'] : null;
$nextSellHelper->saveCheckoutData(
    $_SESSION['sale_id'],
    $sale,
    $consumer,
    $paymentMethod,
    $paymentHash
);
senh_handle_payment_result($r, $returnUrl);
