<?php

use Senh\Lib\Models\InternalProductModel;
use Senh\Lib\Models\InternalProductPropertiesModel;

if (!defined('TEST_PRODUCT_ID_BOOK_DIGITAL')) {
    define('TEST_PRODUCT_ID_BOOK_DIGITAL', 'TEST_PRODUCT_ID_BOOK_DIGITAL');
}

if (!defined('TEST_PRODUCT_ID_VARIANTS')) {
    define('TEST_PRODUCT_ID_VARIANTS', 'TEST_PRODUCT_ID_VARIANTS');
}

if (!defined('TEST_NO_INTERNAL_PRODUCT_MODEL')) {
    define('TEST_NO_INTERNAL_PRODUCT_MODEL', 'TEST_NO_INTERNAL_PRODUCT_MODEL');
}

$config['internalProductModels'] = [
    new InternalProductModel(
        TEST_PRODUCT_ID_BOOK_DIGITAL,
        123,
        new InternalProductPropertiesModel(
            InternalProductPropertiesModel::PRODUCT_CATEGORY_BOOK,
            InternalProductPropertiesModel::PRODUCT_TYPE_DIGITAL,
            10,
            20,
            ['tag_1', 'tag_2']
        ),
        new InternalProductPropertiesModel(
            InternalProductPropertiesModel::PRODUCT_CATEGORY_PROGRAM,
            InternalProductPropertiesModel::PRODUCT_TYPE_DIGITAL,
            110,
            120,
            'tag_n'
        )
    ),
    new InternalProductModel(
        TEST_PRODUCT_ID_VARIANTS,
        123,
        new InternalProductPropertiesModel(
            InternalProductPropertiesModel::PRODUCT_CATEGORY_FOOD,
            InternalProductPropertiesModel::PRODUCT_TYPE_PHYSICAL,
            ['a' => 10, 'b' => 11],
            ['a' => 20, 'b' => 21],
            'tag_1',
            'list1'
        ),
        new InternalProductPropertiesModel(
            InternalProductPropertiesModel::PRODUCT_CATEGORY_FOOD,
            InternalProductPropertiesModel::PRODUCT_TYPE_PHYSICAL,
            ['a' => 110, 'b' => 111],
            ['a' => 120, 'b' => 121],
            'tag_n',
            'list2'
        )
    ),
];