<?php
/*
 * Plugin Name: AVG Compliance: Deletes Data And Obfuscates IP-address
 * Plugin URI:
 * Description: Deletes 30 days old data from plugins: 'Pretty Link', 'Thrive Leads', 'Wishlist Member'. Deletes and disables user address input, obfuscates the global IP-address to 123.456.78.xxx and deletes the IP-address of all comments.
 * Version: 0.4
 * Author: S&H
 * Author URI:
 */
	
add_action('activated_plugin', 'obip_load_plugin_first');
function obip_load_plugin_first() {
	$path = str_replace( WP_PLUGIN_DIR . '/', '', __FILE__ );
	if ( $plugins = get_option( 'active_plugins' ) ) {
		if ( $key = array_search( $path, $plugins ) ) {
			array_splice( $plugins, $key, 1 );
			array_unshift( $plugins, $path );
			update_option( 'active_plugins', $plugins );
		}
	}
}

$obfuscate = array(
	'HTTP_CLIENT_IP',
	'HTTP_X_FORWARDED_FOR',
	'HTTP_CF_CONNECTING_IP',
	'REMOTE_ADDR',
	'HTTP_X_FORWARDED', 
	'HTTP_X_CLUSTER_CLIENT_IP', 
	'HTTP_FORWARDED_FOR', 
	'HTTP_FORWARDED'
);

foreach ($obfuscate as $key) {
	if (!isset($_SERVER[$key])) {
		continue;
	}
	
	$parts = explode('.', $_SERVER[$key]);
	array_pop($parts);
	array_push($parts, 'xxx');
	$_SERVER[$key] = join('.', $parts);
}

function obip_comments() {
	global $wpdb;    
	$wpdb->query("UPDATE wp_comments SET comment_author_IP = ''");
}

function obip_wp_pri_clicks() {
	if (is_plugin_active('pretty-link/pretty-link.php')) {
		global $wpdb;
		$wpdb->query("UPDATE wp_prli_clicks SET ip = ''");
		$wpdb->query("DELETE FROM `wp_prli_clicks` WHERE DATEDIFF(created_at, NOW()) < -30");
		$wpdb->query("DELETE FROM `wp_prli_groups` WHERE DATEDIFF(created_at, NOW()) < -30");
	}
}

function obip_thrive_leads() {
	if (is_plugin_active('thrive-leads/thrive-leads.php')) {
		global $wpdb;
		$wpdb->query("DELETE FROM `wp_tve_leads_contacts` WHERE DATEDIFF(date, NOW()) < -30");
		$wpdb->query("DELETE FROM `wp_tve_leads_event_log` WHERE DATEDIFF(date, NOW()) < -30");
	}
}

function obip_wp_usermeta() {
	global $wpdb;
	$wpdb->query("DELETE FROM `wp_usermeta` WHERE meta_key = 'wpm_useraddress'");
}

function obip_wishlist() {
	if (is_plugin_active('quiz-master-next/mlw_quizmaster2.php')) {
		global $wpdb;
		$wpdb->query("DELETE FROM `wp_mlw_results` WHERE DATEDIFF(time_taken_real, NOW()) < -30");
	}
}

function obip_compliance() {
	obip_comments();
	obip_wp_pri_clicks();
	obip_thrive_leads();
	obip_wp_usermeta();
	obip_wishlist();
}

function obip_activated() {	
	obip_compliance();
	
	if (!wp_next_scheduled('obip_cron')) {
		wp_schedule_event(time(), 'daily', 'obip_cron');
    }
}
register_activation_hook(__FILE__, 'obip_activated');

register_deactivation_hook(__FILE__, 'obip_deactivation');

function obip_deactivation() {
	wp_clear_scheduled_hook('obip_cron');
}

add_action('obip_cron', 'obip_compliance');


function remove_wishlist_address_user_edit() {
?>
<script>
jQuery("[name='wpm_useraddress[company]']").closest('table').hide().prev().hide();
</script>	
<?php
}
add_filter('admin_footer', 'remove_wishlist_address_user_edit');