<?php

namespace api;

class WordpressApi {

    private $db;

    public function __construct()
    {
        global $wpdb;
        $this->db = $wpdb;

        add_action('rest_api_init', function () {
            register_rest_route('senh_quiz', '/questions', [
                'methods' => 'get',
                'callback' => [$this, 'getQuestions']
            ]);

            register_rest_route('senh_quiz', '/submit', [
                'methods' => 'post',
                'callback' => [$this, 'postSubmit']
            ]);

            register_rest_route('senh_quiz', '/submit', [
                'methods' => 'get',
                'callback' => [$this, 'getSubmit']
            ]);

            register_rest_route('senh_quiz', '/update',[
                'methods' => 'post',
                'callback' => [$this, 'updateSubmit']
            ]);
        });
    }

    /**
     * Insert the submitted quiz
     *
     * @param \WP_REST_Request $request
     * @return false|string
     */
    public function postSubmit(\WP_REST_Request $request)
    {

        // DECODE ANSWERS JSON
        $answers = json_decode($request['answers']);
        // PLACE BIRTH IN VAR AND REMOVE FROM ANSWERS ARRAY
        $birth = $answers[0]->answer;
        $birth = date('Y-m-d', strtotime($birth));
        unset($answers[0]);

        // SET THE TOKEN
        $timeStr = strtotime(date('d-m-Y h:i:s'));
        $token = hash('sha256', $timeStr) . '' . hash('md5', $birth);

        $inserted = $this->db->insert("{$this->db->prefix}senhquiz_submitted", [
            'birth' => $birth,
            'token' => $token,
            'answers' => json_encode(array_values($answers))
        ]);

        if($inserted) {
            echo json_encode([
                'token' => $token
            ]);
            http_response_code(201);
        } else {
            echo json_encode([
                'error' => 'Er ging iets fout, probeer het later opnieuw.'
            ]);
            http_response_code(400);
        }

    }

    public function updateSubmit(\WP_REST_Request $request)
    {
        if(isset($request['token']) && isset($request['date'])) {

            $birth = date('Y-m-d', strtotime($request['date']));

            $updated = $this->db->update("{$this->db->prefix}senhquiz_submitted", [
                'birth' => $birth
            ], [
                'token' => $request['token']
            ]);
            if($updated) {
                echo json_encode([
                    'success' => true
                ]);
                http_response_code(200);
            } else {
                echo json_encode([
                    'error' => 'Er ging iets fout, probeer het later opnieuw.'
                ]);
                http_response_code(400);
            }
        } else {
            echo json_encode([
                'error' => 'De juiste data is niet mee verstuurd'
            ]);
            http_response_code(400);
        }

    }

    /**
     * Get submitted quiz
     */
    public function getSubmit(\WP_REST_Request $request)
    {
        $submitted = $this->db->get_results("SELECT answers, birth FROM {$this->db->prefix}senhquiz_submitted WHERE token = '{$request['token']}'");

        if($submitted) {
            echo json_encode([
                'answers' => $submitted[0]->answers,
                'birth' => $submitted[0]->birth
            ]);
            http_response_code(200);
        } else {
            echo json_encode([
                'error' => 'Quiz doesn\'t exists.'
            ]);
            http_response_code(400);
        }
    }

    /**
     * Returns the questions and answers
     *
     * @param \WP_REST_Request $request
     */
    public function getQuestions(\WP_REST_Request $request)
    {

        $questions = $this->db->get_results("SELECT * FROM {$this->db->prefix}senhquiz_question WHERE quiz_id = {$request['quiz']} AND active = 1");

        foreach ($questions as $key => $value) {
            $questions[$key]->answers = json_decode($questions[$key]->answers);
        }

        if ($questions) {
            http_response_code(200);
            echo json_encode([
                'questions' => $questions
            ]);
        } else {
            echo json_decode([
                'error' => 'Vragen niet gevonden'
            ]);
            http_response_code(400);
        }
    }


}