import React from "react";
import * as QuestionTypes from "../page/quiz/QuestionTypes";

export function questionSwitch(type, questionData) {
    var userAgent = navigator.userAgent || navigator.vendor || window.opera;
    switch (type) {
        case 'date':
            if (navigator.userAgent.toLowerCase().indexOf('edg') > 0 || /android/i.test(userAgent)) {
                return <QuestionTypes.EdgeDate {...questionData} />;
            } else {
                return <QuestionTypes.Date {...questionData} />;
            }
        case 'radio':
            return <QuestionTypes.Radio {...questionData} />;
        default:
            return;
    }
}

export const operatorMethods = {
    '===': function (selectedValue, expectedValue) {
        return selectedValue === expectedValue;
    }
}

export function quizHandler(questions, answers) {
    let answerArray = [];

    for(const question of questions) {
        switch (question.type) {
            case 'date':
                answerArray.push({
                    id: question.question_id,
                    value: answers[question.question_id],
                    title: question.title,
                    answer: answers[question.question_id]
                })
                break;
            case 'radio':
                for(const selectedAnswer in answers) {
                    if(Number(selectedAnswer) === Number(question.question_id)) {
                        let show = true;
                        let isTrue = question.visible === "true" || question.visible === true;
                        if(!isTrue) {
                            let compare = question.visible.split(' ');
                            show = operatorMethods[compare[1]](answers[compare[0]], compare[2]);
                        }

                        if(show) {
                            answerArray.push({
                                id: question.question_id,
                                value: question.answers[answers[selectedAnswer]].id,
                                title: question.title,
                                abbreviation: question.abbreviation,
                                answer: question.answers[answers[selectedAnswer]].title
                            });
                        }
                    }
                }
            break;
        }

    }

    return answerArray;
}