import React from 'react';
import { questionSwitch } from '../../functions/quizHelper';
import AlertDanger from "./AlertDanger";

export default function Question ({index, length, question, answerHandler, switchPage, handleChange, givenAnswers, isSubmitting}) {
    return (
        <div className="question-container">
            <AlertDanger>U heeft geen antwoord gegeven op de vraag.</AlertDanger>

            <label className="question-label">{question.title}</label>

            <div className="question">
                {questionSwitch(question.type, {
                    answerHandler: answerHandler,
                    handleChange: handleChange,
                    question: question,
                    givenAnswers: givenAnswers
                })}
            </div>

            <div className="quiz-control-buttons">
                {length === index && <button type="submit" className={"submit-button " + (isSubmitting ? "disabled-button" : "")} disabled={isSubmitting}>{isSubmitting ? 'Laden...' : 'Mijn uitslag'}</button>}
                {length !== index && <button onClick={switchPage} className="next-button" data-title="next">Volgende vraag</button>}
                {index !== 0 && <button onClick={switchPage} className={"previous-button " + (isSubmitting ? "disabled-button" : "")} data-title="previous" disabled={isSubmitting}>Vorige vraag</button>}
            </div>
        </div>
    );
}