import React, { Component, Fragment } from 'react';
import axios from "axios";
import Question from "./Question";
import { operatorMethods, quizHandler } from "../../functions/quizHelper";

export default class Quiz extends Component {
    constructor(props) {
        super(props);

        this.state = {
            isSubmitting: false,
            show: 0,
            questions: [],
            answers: {},
        };

        this.paymentPage = document.getElementById('payment-page').dataset.pay;

        this.onSubmit = this.onSubmit.bind(this);
        this.answerHandler = this.answerHandler.bind(this);
        this.switchPage = this.switchPage.bind(this);
    }

    componentDidMount() {
        axios.get('/wp-json/senh_quiz/questions', {
            params: {
                quiz: 1
            }
        })
            .then(response => {
                if(response.data.questions) {
                    this.setState({
                        questions: response.data.questions
                    })
                }
            })
    }

    onSubmit(event) {
        event.preventDefault();

        let answerObj = quizHandler(this.state.questions, this.state.answers);

        this.setState({
            isSubmitting: true
        }, () => {
            axios.post('/wp-json/senh_quiz/submit', {answers: JSON.stringify(answerObj)})
                .then(response => {
                    if(response.data.token) {
                        window.setTimeout(() => {
                            window.location.href ='/jouw-uitslag/index.php?token=' + response.data.token + '&page=' + this.paymentPage;
                        }, 500)
                    }
                })
                .catch(error => {
                    this.setState({
                        isSubmitting: false
                    });
                    alert('Excuus voor het ongemak, dit is op het moment niet beschikbaar. Probeer het later opnieuw');
                });
        });
    }

    answerHandler(key, value) {
        this.setState({
            answers: {
                ...this.state.answers,
                [key]: value
            }
        });
    }

    switchPage(event) {
        event.preventDefault();

        let question = event.target.dataset.title === 'next' ? +1 : -1;

        if(question === +1) {
            for (const input of document.querySelectorAll('input[class="senh-quiz-input"]')) {
                document.querySelector('.alert-danger').style.display = 'block';
                if (input.type === 'radio') {
                    if (!(document.querySelector('input[name="' + input.name + '"]:checked'))) {
                        return false;
                    }
                } else if(input.type === 'date') {
                    if (!input.value) {
                        return false;
                    }
                } else {
                    if (!input.value) {
                        return false;
                    } else if(!document.querySelector('#question0').value.match('^(0[1-9]|[12][0-9]|3[01])[- /.](0[1-9]|1[012])[- /.](19|20)\\d\\d$')) {
                        return false;
                    }
                }
            }
        }

        this.setState({
            show: this.state.show + question
        });
    }

    render() {
        const filteredQuestions = this.state.questions.filter((currentValue) => {
            let isTrue = currentValue.visible === "true" || currentValue.visible === true;

            if(!isTrue) {
                let splitted = currentValue.visible.split(' ');
                return operatorMethods[splitted[1]](this.state.answers[splitted[0]], splitted[2]);
            }
            return true;
        });

        return (
            <form onSubmit={this.onSubmit}>
                {filteredQuestions.map((question, index) => (
                    <Fragment key={index}>
                        {this.state.show === index && (
                            <Question
                                question={question}
                                answerHandler={this.answerHandler}
                                switchPage={this.switchPage}
                                length={filteredQuestions.length - 1}
                                index={index}
                                givenAnswers={this.state.answers}
                                isSubmitting={this.state.isSubmitting}
                            />
                        )}
                    </Fragment>
                ))}
            </form>
        );
    }
}