<?php

add_action('init', function() {
	if (isset($_GET['scp_export_quote_templates'])) {

		$quote_templates = scp_get_option('quote_templates') ?: array();

		//function defination to convert array to xml
		function array_to_xml($array, &$xml_user_info) {
			foreach($array as $key => $value) {
				if(is_array($value)) {
					if(!is_numeric($key)){
						$subnode = $xml_user_info->addChild("$key");
						array_to_xml($value, $subnode);
					}else{
						$subnode = $xml_user_info->addChild("item$key");
						array_to_xml($value, $subnode);
					}
				}else {
					$xml_user_info->addChild("$key",htmlspecialchars("$value"));
				}
			}
		}

		$xml_user_info = new SimpleXMLElement("<?xml version=\"1.0\"?><quote_templates></quote_templates>");

		//function call to convert array to xml
		array_to_xml($quote_templates, $xml_user_info);

		header('Content-type: text/xml');
		header('Content-Disposition: attachment; filename="quote_templates_' . $_SERVER['SERVER_NAME'] . '_' . date('Y-m-d') . '_' . time() . '.xml"');
		print $xml_user_info->asXML();
		
		die();

	} else if (isset($_GET['scp_export_colorbox_templates'])) {

		$colorbox_templates = scp_get_option('colorbox_templates') ?: array();

		//function defination to convert array to xml
		function array_to_xml($array, &$xml_user_info) {
			foreach($array as $key => $value) {
				if(is_array($value)) {
					if(!is_numeric($key)){
						$subnode = $xml_user_info->addChild("$key");
						array_to_xml($value, $subnode);
					}else{
						$subnode = $xml_user_info->addChild("item$key");
						array_to_xml($value, $subnode);
					}
				}else {
					$xml_user_info->addChild("$key",htmlspecialchars("$value"));
				}
			}
		}

		$xml_user_info = new SimpleXMLElement("<?xml version=\"1.0\"?><colorbox_templates></colorbox_templates>");

		//function call to convert array to xml
		array_to_xml($colorbox_templates, $xml_user_info);

		header('Content-type: text/xml');
		header('Content-Disposition: attachment; filename="colorbox_templates_' . $_SERVER['SERVER_NAME'] . '_' . date('Y-m-d') . '_' . time() . '.xml"');
		print $xml_user_info->asXML();
		
		die();

	}
});

add_action('admin_menu', function() {
	add_options_page('Sharketing Content Pimper', 'Sharketing Content Pimper', 8, dirname (__FILE__) . '/options.php');
});

function scp_get_option($name) {
	return get_option('scp_option_' . $name);
}

function scp_set_option($name, $value) {
	return update_option('scp_option_' . $name, $value) ?: add_option('scp_option_' . $name, $value);
}