<?php

class mealAddAnchorLinks {
		
	function __construct($loader) {
		$this->links = array();
		$this->overrideOptions = array();
		$this->overrideOptionsTags = array();
		$this->options = $loader->options;
		$this->linksVisible = false;
		$this->showAnchorLinksTags = array('ankers', 'anchors', 'mwm-aal-display'); // don't add anchors or mwm-aal-display, these are shortcodes and will be handled differently (see below)
		$this->hideAnchorLinksTags = array('no_anchors', 'geen_anchors', 'no_ankers', 'geen_ankers');

		add_filter('the_content', array(&$this, 'find_override_options'), 99);
		add_filter('the_content', array(&$this, 'display_content_links'), 99);
		add_filter('the_content', array(&$this, 'remove_display_tags'), 99);
		add_filter('the_excerpt', array(&$this, 'remove_excerpt_display'), 99);

		add_action('wp_footer', array(&$this, 'add_custom_style'));
		add_action('wp_footer', array(&$this, 'add_smooth_scrolling'));
	}

	function add_custom_style() {
		$custom_style = '';

		//$custom_style .= '.meal-anchor-container .meal-anchor-title {margin-top:12px;}';
		$custom_style .= '.meal-anchor-container{margin: 15px 0px;}';
		$custom_style .= '.meal-anchor-container > .scp-anchor-links {margin-bottom:0px;position:relative;}';

		if ($this->options['underline_a_link']) {
			$custom_style .= '.scp-anchor-link:link{text-decoration:underline !important;}';
		} else {
			$custom_style .= '.scp-anchor-link:link{text-decoration:none !important;}';
		}

		if ($this->options['underline_a_hover'] || !isset($this->options['underline_a_hover'])) {
			$custom_style .= '.scp-anchor-link:hover{text-decoration:underline !important;}';
		} else {
			$custom_style .= '.scp-anchor-link:hover{text-decoration:none !important;}';
		}

		if ($this->get_option_num_columns() == 2) {
			$custom_style .= '.scp-anchor-links>li{float:left;width:50%;}';
		}

		if ($template_id = $this->options['default_template']) {
			$all_colorbox_templates = scp_get_option('colorbox_templates');
			$the_template = null;
			foreach ($all_colorbox_templates as $template) {
				if ($template['template_id'] == $template_id) {
					$the_template = $template;
					break;
				}
			}
			if ($the_template) {
				$custom_style .= '.meal-anchor-container{';

				if ($the_template['border_color']) {
					$custom_style .= 'border: 2px solid ' . $the_template['border_color'] . ';';
				}

				if ($the_template['background_color']) {
					$custom_style .= 'background-color: ' . $the_template['background_color'] . ';';
				}

				if ($the_template['width']) {
					if (!strpos($the_template['width'], 'px') && !strpos($the_template['width'], '%')) {
						$the_template['width'] .= 'px';
					}
					$custom_style .= 'width:' . $the_template['width'] . ';';
				}

				if ($the_template['text_alignment']) {
					$custom_style .= 'text-align:' . $the_template['text_alignment'] . ';';
				}

				$custom_style .= '}';

				if ($the_template['text_alignment'] == 'center' || $the_template['text_alignment'] == 'right') {
					$custom_style .= '.meal-anchor-container ul{padding-left:0px;list-style:none;}';
				}

				$custom_style .= '.meal-anchor-container .scp-anchor-links a:link,.meal-anchor-container .scp-anchor-links a:visited,.meal-anchor-container .scp-anchor-links a:active,.meal-anchor-container .scp-anchor-links a:focus{';

				if ($the_template['font_color']) {
					$custom_style .= 'color: ' . $the_template['font_color'] . ';';
				}

				$custom_style .= '}';

				if ($the_template['font_color']) {
					$custom_style .= '.meal-anchor-container ul.scp-anchor-links li::before{content: url("/wp-content/themes/' . get_stylesheet() . '/bulletpoint.php?size=' . get_theme_mod('content_thickness_bulletpoints', 6) . '&color=' .  urlencode($the_template['font_color']) . '"); }';
				}


				$custom_style .= '.meal-anchor-title{';
				if ($the_template['header_color']) {
					$custom_style .= 'background-color: ' . $the_template['header_color'] . ';';
					$custom_style .= 'border: 1px solid ' . $the_template['header_color'] . ';';
				}
				$custom_style .= '}';

				$custom_style .= '.meal-anchor-title > *{';
				if ($the_template['header_font_color']) {
					$custom_style .= 'color: ' . $the_template['header_font_color'] . ';';
				}
				if ($the_template['header_text_alignment']) {
					$custom_style .= 'text-align:' . $the_template['header_text_alignment'] . ';';
				}
				$custom_style .= '}';


				
			}
		}

		echo '<style>' . $custom_style . '</style>';
	}

	function add_smooth_scrolling() {
		if ($this->options['enable_smooth_scrolling']) {
		?>
		<script>
		jQuery && (function($) {
			$('.scp-anchor-link').click(function(e) {
				var pos = $('[name=' + $(this).attr('href').substr(1) + ']').offset().top - $('header').height();
				var dist = pos - $(window).scrollTop();
				$('html, body').animate({
					scrollTop: pos
				}, Math.max(500, dist*.3)*.5);
			});
		})(jQuery);
		</script>
		<?php
		}

		if ($this->get_option_num_columns() == 2) {
		?>
		<script>
		jQuery && (function($) {
			var listing = {};
			var listheight = 0;
			$('.scp-anchor-links>li').each(function() {
				if (!listing[$(this).offset().left])
					listing[$(this).offset().left] = 0;

				$(this).css('top', listing[$(this).offset().left]).css('left', $(this).position().left);
				
				listing[$(this).offset().left] += $(this).height();

				if (listing[$(this).offset().left] > listheight) {
					listheight = listing[$(this).offset().left];
				}
			});

			$('.scp-anchor-links>li').each(function() {
				$(this).css('position', 'absolute');
			});

			$('.scp-anchor-links').height(listheight);
		})(jQuery);
		</script>
		<?php
		}
	}

	function get_option_num_columns() {
		if ($this->search_override_option(array('2columns'))) {
			$num_columns = 2;
		}
		if ($this->search_override_option(array('1column'))) {
			$num_columns = 1;
		}
		return isset($num_columns) ? $num_columns : $this->options['num_columns'];
	}
	
	function get_option_is_numbering() {
		if ($this->search_override_option(array('numbers', 'nummers'))) {
			$isNumbering = true;
		}
		if ($this->search_override_option(array('bullets', 'bolletjes'))) {
			$isNumbering = false;
		}
		return isset($isNumbering) ? $isNumbering : $this->options['is_numbering'];
	}

	function get_option_use_indent() {
		if ($this->search_override_option(array('indent', 'indents', 'inspringing', 'inspringingen'))) {
			$useIndent = true;
		}
		if ($this->search_override_option(array('noindent', 'noindents', 'geeninspringing', 'geeninspringingen'))) {
			$useIndent = false;
		}
		return isset($useIndent) ? $useIndent : $this->options['use_heading_indent'];
	}

	function get_option_head_start() {
		// first check override options
		for ($i = 1; $i <= 6; $i++) {
			if (array_search('h' . $i, $this->overrideOptions) !== false) {
				if (!isset($minHead) || $i < $minHead) 
					$minHead = $i;
			}
		}

		return isset($minHead) ? $minHead : $this->options['head_start'];
	}

	function get_option_head_end() {
		// first check override options
		for ($i = 1; $i <= 6; $i++) {
			if (array_search('h' . $i, $this->overrideOptions) !== false) {
				if (!isset($maxHead) || $i > $maxHead) 
					$maxHead = $i;
			}
		}

		return isset($maxHead) ? $maxHead : $this->options['head_end'];
	}

	function search_override_option($options) {
		foreach ($options as $option) {
			if (array_search($option, $this->overrideOptions) !== false) {
				return true;
			}
		}
		return false;
	}

	function find_override_options($content) {
		$pattern = '#\[(.*?)\]#is';
		preg_match_all($pattern, $content, $shortcodes, PREG_SET_ORDER);

		$options = array();
		foreach ($shortcodes as $shortcode) {
			// ignore the base shortcodes, these will be handled differently see constructor
			if ($shortcode[1] == 'anchors' || $shortcode[1] == 'ankers') continue;
			$parts = explode('_', $shortcode[1]);
			if (array_search('anchors', $parts) !== false || array_search('ankers', $parts) !== false) {
				$this->overrideOptionsTags []= $shortcode[1];
				foreach ($parts as $option) {
					if ($option == 'anchors' || $option == 'ankers') continue;
					$options []= $option;
				}
			}
		}

		// save and remove any duplicates
		$this->overrideOptions = array_unique($options);

		return $content;
	}
	
	function display_content_links($content) {
		
		
		foreach ($this->hideAnchorLinksTags as $tag) {
			if (strpos($content, '[' . $tag . ']') == true) {
				return $content;
			}
		}
		
		// check if links are already set
		if (strpos($content, '<a class="meal-anchor-item"></a>') === false) {
			$this->find_head_links($content);
			$this->check_for_tags($content);
			$content = $this->add_anchors_to_content($content);
			if (property_exists($this, 'isTagUsed') && !$this->isTagUsed) {
				// auto output the content links when the links are wanted visible and no tag/shortcode has been used
				if ($this->is_anchor_links_visible($content)) {
					$content = $this->auto_output_content_links($content);
					$this->linksVisible = true;
				}
			} else {
				foreach ($this->showAnchorLinksTags as $tag) {
					if (strpos($content, '[' . $tag . ']') !== false) {
						$content = str_replace('[' . $tag . ']', $this->output_content_links(), $content);
					}
				}
			}
		}
		return $content;
	}
	
	function add_anchors_to_content($content) {
		if(count($this->links) >= 1 && count($this->links) >= $this->options['anchorCount']){
			foreach ($this->links as $val) {
				$rtext='<a class="meal-anchor-item" name="' . urlencode($this->to_ascii(strip_tags($val[2]))) . '"></a>';
				$pos = strpos($content, $val[0]);
				$content = substr_replace($content, $rtext, $pos, 0);
			}
			
			$output = $this->output_content_links();
			if(!empty($this->overrideOptionsTags)){
				$content = str_replace('[' . $this->overrideOptionsTags[0] . ']', $output, $content);
			}
		}
		return $content;	
	}
	
	function auto_output_content_links($content) {
		if (!isset($this->options['showtags']) || $this->options['showtags'] == 'Show them immediately after the more tag') {
			// CHANGE: <!--more--> isn't visible in the_content, but '<span id="more-' is, so use this to check if moretag exists
			//$morestring = '<!--more-->';
			$hasMoreTag = function($text) {
				if (strpos($text, '<!--more-->')) {
					return true;
				}
				$pos1 = strpos($text, '<span id="more-');
				$pos2 = strpos($text, '</span>', $pos1);
				return $pos1 !== false && $pos2 !== false;
			};
			$addAfterMoreTag = function($text, $textAfter) {
				$more_html = '<p><span id="more-' . get_the_ID() . '"></span></p>';
				if (strpos($text, '<span id="more-' . get_the_ID() . '"></span>') && strpos($text, '<p><span id="more-' . get_the_ID() . '"></span></p>') === false) {
					$more_html = '<span id="more-' . get_the_ID() . '"></span>';
				}
				if (strpos($text, '<!--more-->')) {
					$more_html = '<!--more-->';
				}
				$more_html_new = $more_html;//'<p style="display:none;"><span id="more-' . get_the_ID() . '"></span></p>';
				return str_replace($more_html, $more_html_new . $textAfter, $text);

				$pos1 = strpos($text, '<span id="more-');
				$pos2 = strpos($text, '</span>', $pos1);
				$text1 = substr($text, 0, $pos2);
				$text2 = substr($text, $pos2);
				return $text1 . $textAfter . $text2;
			};
			if ($hasMoreTag($content)) {
				$content = $addAfterMoreTag($content, $this->output_content_links());
			} else if ($this->options['noMoreTag'] == '' || $this->options['noMoreTag'] == 'Then don`t add anchor links there') {
				//
			} else if ($this->options['noMoreTag'] == 'Then add anchor links immediately above the first heading') {
				if (count($this->links) > 0) {
					$explodeheader = explode($this->links[0][0], $content);
					$content = $explodeheader[0] . $this->output_content_links() . $this->links[0][0] . $explodeheader[1];
				}
			} else {
				$content = $this->output_content_links() . $content;
			}
		} else { //if ($this->options['showtags'] != 'No, I will do it manually with the shortcode') {
			if(count($this->links) >= 1 && count($this->links) >= $this->options['anchorCount']){
				$output = $this->output_content_links();
				if(!empty($this->overrideOptionsTags)){
					$content = str_replace('[' . $this->overrideOptionsTags[0] . ']', $output, $content);
				} else {
					$content = $output.$content;
				}
			}
		}
		return $content;
	}

	/*function create_anchor_link($url, $title, $head) {
		if ($this->get_option_use_indent()) {
			$headStart = $this->get_option_head_start();
			$indentCSS = ' style="margin-left:' . ($head - $headStart)*1.5 . 'em"';
		}
		return '<li' . $indentCSS . '><a href="#' . $url . '">' . $title . '</a></li>';
	}*/

	function get_head_info($val) {
		$url = urlencode($this->to_ascii(strip_tags($val[2])));
		$title = strip_tags($val[2]);
		return array($url, $title);
	}

	function create_anchor_link_sublisted($head_link, $sub_head_links, $current_depth = 0) {
		$listType = $this->get_option_is_numbering() ? 'ol' : 'ul';	
		$sublist = '';
		if (!empty($sub_head_links)) {
			// create sublist html
			$sublist = '<' . $listType . '>';
			$num = 0;
			while (count($sub_head_links)) {
				$info = array_shift($sub_head_links);
				$link = $info[0];
				$depth = $info[1];
				$head_info = $this->get_head_info($link);
				if ($depth == $current_depth + 1) {
					$num++;
					$sublist .= $this->create_anchor_link_sublisted($link, $sub_head_links, $depth);
				} else {
					if ($current_depth > 0) {
						break;
					}
				}
			}
			$sublist .= '</' . $listType . '>';			
			if ($num == 0) $sublist = '';
		}

		$head_info = $this->get_head_info($head_link);
		return '<li><a href="#' . $head_info[0] . '" class="scp-anchor-link">' . $head_info[1] . '</a>' . $sublist . '</li>';
	}
	
	function output_content_links() {
		$html = '';
		if(count($this->links) >= 1 && count($this->links) >= $this->options['anchorCount']) {
			$listType = $this->get_option_is_numbering() ? 'ol' : 'ul';		
			$title = __($this->options['display_title'], 'meal');

			$html = '<a class="meal-anchor-item"></a>';

			if ($template_id = $this->options['default_template']) {
				$all_colorbox_templates = scp_get_option('colorbox_templates');
				$the_template = null;
				foreach ($all_colorbox_templates as $template) {
					if ($template['template_id'] == $template_id) {
						$the_template = $template;
						break;
					}
				}
				if ($the_template) {
					///if ($the_template['header_text_type']) {
					//	$title = '<' . $the_template['header_text_type'] . '>' . $title . '</' . $the_template['header_text_type'] . '>';
					//}

					//if (substr($the_template['header_text_type'], 1,1) < 3) {
					//	$the_template['header_text_type'] = 'span';
					//}

					//$html .= '[colorbox template_id="' . $template_id . '" header_text="' . $title . '"]<div class="meal-anchor-container"' . ($this->options['activate_clear_both_css'] ? ' style="clear:both;"' : '') . '>';
					$atts['template_id'] = $template_id;
					$atts['header_text'] = '<div class="scp-anchor-title">' . stripslashes($title) . '</div>';
					$atts['header_text_type'] = 'span';
					$atts['class'] = 'scp-colorbox-anchor-links';
					$html .= sharketing_content_pimper_colorbox($atts, $this->create_anchor_links_html($listType));
				}
			}

			if (!$the_template) {
				$html .= '<div class="meal-anchor-container"' . ($this->options['activate_clear_both_css'] ? ' style="clear:both;"' : '') . '>';
				$html .= '<div class="scp-anchor-title meal-anchor-title">' . $title . '</div>';
				$html .= $this->create_anchor_links_html($listType);
				$html .= '</div>';
			}
			
			

			// add auto indention
			//if ($this->options['is_indent']) {
			//	$html .= '<' . $listType . '><' . $listType . '>';
			//}

			/*$anchorsTree = array();
			$i = 0;
			foreach ($this->links as $val) {
				$depth = $this->get_sublist_depth($val[1]);
				if ($depth == 0 || ($currentAnchor === null || $currentAnchor[0][1] == $val[1])) {
					$currentAnchor = array($val, array());
					$anchorsTree[$i++] = $currentAnchor;
				} else if (isset($anchorsTree[$i - 1])) {
					$anchorsTree[$i - 1][1] []= array($val, $depth);
				}
			}

			// add anchor items
			foreach ($anchorsTree as $child) {
				$head_link = $child[0];
				$sub_head_links = $child[1];
				$html .= $this->create_anchor_link_sublisted($head_link, $sub_head_links);
			}*/


			// add anchor items
			/*foreach ($this->links as $val) {
				$url = urlencode($this->to_ascii(strip_tags($val[2])));
				$title = strip_tags($val[2]);
				$html .= $this->create_anchor_link($url, $title, $val[1]);
			}*/

			// close auto indention
			//if ($this->options['is_indent']) {
			//	$html .= '</' . $listType . '></' . $listType . '>';
			//}

		}
		return $html;
	} 

	function create_anchor_links_html($listType) {
		$html = '<' . $listType . ' class="scp-anchor-links">';

		$anchorsTree = array();
		$i = 0;
		foreach ($this->links as $val) {
			$depth = $this->get_sublist_depth($val[1]);
			if ($depth == 0 || ($currentAnchor === null || $currentAnchor[0][1] == $val[1])) {
				$currentAnchor = array($val, array());
				$anchorsTree[$i++] = $currentAnchor;
			} else if (isset($anchorsTree[$i - 1])) {
				$anchorsTree[$i - 1][1] []= array($val, $depth);
			}
		}

		// add anchor items
		foreach ($anchorsTree as $child) {
			$head_link = $child[0];
			$sub_head_links = $child[1];
			$html .= $this->create_anchor_link_sublisted($head_link, $sub_head_links);
		}

		$html .= '</'.	$listType . '>';

		return $html;
	}

	function output_content_links_only_onetime() {
		if ($this->linksVisible || $this->isTagUsed) return;
		$this->isTagUsed = true;
		$this->linksVisible = true;
		return $this->output_content_links();
	}

	function get_sublist_depth($head) {
		if ($this->get_option_use_indent()) {
			$headStart = $this->actualHeadStart;//$this->get_option_head_start();
			//$indentCSS = ' style="margin-left:' . ($head - $headStart)*1.5 . 'em"';
			return $head - $headStart;
		}
		return 0;
	}

	function check_for_tags($content) {
		$containsTag = false;
		foreach ($this->showAnchorLinksTags as $tag) {
			if (strpos($content, '[' . $tag . ']') !== false || strpos($content, '[' . $tag . '_') !== false) {
				$containsTag = true;
				break;
			}
		}
		if ($containsTag) { // || $this->options['showtags'] == 'No, I will do it manually with the shortcode'
			$this->isTagUsed = true;
		}
	}

	function find_head_links($content) {
		$pattern='#<h([' . $this->get_option_head_start() . '-' . $this->get_option_head_end() . '])(?: [^>]+)?>(.+?)</h\1>#is';
		preg_match_all($pattern, $content, $matches, PREG_SET_ORDER);
		$this->links = $matches;
//if ($_GET['test']) { print_R($matches);die();}
		// find actual start en end headings
		foreach ($this->links as $k => $val) {
			// ignore headings with images
			if (strpos($val[0], '<img') !== false || strpos($val[0], 'related_post_title') !== false || strpos($val[0], 'Misschien vind je dit ook leuk:') !== false) {
				unset($this->links[$k]);
				continue;
			}

			if (isset($headStart) && $val[1] < $headStart || !isset($headStart)) 
				$headStart = $val[1];
			if (isset($headEnd) && $val[1] > $headEnd || !isset($headEnd)) 
				$headEnd = $val[1];
		}
		
		if(isset($headStart)){
			
			$this->actualHeadStart = $headStart;
		}
		
		if(isset($headEnd)){
			
			$this->actualHeadEnd = $headEnd;
		}
	}

	function is_anchor_links_visible($content) {
		// check if hide anchor links tag has been places
		foreach ($this->hideAnchorLinksTags as $tag) {
			if (strpos($content, '[' . $tag . ']') !== false) {
				return false;
			}
		}
		foreach (array('single', 'page') as $viewType) {
			$option = 'is_' . $viewType;
			if ($option() && $this->options[$option]) {
				if ($this->options['showtags'] == 'No, I will do it manually with the shortcode') {
					if (count($this->overrideOptions) > 0) {
						return true;
					}
				} else {
					return true;
				}
			}
		}
		return false;
	}
		
	function remove_display_tags($content) {
		foreach (array_merge($this->showAnchorLinksTags, $this->hideAnchorLinksTags, $this->overrideOptionsTags) as $str) {
			// first try to remove possible extra break caused by using the shortcode
			$content = str_replace('[' . $str . ']<br />', '', $content);
			$content = str_replace('[' . $str . ']', '', $content);
		}
		return $content;
	}

	function remove_excerpt_display($excerpt) {
		$data = __($this->options['display_title'], 'meal');
		foreach ($this->links as $val) {
			$data .= strip_tags($val[2]);
		}		
		$excerpt = str_replace($data, '', $excerpt);
		foreach (array_merge($this->showAnchorLinksTags, $this->hideAnchorLinksTags) as $tag) {
			$excerpt = str_replace($tag, '', $excerpt);
		}
		return $excerpt;
	}
	
	function to_ascii($str, $replace=array(), $delimiter='-') {
		if( !empty($replace) ) {
			$str = str_replace((array)$replace, ' ', $str);
		}
		$clean = iconv('UTF-8', 'ASCII//TRANSLIT', $str);
		$clean = preg_replace("/[^a-zA-Z0-9\/_|+ -]/", '', $clean);
		$clean = strtolower(trim($clean, '-'));
		$clean = preg_replace("/[\/_|+ -]+/", $delimiter, $clean);
		return $clean;
	}

}