<?php 
if(preg_match('#' . basename(__FILE__) . '#', $_SERVER['PHP_SELF'])) { die('You are not allowed to call this page directly.'); }

$meal = $mealLoader;

if (count($_POST) > 0) {
	if ($error = $meal->mealAdminPanel->save_options($_POST, explode(',', stripslashes($_POST['_pageOptions'])))) {
		$meal->show_error(__($error, 'meal'));
	} else {
		$meal->show_message(__('Updated Successfully','mwmall'));
	}
}

function t($str) {
	return _e($str, 'meal');
}

function headSet($hilo,$numsel) {
	echo "<select name='$hilo' size=1>";
	$i=1; 
	while ($i<4) {
		echo '<option ';
		if ($numsel == $i) {echo 'selected="SELECTED" ';
		}
		echo "value=".$i.">&#60;h".$i."&#62;</option>"; 
		$i++ ;
	}
	echo "</select>";
}

function showList($name,$numsel) {
	echo "<select name='$name' size=1>";
	foreach (array('No, I will do it manually with the shortcode', 'Show them at the top of the content', 'Show them immediately after the more tag') as $i) {
		echo '<option ';
		if ($numsel == $i) {echo 'selected="SELECTED" ';
		}
		echo ">".$i."</option>";
	}
	echo "</select>";
}

function anchorCount($hilo,$numsel) {
	echo "<select name='$hilo' size=1>";
	$i=1; 
	while ($i<6) {
		echo '<option ';
		if ($numsel == $i) {echo 'selected="SELECTED" ';
		}
		echo "value=".$i.">".$i."</option>"; 
		$i++ ;
	}
	echo "</select>";
}

function noMoreTag($name,$numsel) {
	echo "<select name='$name' size=1>";
	foreach (array('Then don`t add anchor links there', 'Then add anchor links at the top', 'Then add anchor links immediately above the first heading') as $i) {
		echo '<option ';
		if ($numsel == $i) {echo 'selected="SELECTED" ';
		}
		echo ">".$i."</option>";
	}
	echo "</select>";
}

function orderingListSet($name, $numsel) {
	echo "<select name='$name' size=1>";
	foreach (array(1 => 'Ordered list / numbers', 0 => 'Unordered list / bullets') as $k => $i) {
		echo '<option value="' . $k . '" ';
		if ($numsel == $i) {echo 'selected="SELECTED" ';
		}
		echo ">".$i."</option>";
	}
	echo "</select>";
}

function numSet($hilo,$numsel,$num) {
	echo "<select name='$hilo' size=1>";
	$i=1; 
	while ($i<$num+1) {
		echo '<option ';
		if ($numsel == $i) {echo 'selected="SELECTED" ';
		}
		echo "value=".$i.">".$i."</option>"; 
		$i++ ;
	}
	echo "</select>";
}
  
?>
	
		
<div class="wrap">

	<form name="generaloptions" method="post">
		<?php wp_nonce_field('ngg_settings') ?>

		<div id="tab-feedback">
		
			<table class="form-table">
				<tr  valign="top">
					<th scope="row" valign="top" align="left"><?php t('Title Above Links') ?></th>
					<td>
					<input type="text" size="35" name="display_title" value="<?php echo stripslashes($meal->get_option('display_title')); ?>" />
							<span class="setting-description"><?php t('You can use html in this field') ?></span>
					</td>
				</tr>
				<tr  valign="top">
					<th scope="row" valign="top" align="left"><?php t('Automatic Or Manual?') ?></th>
					<td>
					<?php t('Do you want to automatically display links to &lt;H&gt; tags?') ?>
					<br/>
					<?php showList('showtags', $meal->get_option('showtags'))?>
					</td>
				</tr>
				</tbody>
				<tbody id="automatic_options">
				<?php //if ($meal->get_option('showtags') == 'Show them immediately after the more tag') { ?>
				<tr  valign="top" id="nomoretag_container">
					<th scope="row" valign="top" align="left"></th>
					<td>
					<?php t('If there is no more tag, what should be done?') ?><br/>
					<?php noMoreTag('noMoreTag', $meal->get_option('noMoreTag'))?>
					</td>
				</tr>
				<?php //} ?>
				<tr  valign="top">
					<th scope="row" valign="top" align="left"></th>
					<td>
					<?php t('Where do you want the links to display?') ?><br/>
					<BLOCKQUOTE><BLOCKQUOTE>
					<input type="hidden" name="is_single" value="0" />
					<input type="checkbox" name="is_single" value="1" <?php checked($meal->get_option('is_single')); ?> /> <?php t("Blogposts"); ?><br/>
					<input type="hidden" name="is_page" value="0" />
					<input type="checkbox" name="is_page" value="1" <?php checked($meal->get_option('is_page')); ?> /> <?php t('Pages'); ?><br/>
					</BLOCKQUOTE></BLOCKQUOTE>
					</td>
				</tr>
				<tr  valign="top">
					<th scope="row" valign="top" align="left"></th>
					<td>
					<?php t('What should be the minimum anchor links to show them?') ?><br/>
					<?php anchorCount('anchorCount',$meal->get_option('anchorCount'))?>
					</td>
				</tr>
				</tbody>
				<tbody>
				<tr  valign="top">
					<th scope="row" valign="top" align="left"><?php t('Heading Selection') ?></th>
					<td>
				   from <?php headSet('head_start',$meal->get_option('head_start'))?> to <?php headSet('head_end',$meal->get_option('head_end'));
				   t(' (first heading number should be less or equal than the second)');
					?>					 
					</td>
				</tr> 
				<tr  valign="top">
					<th scope="row" valign="top" align="left"><?php t('Ordering List') ?></th>
					<td>
					<?php orderingListSet('is_numbering', !$meal->get_option('is_numbering')); ?>
					<?php t("Numerically ordered list (otherwise bulleted list)"); ?><br />			
					</td>
				</tr> 
				<tr  valign="top">
					<th scope="row" valign="top" align="left"><?php t('Indentation') ?></th>
					<td>
					<input type="checkbox" name="use_heading_indent" value="1" <?php checked($meal->get_option('use_heading_indent')); ?> /> <?php t("Use indentation for the links (there is a max of two indents)"); ?><br />			
					</td>
				</tr> 
				<tr  valign="top">
					<th scope="row" valign="top" align="left"><?php t('Clear:both CSS') ?></th>
					<td>
					<input type="checkbox" name="activate_clear_both_css" value="1" <?php checked(true, $meal->get_option('activate_clear_both_css')); ?> />
					<?php t('Check if you want that the anchor links box is never next to an object (like an image) but always below the object on the left side') ?>
					</td>
				</tr>
				<tr  valign="top">
					<th scope="row" valign="top" align="left"><?php t('Columns') ?></th>
					<td>
					<?php numSet('num_columns',$meal->get_option('num_columns'),2)?>
					<?php t('Divide the list in 1 or 2 columns') ?>
					</td>
				</tr>
				<tr  valign="top">
					<th scope="row" valign="top" align="left"><?php t('Select template') ?></th>
					<td>
					<select name="default_template"><option></option>
					<?php foreach (scp_get_option('colorbox_templates') as $template) { if (!$template['active']) continue;  ?>
						<option value="<?php echo $template['template_id']; ?>" <?php if ($meal->get_option('default_template') == $template['template_id']) { ?>selected<?php } ?>><?php echo $template['template_name']; ?></option>
					<?php } ?>
					</select>
					<?php t('Select a (default) template which are based on the colorbox templates') ?>
					</td>
				</tr>
				<tr  valign="top">
					<th scope="row" valign="top" align="left"><?php t('Underline a:link') ?></th>
					<td>
					<input type="checkbox" name="underline_a_link" value="1" <?php checked($meal->get_option('underline_a_link')); ?> />
					<?php t('Check if you want to underline a:link') ?>
					</td>
				</tr>
				<tr  valign="top">
					<th scope="row" valign="top" align="left"><?php t('Underline a:hover') ?></th>
					<td>
					<input type="checkbox" name="underline_a_hover" value="1" <?php checked($meal->get_option('underline_a_hover') === null ? true : $meal->get_option('underline_a_hover')); ?> />
					<?php t('Check if you want to underline a:hover') ?>
					</td>
				</tr>
				<tr  valign="top">
					<th scope="row" valign="top" align="left"><?php t('Enable smooth scrolling') ?></th>
					<td>
					<input type="checkbox" name="enable_smooth_scrolling" value="1" <?php checked($meal->get_option('enable_smooth_scrolling')); ?> />
					<?php t('Use smooth scrolling instead of jumping to an anchor link') ?>
					</td>
				</tr>
			</table>

		</div>

		<div id="saveButton" class="submit"><input class="button-primary" type="submit" name="" value="<?php t('Save Changes') ;?>"/></div>
	</form>

	

	<script>
	jQuery('select[name="showtags"]').change(function() {
		if (jQuery(this).val().indexOf('manually') > -1) {
			jQuery('#automatic_options').hide();
		} else {
			jQuery('#automatic_options').show();
		}
	}).trigger('change');

	jQuery('select[name="showtags"]').change(function() {
		if (jQuery(this).val().indexOf('more tag') > -1) {
			jQuery('#nomoretag_container').show();
		} else {
			jQuery('#nomoretag_container').hide();
		}
	}).trigger('change');
	</script>
	
</div>