<?php

function sharketing_content_pimper_get_posts_query_by_atts($atts) {
	$args = array(
		'posts_per_page' => $atts['columns']*$atts['rows'],
		'caller_get_posts' => 1
	);

	if ($atts['type'] == 'recentposts') {
		//
	} else if ($atts['type'] == 'post_id') {
		$args['post__in'] = explode(',', $atts['post_id']);
		$args['orderby'] = 'post__in';
	}

	if ($atts['category_id']) {
		$args['category__in'] = explode(',', $atts['category_id']);
	}

	if ($atts['stickyposts'] == 'false') {
		$args['post__not_in'] = get_option('sticky_posts');
	}

	return new WP_Query($args);
}

function sharketing_content_pimper_post_loop($posts_query, $before_post = '', $after_post = '') {
	$i = 0;
	while ($posts_query->have_posts()) {
		if ($i == get_theme_mod('promotionwidget_afternumposts')) {
			dynamic_sidebar('promotion-widget');
		}

		$posts_query->the_post();
		echo $before_post;
		get_template_part('templates/content', 'preview');
		echo $after_post;

		$i++;
	}
	if ($i == get_theme_mod('promotionwidget_afternumposts')) {
		dynamic_sidebar('promotion-widget');
	}
}

function sharketing_content_pimper_blogposts($atts, $content = '') {
	$atts['columns'] = $atts['columns'] ?: 3;
	$atts['rows'] = $atts['rows'] ?: 1;
	$max_posts = $atts['columns']*$atts['rows'];

	$posts_query = sharketing_content_pimper_get_posts_query_by_atts($atts);

	if (!$posts_query || !$posts_query->have_posts()) return '';

	ob_start();
	
	$colclass = '';
	$numcols = $atts['columns'];
	if ($numcols == 1) {
		$colclass = 'col-xs-12';
	} else if ($numcols < 4) {
		$colclass = 'col-xs-6 col-sm-' . (12/$numcols);
	} else {
		$colclass = 'col-xs-6 col-sm-4 col-md-' . (12/$numcols);
	}

	echo '<div class="row">';
	sharketing_content_pimper_post_loop($posts_query, '<div class="' . $colclass . '">', '</div>');
	echo '</div>';

	$posts_html = ob_get_contents();
	ob_end_clean();

	$posts_html = '<div class="scp-container" style="overflow:hidden;">' . $posts_html . '</div>';

	return $posts_html;
}
add_shortcode('blogposts', 'sharketing_content_pimper_blogposts');

// zorg ervoor dat de autor URL naar /over-mij/ gaat.

function wpd_author_link( $link, $author_id, $author_nicename ){

	
	$meta = get_user_meta( $author_id, 'overons' , true );
	
	//return $meta['textarea'];
	return $meta;
}


add_filter( 'author_link', 'wpd_author_link', 20, 3 );
add_action( 'show_user_profile', 'extra_user_profile_fields' );
add_action( 'edit_user_profile', 'extra_user_profile_fields' );

function extra_user_profile_fields( $user ) { 


	if(current_user_can('manage_options')) {






	?>
    <h3><?php _e("Extra informatie", "blank"); ?></h3>

    <table class="form-table">
    <tr>
        <th><label for="address"><?php _e("Custom author URL"); ?></label></th>
        <td>
            <input type="text" name="address" id="overons" value="<?php echo esc_attr( get_the_author_meta( 'overons', $user->ID ) ); ?>" class="regular-text" /><br />
            <span class="description"><?php _e("Vul Over Ons link in"); ?></span>
        </td>
    </tr>
    
    </table>
<?php } }

add_action( 'personal_options_update', 'save_extra_user_profile_fields' );
add_action( 'edit_user_profile_update', 'save_extra_user_profile_fields' );

function save_extra_user_profile_fields( $user_id ) {
    if ( !current_user_can( 'edit_user', $user_id ) ) { 
        return false; 
    }
    update_user_meta( $user_id, 'overons', $_POST['address'] );
    
}


