<?php

add_filter('scp_pimper_options', function($options) {
	$options['column'] = 'Kolom';
	return $options;
});

add_action('scp_pimper_option_column', function() {
?>
<h3>Kies grootte</h3>

<div>
<select name="scp-column-size">
	<option value="1/1">Volledige breedte</option>
	<option value="1/2" selected="selected">1/2</option>
	<option value="1/3">1/3</option>
	<option value="2/3">2/3</option>
	<option value="1/4">1/4</option>
	<option value="3/4">3/4</option>
	<option value="1/5">1/5</option>
	<option value="2/5">2/5</option>
	<option value="3/5">3/5</option>
	<option value="4/5">4/5</option>
	<option value="1/6">1/6</option>
	<option value="5/6">5/6</option>
</select>
</div>

<button class="button button-primary" onclick="scp_add_column()" style="margin-top:15px;">Toevoegen</button>

<script>
	function scp_add_column() {
		var params = {
			size: jQuery('[name="scp-column-size"]').val()
		};
		var code = scp_make_code('column', params);
		var node = scp_editor_get_node();
		if (node && tinymce.activeShortcode) {
			var html = scp_remove_shortcode(node.html(), 'column');
			node.html(code[0] + html + code[1]);
			scp_close_thickbox();
		} else {
			scp_enclose_editor_selection(code[0], code[1]);
		}
	}

	function scp_column_modal_fill(obj) {
		jQuery('[name="scp-column-size"]').val(obj.size);
	}

	(function($) {
	})(jQuery);
</script>
<?php
});

function sharketing_content_pimper_column($atts, $content) {
	$uid = 'scpcolumn' . uniqid();

	$p = explode('/', $atts['size']);
	$col_span = ($p[0]/$p[1])*12;

	$content = '<div id="' . $uid . '" class="scp-column col-md-' . $col_span . '">' . $content . '</div>';

	return do_shortcode($content);
}
add_shortcode('column', 'sharketing_content_pimper_column');

function sharketing_content_pimper_row($atts, $content) {
	$uid = 'scprow' . uniqid();

	$content = '<div id="' . $uid . '" class="scp-row row">' . do_shortcode($content) . '</div>';

	return do_shortcode($content);
}
add_shortcode('row', 'sharketing_content_pimper_row');