<?php

function save_quote_template($template) {
	global $quote_templates;
	$template_key = null;
	foreach ($quote_templates as $k => $quote_template) {
		if ($quote_template['template_id'] == $template['template_id']) {
			$template_key = $k;
		}
	}
	if ($template_key !== null) {
		$tmp = $quote_templates[$template_key];
		$quote_templates[$template_key] = $template;

		$quote_templates[$template_key]['active'] = $tmp['active'];
	} else {
		$quote_templates []= $template;
	}
	scp_set_option('quote_templates', $quote_templates);
}

function get_quote_template_key($template_id) {
	global $quote_templates;
	$template_key = null;
	foreach ($quote_templates as $k => $quote_template) {
		if ($quote_template['template_id'] == $template_id) {
			$template_key = $k;
		}
	}
	return $template_key;
}


$quote_templates = scp_get_option('quote_templates') ?: array();

if (isset($_POST['toggle_active_quote_template'])) {
	$template_key = get_quote_template_key($_POST['toggle_active_quote_template']);
	if ($template_key !== null) {
		$quote_templates[$template_key]['active'] = !$quote_templates[$template_key]['active'];
		scp_set_option('quote_templates', $quote_templates);
	}
} else if (isset($_FILES['import_quote_templates'])) {
	if ($file = $_FILES['import_quote_templates']['tmp_name']) {
		if (file_exists($file)) {
			$xml = simplexml_load_file($file);	 
		}
	}

	if ($xml) {
		$xml = json_decode(json_encode($xml), true);
		foreach ($xml as $name => $v) {
			if (is_array($v)) {
				save_quote_template($v);
			}
		}
	} else {
		echo 'Failed to open XML-file<script>top.location="/wp-admin/options-general.php?page=sharketing-content-pimper%2Foptions.php";</script>';
		die();
	}
} else if (isset($_POST['save_template'])) {
	$template = json_decode(urldecode($_POST['save_template']), true);
	save_quote_template($template);
} else if (isset($_POST['create_new_template'])) {
	$new_template = json_decode(urldecode($_POST['create_new_template']), true);

	// get last key index for setting template_id
	end($quote_templates);
	$key = key($quote_templates);

	$new_template['template_id'] = $key + 1;

	save_quote_template($new_template);
} else if (isset($_GET['delete_quote_template'])) {
	$template_key = get_quote_template_key($_GET['delete_quote_template']);
	if ($template_key !== null) {
		unset($quote_templates[$template_key]);
		scp_set_option('quote_templates', $quote_templates);
	}
} else if (isset($_GET['duplicate_quote_template'])) {
	$template_key = get_quote_template_key($_GET['duplicate_quote_template']);
	if ($template_key !== null) {
		$copy_template = $quote_templates[$template_key];
		$copy_template['template_id'] = time()*1000;
		save_quote_template($copy_template);
		header('Location: /wp-admin/options-general.php?page=sharketing-content-pimper%2Foptions.php');
		die();
	}
}

function print_quote_template_example_iframe($quote) {
	echo '<iframe scrolling="yes" width="100%" height="300" src="/wp-content/plugins/sharketing-content-pimper/quote-iframe.php?quote_before_after_text=0&quote_type=' . $quote['type'] . '&quote_linecolor=' . $quote['line_color'] . '&quote_icon=' . $quote['icon'] . '&width=' . $quote['width'] . '&text_alignment=' . $quote['text_alignment'] . '&quote_backgroundcolor=' . $quote['background_color'] . '&font_color=' . $quote['font_color'] . '&font_size=' . urlencode($quote['font_size']) . '&font_italic=' . $quote['font_italic'] . '"/></iframe>';
}

?>
<script>
(function($) {
	$(document).on('click', '#scp-add-quote-button', function() {
		var name = prompt('Name of quote template:', '');
		if (!name) name = 'template' + (+new Date);
		var settings = scp_get_quote_modal_settings();
		settings.template_name = name;
		$('<form method="POST"><input type="hidden" name="create_new_template" value="' + encodeURIComponent(JSON.stringify(settings)) + '"></form>').appendTo('body').submit();
	});

	$(document).on('click', '#scp-save-quote-button', function() {
		var settings = scp_get_quote_modal_settings();
		$('<form method="POST"><input type="hidden" name="save_template" value="' + encodeURIComponent(JSON.stringify(settings)) + '"></form>').appendTo('body').submit();
	});
})(jQuery);
function edit_quote_template(props) {
	//scp_quote_modal({edit:true, hide_remove_button: true});
	//scp_resize_thickbox();
	scp_button_modal('quote',false,true);
	scp_quote_modal_fill(props);
	jQuery('#scp-add-quote-button').hide();
	jQuery('#scp-save-quote-button, .show-quote-template-edit').show();
	jQuery(window).trigger('resize');
}
function create_quote_template() {
	scp_quote_modal_fill({});
	scp_button_modal('quote',false,true);
	jQuery('#scp-add-quote-button').show();
	jQuery('#scp-save-quote-button, .show-template-edit, .quote-template-selector').hide();
	jQuery(window).trigger('resize');
}
function toggle_active_quote_template(template_id) {
	jQuery('<form method="POST"><input type="hidden" name="toggle_active_quote_template" value="' + template_id + '"></form>').appendTo('body').submit();
}
</script>

<form action="" method="post" enctype="multipart/form-data" style="position:absolute;width:1px;height:1px;opacity:0;top:-99999px;">
<input type="file" name="import_quote_templates" id="import_quote_templates" onchange="this.parentNode.submit()" style="position:absolute;width:1px;height:1px;opacity:0;top:-99999px;">
</form>

<h3 style="margin-bottom:0px">Templates (<?php echo count($quote_templates); ?>)
				
<button class="button" type="button" onclick="create_quote_template()">Create new template</button>
<button class="button" type="button" onclick="jQuery('#import_quote_templates').click()">Import templates</button>
<a class="button" type="button" href="/wp-admin/options-general.php?page=sharketing-content-pimper%2Foptions.php&scp_export_quote_templates=all">Export templates</a>

</h3>
<?php foreach ($quote_templates as $quote_template) { ?>
	<div style="width:40%;float:left;background:#cdcdcd;padding:1%;margin:1%;">
		<?php if (!$quote_template['active']) { ?><a href="/wp-admin/options-general.php?page=sharketing-content-pimper%2Foptions.php&delete_quote_template=<?php echo $quote_template['template_id']; ?>" onclick="if(!confirm('Are you sure? Do you want to delete this template?'))return false;" class="button" style="float:right">Delete</a><?php } ?>
		<a href="/wp-admin/options-general.php?page=sharketing-content-pimper%2Foptions.php&duplicate_quote_template=<?php echo $quote_template['template_id']; ?>" class="button" style="float:right;margin-right:10px;">Duplicate</a>
		<a href="javascript:;" onclick='edit_quote_template(<?php echo json_encode($quote_template); ?>)' class="button" style="float:right;margin-right:10px;">Edit</a>						
		<label style="float:right;margin-right:10px;line-height:25px;"><input type="checkbox" <?php checked($quote_template['active']); ?> onchange="toggle_active_quote_template(<?php echo $quote_template['template_id']; ?>)">Active</label>
		<h2 style="padding:0px;"><?php echo $quote_template['template_name']; ?> <span style="font-size:11px">(template id:<?php echo $quote_template['template_id']; ?>)</span></h2>
		<br><?php print_quote_template_example_iframe($quote_template); ?>
	</div>
<?php } ?>