<?php

add_filter('scp_pimper_options', function($options) {
	$options['colorbox'] = 'Kleurbox';
	return $options;
});

add_action('scp_pimper_option_colorbox', function() {

	// implement msbf options for showing header type
	if (is_plugin_active('sharketing-smart-blogger-feedback/msbf.php')) {
		$msbf_options = get_option('msbf_options');
		$headings = array();
		for ($i = 2; $i < 7; $i++) {
			if (!$msbf_options['formatHeading_' . $i]) {
				$headings []= $i;
			}
		}
	} else {
		$headings = array(2,3,4,5,6);
	}

?>

<div>
Select colorbox template: <select id="scp-colorbox-template-selector"><option></option>
<?php foreach (scp_get_option('colorbox_templates') as $template) { if (!$template['active']) continue; ?>
	<option value="<?php echo urlencode(json_encode($template)); ?>" data-template-id="<?php echo $template['template_id']; ?>"><?php echo $template['template_name']; ?></option>
<?php } ?>
</select>
<iframe id="scp-colorbox-template-example" src="" width="100%" height="250" style="display:none;border:2px solid #cdcdcd;"></iframe>
</div>

<div class="show-colorbox-template-edit show-template-edit">
	Template name: <input type="text" value="" name="scp-colorbox-template-name" />
	<input type="hidden" value="" name="scp-colorbox-template-id" />
</div>

<div class="show-custom-options-colorbox-checkbox" style="display:none"><label><input type="checkbox" /> Meer opties</label></div>

<div class="custom-options-colorbox" style="display:none">

<h3>1. Kies stijl</h3>

<h4 style="margin-bottom:0px;padding-bottom:0px;">Border color</h4>
<input type="text" name="scp-colorbox-bordercolor-picker" />

<h4 style="margin-bottom:0px;padding-bottom:0px;">Background color</h4>
<input type="text" name="scp-colorbox-backgroundcolor-picker" />

<h4 style="margin-bottom:0px;padding-bottom:0px;">Font color</h4>
<input type="text" name="scp-colorbox-fontcolor-picker" />

<h4 style="margin-bottom:0px;padding-bottom:0px;">Width (in px or %)</h4>
<div><input type="text" id="scp-colorbox-width" name="scp-colorbox-width" /><select name="scp-colorbox-width-type"><option>%</option><option>px</option></select></div>

<h4 style="margin-bottom:0px;padding-bottom:0px;">Alignment</h4>
<div><select name="scp-colorbox-text-alignment"><option value="">(default)</option><option value="left">Left</option><option value="center">Center</option><option value="right">Right</option></select></div>

<h3>2. Kop</h3>
<div><label><input type="checkbox" name="scp-colorbox-addheader" value="" /> Gebruik een kop</label></div>
<div id="scp-colorbox-addheader-options" style="display:none">

	<!--<h4 style="margin-bottom:0px;padding-bottom:0px;">Header text</h4>
	<input type="text" name="scp-colorbox-headertext" />-->

	<h4 style="margin-bottom:0px;padding-bottom:0px;">Header color</h4>
	<input type="text" name="scp-colorbox-headercolor-picker" />

	<h4 style="margin-bottom:0px;padding-bottom:0px;">Header font color</h4>
	<input type="text" name="scp-colorbox-headerfontcolor-picker" />

	<h4 style="margin-bottom:0px;padding-bottom:0px;">Header type</h4>
	<select name="scp-colorbox-headertext-type"><option value="">Normal text</option>
	<?php foreach ($headings as $heading) { ?>
	<option value="h<?php echo $heading; ?>">H<?php echo $heading; ?></option>
	<?php } ?>
	</select>

	<h4 style="margin-bottom:0px;padding-bottom:0px;">Header font weight</h4>
	<label><input type="checkbox" name="scp-colorbox-headerbold" value="" /> Make bold</label>

	<h4 style="margin-bottom:0px;padding-bottom:0px;">Alignment</h4>
	<select name="scp-colorbox-headertext-alignment"><option value="left">Left</option><option value="center" selected>Center</option><option value="right">Right</option></select>


</div>

<h3>3. Bolletje</h3>
<div><label><input type="checkbox" name="scp-colorbox-addcircle" value="" /> Zet een bolletje boven de box</label></div>
<div id="scp-colorbox-addcircle-options" style="display:none">

	<h4 style="margin-bottom:0px;padding-bottom:0px;">Text</h4>
	<input type="text" name="scp-colorbox-circletext" />

	<h4 style="margin-bottom:0px;padding-bottom:0px;">Background color</h4>
	<input type="text" name="scp-colorbox-circlecolor-picker" />

	<h4 style="margin-bottom:0px;padding-bottom:0px;">Font color</h4>
	<input type="text" name="scp-colorbox-circlefontcolor-picker" />

	<h4 style="margin-bottom:0px;padding-bottom:0px;">Font size</h4>
	<input type="text" name="scp-colorbox-circlefontsize" />

</div>

</div>

<button class="button button-primary" id="scp-add-colorbox-button" onclick="scp_add_colorbox()" style="margin-top:15px;">Toevoegen</button>
<button class="button button-primary" id="scp-save-colorbox-button" style="margin-top:15px;display:none">Opslaan</button>

<script>
	function scp_get_colorbox_params() {
		var params = {
			border_color: jQuery('[name="scp-colorbox-bordercolor-picker"]').val(),
			background_color: jQuery('[name="scp-colorbox-backgroundcolor-picker"]').val(),
			font_color: jQuery('[name="scp-colorbox-fontcolor-picker"]').val(),
			width: jQuery('[name="scp-colorbox-width"]').val() ? jQuery('[name="scp-colorbox-width"]').val() + jQuery('[name="scp-colorbox-width-type"]').val() : '',
			text_alignment: jQuery('[name="scp-colorbox-text-alignment"]').val(),

			template_name: jQuery('[name="scp-colorbox-template-name"]').val(),
			template_id: jQuery('[name="scp-colorbox-template-id"]').val()
		};

		params['add_header'] = false;
		if (jQuery('[name="scp-colorbox-addheader"]').is(':checked')) {
			//params['header_text'] = jQuery('[name="scp-colorbox-headertext"]').val();
			params['add_header'] = true;
			params['header_color'] = jQuery('[name="scp-colorbox-headercolor-picker"]').val();
			params['header_font_color'] = jQuery('[name="scp-colorbox-headerfontcolor-picker"]').val();
			params['header_text_alignment'] = jQuery('[name="scp-colorbox-headertext-alignment"]').val();
			params['header_text_type'] = jQuery('[name="scp-colorbox-headertext-type"]').val();
			params['header_text_bold'] = jQuery('[name="scp-colorbox-headerbold"]').is(':checked');
		}

		if (jQuery('[name="scp-colorbox-addcircle"]').is(':checked')) {
			params['circle_text'] = jQuery('[name="scp-colorbox-circletext"]').val();
			params['circle_color'] = jQuery('[name="scp-colorbox-circlecolor-picker"]').val();
			params['circle_font_color'] = jQuery('[name="scp-colorbox-circlefontcolor-picker"]').val();
			params['circle_font_size'] = jQuery('[name="scp-colorbox-circlefontsize"]').val();
		}

		return params;
	}

	function scp_add_colorbox() {
		var params = scp_get_colorbox_params();

		// add header text
		if (params.add_header) {
			var nodes = scp_editor_get_selected_nodes();
			if (tinymce.activeShortcode && tinymce.activeShortcode.params.header_text) {
				params['header_text'] = tinymce.activeShortcode.params.header_text;
			} else if (nodes.length > 0 && (nodes[0].nodeName == 'H2' || nodes[0].nodeName == 'H3')) {
				params['header_text'] = jQuery(nodes[0]).html();
				params['header_text_type'] = nodes[0].nodeName;
				jQuery(nodes[0]).remove();
			}
			while (!params['header_text']) {
				params['header_text'] = prompt('Header text (required):', '');
			}
		}

		// unset default template params
		// only keep changed params
		if (colorbox_template) {
			scp_remove_template_params(params, colorbox_template);
		}

		//delete params.template_id;
		delete params.template_name;
		//delete params.add_header;

		var code = scp_make_code('colorbox', params);
		var node = scp_editor_get_node();
		if (node && tinymce.activeShortcode) {
			var html = scp_remove_shortcode(node.html(), 'colorbox');
			if (code[0] == node.html()) {
				node.html(code[0]);
			} else if (node.html().indexOf(html) != -1 && node.html().indexOf(code[1]) == -1) {
				node.html(code[0] + html);
			} else {
				node.html(code[0] + html + code[1]);
			}
			scp_close_thickbox();
		} else {
			scp_enclose_editor_selection(code[0], code[1]);
		}
	}

	var colorbox_template;

	(function($) {

		$(document).on('change', '.show-custom-options-colorbox-checkbox input', function() {
			$('.show-custom-options-colorbox-checkbox')[$(this).is(':checked') ? 'hide' : 'show']();
			$('.custom-options-colorbox')[$(this).is(':checked') ? 'show' : 'hide']();
		});

		$('#scp-colorbox-template-selector').change(function() {
			if (!$(this).val()) {
				colorbox_template = null;
				$('#scp-colorbox-template-example').hide();
				$('.custom-options-colorbox').hide();
				$('.show-custom-options-colorbox-checkbox').hide();
				$('.show-custom-options-colorbox-checkbox input').prop('checked', false);
				return;
			}

			$('.custom-options-colorbox').hide();
			$('.show-custom-options-colorbox-checkbox').show();
			$('.show-custom-options-colorbox-checkbox input').prop('checked', false);

			colorbox_template = JSON.parse(decodeURIComponent($(this).val()));

			scp_colorbox_modal_fill(colorbox_template);

			$('#scp-colorbox-template-example').show().attr('src', '/wp-content/plugins/sharketing-content-pimper/colorbox-iframe.php?_before_after_text=0&template_id=' + colorbox_template.template_id + '&add_header=' + colorbox_template.add_header);
		});

		$('[name="scp-colorbox-bordercolor-picker"], [name="scp-colorbox-backgroundcolor-picker"], [name="scp-colorbox-fontcolor-picker"], [name="scp-colorbox-headercolor-picker"], [name="scp-colorbox-headerfontcolor-picker"], [name="scp-colorbox-circlecolor-picker"], [name="scp-colorbox-circlefontcolor-picker"]').wpColorPicker({change: function() {
			//setTimeout(function() {
			//	$('[name="scp-quote-type"]:checked').trigger('change');
			//});
		}});

		$('[name="scp-colorbox-addheader"]').change(function() {
			if ($(this).is(':checked')) {
				$('#scp-colorbox-addheader-options').show();
			} else {
				$('#scp-colorbox-addheader-options').hide();
			}
		});

		$('[name="scp-colorbox-addcircle"]').change(function() {
			if ($(this).is(':checked')) {
				$('#scp-colorbox-addcircle-options').show();
			} else {
				$('#scp-colorbox-addcircle-options').hide();
			}
		});
	})(jQuery);
</script>
<?php
});


function sharketing_content_pimper_colorbox($atts, $content) {

	// load template
	if (isset($atts['template_id']) && $atts['template_id']) {
		$colorbox_templates = scp_get_option('colorbox_templates') ?: array();
		$the_template = null;
		foreach ($colorbox_templates as $template) {
			if ($template['template_id'] == $atts['template_id']) {
				$the_template = $template;
				break;
			}
		}
		if ($the_template) {
			$atts = array_merge($the_template, $atts);
		}
	}

	$uid = 'scpcolorbox' . uniqid();

	$style = '<style>';

	$style .= '#' . $uid . '{';

	//$style .= 'padding: 20px;';
	
	if (isset($atts['circle_text']) && $atts['circle_text']) {
		$style .= 'margin-top:50px;';
		$style .= 'padding-top:50px;';
	}

	if (isset($atts['border_color']) && $atts['border_color']) {
		$style .= 'border: 2px solid ' . scp_parse_colorcss($atts['border_color']) . ';';
	}

	if (isset($atts['background_color']) && $atts['background_color']) {
		$style .= 'background-color: ' . scp_parse_colorcss($atts['background_color']) . ';';
	}

	if (isset($atts['width']) && $atts['width']) {
		if (!strpos($atts['width'], 'px') && !strpos($atts['width'], '%')) {
			$atts['width'] .= 'px';
		}
		$style .= 'width:' . $atts['width'] . ';';
	}

	if (isset($atts['text_alignment']) && $atts['text_alignment']) {
		$style .= 'text-align:' . $atts['text_alignment'] . ';';
	}	

	$style .= '}';

	$style .= '#' . $uid . ' .scp-colorbox-content > *{';
	if (isset($atts['font_color']) && $atts['font_color']) {
		$style .= 'color: ' . scp_parse_colorcss($atts['font_color']) . ';';
	}
	$style .= '}';

	$style .= '#' . $uid . ' .scp-colorbox-content{';
	$style .= 'padding: 20px;';

	if (isset($atts['header_text']) && $atts['header_text'] && isset($atts['header_color']) && !$atts['header_color']) {
		$style .= 'padding-top:0px;';
	}
	$style .= '}';

	$style .= '#' . $uid . ' .scp-colorbox-header{';
	if (isset($atts['header_color']) && $atts['header_color']) {
		$style .= 'background-color: ' . scp_parse_colorcss($atts['header_color']) . ';';
	}
	if (isset($atts['header_text_bold']) && $atts['header_text_bold']) {
		$style .= 'font-weight:bold;';
	}
	$style .= '}';
	$style .= '#' . $uid . ' .scp-colorbox-header, #' . $uid . ' .scp-colorbox-header .scp-colorbox-header-text, #' . $uid . ' .scp-colorbox-header p{';
	if (isset($atts['header_font_color']) && $atts['header_font_color']) {
		$style .= 'color: ' . scp_parse_colorcss($atts['header_font_color']) . ';';
	}
	$style .= 'text-align: ' . ($atts['header_text_alignment'] ?: 'center') . ';';
	$style .= '}';

	$style .= '#' . $uid . ' .scp-colorbox-header span.scp-colorbox-header-text{';
	$style .= 'font-size: ' . get_theme_mod('content_fontsize_paragraph', 14) . 'px;';
	$style .= '}';

	$style .= '#' . $uid . ' .scp-colorbox-circle{';
	if (isset($atts['circle_color']) && $atts['circle_color']) {
		$style .= 'background-color: ' . scp_parse_colorcss($atts['circle_color']) . ';';
	}
	if (isset($atts['circle_font_color']) && $atts['circle_font_color']) {
		$style .= 'color: ' . scp_parse_colorcss($atts['circle_font_color']) . ';';
	}
	if (isset($atts['circle_font_size']) && $atts['circle_font_size']) {
		$style .= 'font-size: ' . $atts['circle_font_size'] . 'px;';
	}
	$style .= '}</style>';

	if (isset($atts['header_text']) && $atts['header_text']) {
		$header_text_type = $atts['header_text_type'] ?: 'span';
		$header = '<div class="scp-colorbox-header"' . (isset($atts['circle_text']) && $atts['circle_text'] ? ' style="margin-top:-50px;padding-top:50px;"' : '') . '><' . $header_text_type . ' class="scp-colorbox-header-text">' . $atts['header_text'] . '</' . $header_text_type . '></div>';
		$content = str_replace(array('<' . $header_text_type . '>' . $atts['header_text'] . '</' . $header_text_type . '>', '<' . strtolower($header_text_type) . '>' . $atts['header_text'] . '</' . strtolower($header_text_type) . '>'), '', $content);
	}
	$circle = '';
	if (isset($atts['circle_text']) && $atts['circle_text']) {
		$circle = '<div class="scp-colorbox-circle">' . $atts['circle_text'] . '</div>';
	}

	$content = '<div id="' . $uid . '" class="scp-colorbox ' . $atts['class'] . '">' . $circle . $header . '<div class="scp-colorbox-content">' . $content . '</div></div>' . $style;

	// remove empty lines
	$content = str_replace(array('<p></p>', '<br />', '<p class="scp-code scp-code-start">', '<p class="scp-code scp-code-end">'), '', $content);
	$content = str_replace('"></p>', '">', $content);
	$content = str_replace('v></p>', 'v>', $content);

	return do_shortcode($content);
}
add_shortcode('colorbox', 'sharketing_content_pimper_colorbox');