<?php
	
function esp_parse_promotion_content($promotion_content) {
	return '<div style="clear:both;margin:' . get_theme_mod('content_lineheight_paragraph', 19) . 'px 0px;">' . $promotion_content . '</div>';
}

// lazy loading, because this function and the functions its using are pretty slow
function get_current_post_page_number() {
	global $_current_post_page_number;
	if (!isset($_current_post_page_number)) {
		$_current_post_page_number = get_post_page_number(get_post()->ID);
	}
	return $_current_post_page_number;
}

function is_post_published() {
	return get_post_status(get_post()->ID) == 'publish';
}

function handle_fetched_promotion($signature) {
	$promotionCookie = 'promotion' . $signature['id'];
		
	// if there are multiple promotions, check if cookie has stored a promotion id otherwise select one
	if (count($signature['promotions']) > 1) {
		$promotionId = $_COOKIE[$promotionCookie] = isset($_COOKIE[$promotionCookie]) ? $_COOKIE[$promotionCookie] : array_rand($signature['promotions'], 1);
		if ($signature['lock_visitor_to_subpromo']) {
			if (!headers_sent()) {
				setcookie($promotionCookie, $promotionId, time()+3600*24*365);
			} else {
				// when headers already sent, then set cookie with javascript
				echo "<script>document.cookie='" . $promotionCookie . "=" . $promotionId . ";path=/;expires=" . date(DATE_COOKIE, time()+3600*24*365) . ";';</script>";
			}
		}

	// there are no multiple promotions, sow if cookie is set, remove cookie
	} else if (isset($_COOKIE[$promotionCookie])) {
		$promotionId = 0;
		unset($_COOKIE[$promotionCookie]);
		if (!headers_sent()) {
			setcookie($promotionCookie, $promotionId, time()-3600*24*365);
		} else {
			// when headers already sent, then remove cookie with javascript
			echo "<script>document.cookie='" . $promotionCookie . "=; expires=Thu, 01 Jan 1970 00:00:01 GMT;';</script>";
		}
	}

	// select a promotion
	if (isset($promotionId) && isset($signature['promotions'][$promotionId])) {
		$promotion =& $signature['promotions'][$promotionId];
	} else {
		$promotion =& $signature['promotions'][0];
	}

	$signature['original_signature'] = $signature;
	$signature['selected_promotion'] =& $promotion;

	// add custom html and css before promotion
	if ($promotion['use_custom_html_css_code']) {
		$signature['content'] = '<script>var aa = "<br>";var magnate_easy_promotion_html=' . json_encode(rawurlencode(esp_parse_promotion_content(nl2br($promotion['custom_html_css'])))) . ';function resizeIframe(obj) { obj.style.height = obj.contentWindow.document.body.scrollHeight + "px"; }</script><iframe style="width:100%;" frameborder="0" scrolling="no" onload="if (this.loaded){resizeIframe(this);return;}this.loaded=1;this.src=\'data:text/html;charset=utf-8,\' + magnate_easy_promotion_html;" src="data:text/html;charset=utf-8,bezig met laden..."></iframe>';
	} else {
		// remove slashes promotion html
		$signature['content'] = stripslashes(esp_parse_promotion_content($promotion['content']));
	}

	return $signature;
}

function find_promotion($location) {
	global $espLoader;
	$signatures = $espLoader->get_promotions();

	$authorId = get_post()->post_author;

	$cat = get_the_category(get_post());
	$cat_ids = array_map(function($cat) {
		return $cat->cat_ID;
	}, $cat);

	// filter signatures, by category and author
	foreach ($signatures as $key => $signature) {
		if (!$signature['enabled'] || 

			(
			// normal promotions
			(
			(!empty($signature['categories']) && count(array_intersect($cat_ids, $signature['categories'])) == 0) || 
			(!empty($signature['authors']) && !in_array($authorId, $signature['authors'] ?: array())) || 
			!is_single() || 
			(is_post_published() && !(get_current_post_page_number() >= $signature['display_from'] && get_current_post_page_number() <= ($signature['display_to'] == 'Till the end' ? 99999 : $signature['display_to']))) || 
			($signature['signature_position'] != $location && !($signature['signature_position'] == 'above_heading' && $signature['signature_position'] . $signature['signature_position_heading'] == $location /* <= check for above_heading */) && !($signature['signature_position'] == 'after_n_comments' && $signature['signature_position'] . $signature['after_n_comments_position'] == $location /* <= check for after_n_comments */))
			)

			&&

			// banner promotion can override visibility
			(!is_banner_promotion_visible_override($signature))
			)
				
			
			) {
			unset($signatures[$key]);
		}
	}

	// often there are more signatures available, so wich one to show
	// the signatures will be prioritized, on the amount of categories and authors
	// so the less categories and the less authores, the more change the signature will be shown (the lower the _entropy value will be)
	foreach ($signatures as $k => $signature) {
		$signatures[$k]['_entropy'] = count($signature['categories'])*5 + count($signature['authors'])*3;
	}

	// select the best signature with the lowest _entropy
	$signature = null;
	foreach ($signatures as $s) {
		if (!$signature || $signature['_entropy'] > $s['_entropy']) {
			$signature = $s;
		}
	}

	if ($signature) {

		// entropy value isn't used anymore
		unset($signature['_entropy']);

		$signature = handle_fetched_promotion($signature);

	}

	return $signature;
}

function get_promotions() {
	global $_tmp_easy_post_promotions_promotions;
	if (!isset($_tmp_easy_post_promotions_promotions)) {
		global $espLoader;
		$locations = array_keys($espLoader->get_locations());
		$_tmp_easy_post_promotions_promotions = array();
		foreach ($locations as $location) {
			if ($location == 'above_heading') {
				for ($i = 1; $i <= 20; $i++) {
					$_tmp_easy_post_promotions_promotions[$location . $i] = find_promotion($location . $i);
				}
				continue;
			} else if ($location == 'after_n_comments') {
				for ($i = 1; $i <= 20; $i++) {
					$_tmp_easy_post_promotions_promotions[$location . $i] = find_promotion($location . $i);
				}
				continue;
			}
			$_tmp_easy_post_promotions_promotions[$location] = find_promotion($location);
		}
	}
	return $_tmp_easy_post_promotions_promotions;
}

function get_promotion($location) {
	$promotions = get_promotions();
	return $promotions[$location];
}

function replace_signature_shortcodes($content) {
	global $espLoader;
	$pattern = '#\[magnate_promo_(.+?)\]#is';
	preg_match_all($pattern, $content, $matches, PREG_SET_ORDER);
	foreach ($matches as $match) {
		if ($signature = $espLoader->getSignatureById($match[1])) {
			if (strpos($content, $match[0]) !== false) {
				$signature = handle_fetched_promotion($signature);
				$content = str_replace($match[0], esp_parse_promotion_content($signature['content']), $content);
				count_views_promotions($signature);
			}
		} else {
			$content = str_replace($match[0], '[Promotion not found!]', $content);
		}
	}
	return $content;
}

function can_count_views_promotions() {
	global $espLoader;
	return !is_user_logged_in() && !in_array($_SERVER["HTTP_CF_CONNECTING_IP"] ? $_SERVER["HTTP_CF_CONNECTING_IP"] : $_SERVER["REMOTE_ADDR"], explode("\n", $espLoader->get_option('exclude_ips_views')));
}

function add_js_view_counter($promotion) {
	if (!can_count_views_promotions()) return;
	global $_sepp_js_views_counter_promotions;
	if (!isset($_sepp_js_views_counter_promotions)) {
		add_action('wp_footer', function() {
			global $_sepp_js_views_counter_promotions;
			$admin_ajax_url = admin_url('admin-ajax.php?action=sepp_promo_view&promo_ids=' . implode(',',array_keys($_sepp_js_views_counter_promotions)) . '&sub_promo_ids=' . implode(',',array_values($_sepp_js_views_counter_promotions)));
			$admin_ajax_url .= '&sepp_check=' . MD5('sepp' . $admin_ajax_url . 'sepp');
			echo '<script>jQuery&&(function($){$(window).load(function(){var im=new Image();im.src="' . $admin_ajax_url . '";})})(jQuery);</script>';
			//echo '<img src="' . $admin_ajax_url . '" width="1" height="1" style="position:absolute;left:0px;opacity:0;" />';
		});
	}	
	$_sepp_js_views_counter_promotions[$promotion['id']] = $promotion['selected_promotion']['id'];
}

function sepp_add_view_count_promotion($promotion_id, $sub_promotion_id) {
	global $espLoader;
	if (!can_count_views_promotions()) return;
	$esp_views = get_option('esp_views');
	if (!$esp_views) {
		$esp_views = array();
		add_option('esp_views', $esp_views, false, 'yes');
	}
	// add views +1 and save signature
	$esp_views[$promotion_id]['total']++;
	$esp_views[$promotion_id]['promo' . $sub_promotion_id]++;
	update_option('esp_views', $esp_views);
//	wp_cache_flush();
}

function count_views_promotions($promotion) {
	add_js_view_counter($promotion);
}

function sepp_promotion_view() {
	global $espLoader;
	// check if user has viewed these promotions
	$admin_ajax_url = admin_url('admin-ajax.php?action=sepp_promo_view&promo_ids=' . $_GET['promo_ids'] . '&sub_promo_ids=' . $_GET['sub_promo_ids']);
	if ($_GET['sepp_check'] === MD5('sepp' . $admin_ajax_url . 'sepp')) {
		$promotion_ids = explode(',', $_GET['promo_ids']);
		$sub_promotion_ids = explode(',', $_GET['sub_promo_ids']);
		foreach ($promotion_ids as $k => $promotion_id) {
			if ($espLoader->getSignatureById($promotion_id)) {
				sepp_add_view_count_promotion($promotion_id, $sub_promotion_ids[$k]);
			}
		}
	}
}
add_action('wp_ajax_sepp_promo_view', 'sepp_promotion_view');
add_action('wp_ajax_nopriv_sepp_promo_view', 'sepp_promotion_view');

function add_promotion_to_content($content) {
	//if (is_singular('post')) {
		foreach (get_promotions() as $promotion) {
			$pos = isset($promotion['signature_position']) && !empty($promotion['signature_position']) ? $promotion['signature_position'] : '';
			$disabledLocations = get_post_meta(get_post()->ID, 'esp_disabled_locations', true) ?: array();
			$hidePromotions = get_post_meta(get_post()->ID, 'mepp_hide_promotions', true);
			if (!$hidePromotions && !in_array($pos, $disabledLocations)) {
				if ($pos == 'at_the_end') {
					$content .= '<p></p>' . $promotion['content'];
					count_views_promotions($promotion);
				} else if ($pos == 'above_heading') {
					$pattern = '#<h([1-6])(?: [^>]+)?>(.+?)</h\1>#is';
					preg_match_all($pattern, $content, $matches, PREG_SET_ORDER);
					$mpos = $promotion['signature_position_heading'] - 1;
					$content = str_replace($matches[$mpos][0], $promotion['content'] . $matches[$mpos][0], $content);
					count_views_promotions($promotion);
				}
			}
		}
		$content = replace_signature_shortcodes($content);
	//}
	return $content;
}
add_filter('the_content', 'add_promotion_to_content', 1);

function add_promotion_before_title($title) {
	if ($title == get_post()->post_title && is_main_query()) {
		foreach (get_promotions() as $promotion) {
			if (!$promotion) {
				continue;
			}
			$pos = $promotion['signature_position'];
			$disabledLocations = get_post_meta(get_post()->ID, 'esp_disabled_locations', true) ?: array();
			$hidePromotions = get_post_meta(get_post()->ID, 'mepp_hide_promotions', true);
			if (!$hidePromotions && !in_array($pos, $disabledLocations)) {
				if ($pos == 'above_the_title') {
					$title = '</h1><p>' . do_shortcode($promotion['content']) . '</p><h1>' . $title;
					count_views_promotions($promotion);
				}
			}
		}
	}
	return $title;
}

add_filter('the_title', 'add_promotion_before_title', 1);

function is_banner_promotion($promotion) {
	return $promotion['signature_position'] == 'banner_left_from_the_content';
}

function is_banner_promotion_visible_override($promotion) {
	if (is_front_page()) {
		// Default homepage
		if ($promotion['banner_left_from_the_content_show_on_homepage']) {
			return true;
		}
	} elseif (is_home()) {
		// blog page
		if ($promotion['banner_left_from_the_content_show_on_blogpage']) {
			return true;
		}
	}
	return false;
}

function add_banner_promotion() {
	$pos = 'banner_left_from_the_content';
	if ($promotion = get_promotion($pos)) {
		$disabledLocations = get_post_meta(get_post()->ID, 'esp_disabled_locations', true) ?: array();
		$hidePromotions = get_post_meta(get_post()->ID, 'mepp_hide_promotions', true);
		if (!$hidePromotions && !in_array($pos, $disabledLocations)) {
			//if (is_banner_promotion_visible_override($promotion)) {				
				count_views_promotions($promotion);
				$content = '<div id="esp-banner-left">';
				$content .= $promotion['content'];
				$content .= '</div><style>#esp-banner-left{position:fixed;z-index:999999;animation:a2aFadeIn .2s ease-in;left:' . $promotion['banner_left_from_the_content_offset'] . 'px;top:' . $promotion['banner_left_from_the_content_position'] . 'px;transition: all .2s ease-in-out;}body.senhtheme-scrolling #esp-banner-left{top:' . $promotion['banner_left_from_the_content_position_scrolling'] . 'px;}.a2a_kit.a2a_floating_style{display:none;}</style>';

				if ($promotion['banner_left_from_the_content_responsive']) {
					$content .= '<style>@media screen and (max-width:' . $promotion['banner_left_from_the_content_responsive_max_width'] . 'px){#esp-banner-left{display:none;}}</style>';
				}

				echo $content;
			//}
		}
	}
}

add_action('wp_footer', 'add_banner_promotion');

function sepp_add_promotion_below_commentbox() {
	$pos = 'above_footer';
	if ($promotion = get_promotion($pos)) {
		$disabledLocations = get_post_meta(get_post()->ID, 'esp_disabled_locations', true) ?: array();
		$hidePromotions = get_post_meta(get_post()->ID, 'mepp_hide_promotions', true);
		if (!$hidePromotions && !in_array($pos, $disabledLocations)) {
			count_views_promotions($promotion);
			echo $promotion['content'];
		}
	}
}
add_action('get_footer', 'sepp_add_promotion_below_commentbox', 2, 10);

$_sepp_comment_nr = 0;
function sepp_add_promotion_after_n_comments() {
	global $_sepp_comment_nr;
	$_sepp_comment_nr++;
	if ($promotion = get_promotion('after_n_comments' . $_sepp_comment_nr)) {
		$pos = $promotion['signature_position'];
		$disabledLocations = get_post_meta(get_post()->ID, 'esp_disabled_locations', true) ?: array();
		$hidePromotions = get_post_meta(get_post()->ID, 'mepp_hide_promotions', true);
		if (!$hidePromotions && !in_array($pos, $disabledLocations)) {
			echo $promotion['content'];
			count_views_promotions($promotion);
		}
	}
}
add_action('senhblog_after_comment_template', 'sepp_add_promotion_after_n_comments');

//add_action('comment_form_before', 'add_promotion_after_last_comment');

function get_post_page_number($postID) {
	return ceil(get_post_number($postID)/get_option('posts_per_page'));
}

function get_post_number($postID){
	global $wp_query;
	$temp_query = $wp_query;
	$postNumberQuery = new WP_Query('orderby=date&posts_per_page=-1');
	$counter = 1;
	$postCount = 0;
	if($postNumberQuery->have_posts()) :
		while ($postNumberQuery->have_posts()) : $postNumberQuery->the_post();
			if ($postID == get_the_ID()){
				$postCount = $counter;
				break;
			} else {
				$counter++;
			}
	endwhile; endif;
	wp_reset_query();
	$wp_query = $temp_query;
	return $postCount;
}
