<?php

abstract class AFeedbackCheck {

	public function isValid($post) {
		die('not yet implemented');
	}
	
	public function getError($lang = null, $raw = false) {
		if (!$lang) $lang = 'en_EN';
		$errorLine = getOption('feedback_' . $this->getOptionName() . '_' . $lang) ?: $this->defaultError[$lang];
		if ($raw == false && isset($this->errorVars) && is_array($this->errorVars)) {
			foreach ($this->errorVars as $var => $val)
				$errorLine = str_replace('[' . $var . ']', $val, $errorLine);
		}
		return $errorLine;
	}

	public function getOptionName() {
		return strtolower(str_replace(array(' ', "'"), array('_', ''), $this->name));
	}

	public function ignoredPost($post) {
		$option = getOption('ignoredFeedbacks');
		return isset($option[$this->getOptionName()][$post->ID]);
	}

	public function ignorePost($post) {
		$option = getOption('ignoredFeedbacks');
		$option = $option ?: array();
		if (!isset($option[$this->getOptionName()][$post->ID])) {
			$option[$this->getOptionName()][$post->ID] = 1;
		}
		setOption('ignoredFeedbacks', $option);
	}

}