<?php

require_once('AFeedbackCheck.php');

class FeedbackHandler {

	public function __construct(){
		//add_filter('post_updated_messages', array(&$this, 'addPostUpdatedMessages'));	
		
		add_action('load-post.php', array(&$this, 'addLoadPostListener'));

		if (is_admin()) {
			add_action('publish_post', array(&$this, 'publishPost'));
			add_action('save_post', array(&$this, 'savePost'), 99999);

			$this->loadFeedbackChecks();
			$this->updateYoastWPSEOOptions();
 			//add_action('wpseo_options', array(&$this, 'updateYoastWPSEOOptions'), 1);
		}
	}

	public function addLoadPostListener() {
		$screen = get_current_screen();
		// Only post screen:  
		if('post' === $screen->id || 'page' === $screen->id) {  
			$this->onPostScreen();
		}
	}

	public function onPostScreen() {
		$this->checkForFeedback();
		add_action('all_admin_notices', array(&$this, 'printAdminMessage'));
	}

	public function loadFeedbackChecks() {
		$feedbackChecks = array();
		$dir = dirname(__FILE__) . '/feedback-checks';
		if ($handle = opendir($dir)) {
			while (false !== ($entry = readdir($handle))) {
				if ($entry == '.' || $entry == '..') continue;
				// only load php files
				if (pathinfo($entry, PATHINFO_EXTENSION) != 'php') continue;
				// load class and init object
				require_once($dir . '/' . $entry);
				$className = basename($entry, '.php');
				$feedbackChecks []= new $className();
			}
		}
		usort($feedbackChecks, function($a, $b) {
			$a = $a->sort;
			$b = $b->sort;
			if ($a == $b) return 0;
			return ($a < $b) ? -1 : 1;
		});
		$this->feedbackChecks = $feedbackChecks;
	}

	public function isEnabledFeedbackCheck($feedbackCheck) {
		global $msbfLoader;
		return !!$msbfLoader->options[$feedbackCheck->getOptionName()];
	}

	public function checkForceFeedbackImplementation($post) {
		global $msbfLoader;
		$this->checkForFeedback();
		$feedbackErrors = $this->errors;
		if (!empty($feedbackErrors)) {
			wp_update_post(array('ID' => $post->ID, 'post_status' => 'draft'));
			$msbfLoader->options['forcedFeedbackFailedPublished'][$post->ID] = $this->errors;
			$msbfLoader->save_options();
		}
	}

	public function publishPost() {
		if (getOption('forceFeedbackImplementation')) {
			$post = get_the_post();
			if ($post->post_status == 'draft' || $post->post_status == 'auto-draft') {
				$this->checkForceFeedbackImplementation($post);
			}
		}
	}

	public function savePost() {		
		$post = get_post(get_the_ID());

		if (!$post) return;

		if (getOption('forceFeedbackImplementation')) {
			// fetch new saved post data
			$this->checkForFeedback();
			if ($post->post_status == 'future') {
				add_action('save_post', array(&$this, 'savePost'));
				$this->checkForceFeedbackImplementation($post);
			}
		}

		if (getOption('sentenceCaseTitles') && (!getOption('disableCasingForAdministrators') || !is_truly_admin())) {
			// update post title
			$title = $post->post_title;
			$newPostTitle = $this->caseTitleWords($title);
			if ($newPostTitle != $title) {
				wp_update_post(array('ID' => $post->ID, 'post_title' => $newPostTitle));
			}

			// update all in one seo title
			$meta = '_aioseop_title';
			$title = get_post_meta($post->ID, $meta, true);
			$newTitle = $this->caseTitleWords($title);			
			if ($newTitle != $title) {
				update_post_meta($post->ID, $meta, $newTitle, $title);
			}
		}
	}

	public function updateYoastWPSEOOptions() {
		if (getOption('sentenceCaseTitles') && (!getOption('disableCasingForAdministrators') || !is_truly_admin())) {
			// solution 2: just replace post value
			if (isset($_POST['yoast_wpseo_title'])) {
				$title = $_POST['yoast_wpseo_title'];
				$newTitle = $this->caseTitleWords($title);
				$_POST['yoast_wpseo_title'] = $newTitle;
			}
			// solutation 1: replace post meta value (works, but gives an error: EO Issue: Your theme contains a meta description, which b... blabla)
			//$meta = '_yoast_wpseo_title';
			//$title = get_post_meta(get_the_post()->ID, $meta, true);
			//$newTitle = $this->caseTitleWords($title);
			//update_post_meta(get_the_post()->ID, $meta, $newTitle, $title);
		}
	}

	public function caseTitleWords($title) {
		global $msbfLoader;		
		// escape preg modifiers
		$title = preg_quote($title, '/');
		$ignoreWords = explode(' ', optionOr('sentenceCaseTitlesWords_' . langtoiso(getOption('feedbackLanguage')), $msbfLoader->msbfAdminPanel->getDefaultCaseWords()));
		$titleWords = explode(' ', $title);
		foreach ($titleWords as $key => $word) {
			// first word always uppercase
			if ($key == 0 || !in_array($word, $ignoreWords)) {
				// replace words
				$title = preg_replace(array("/\b" . $word . "\b/i"), array(ucfirst($word)), $title);
			}
		}
		// unescape preg modifiers
		$title = str_replace('\\', '', $title);
		return $title;
		/*$caseWords = explode(' ', getOption('sentenceCaseTitlesWords'));			
		$patterns = array();
		$replacements = array();
		foreach ($caseWords as $caseWord) {
			$patterns []= "/\b" . $caseWord . "\b/i";
			$replacements []= $caseWord;
		}		
		$newTitle = preg_replace($patterns, $replacements, $title);
		return $newTitle;*/
	}

	public function checkAllPosts() {
		// use do{}while() for less memory usage
		$i = 0;
		do {
			$allPosts = get_posts(array('post_type' => array('post', 'page'), 'posts_per_page' => 5, 'offset' => $i++*5, 'post_status' => 'any'));
			foreach ($allPosts as $post) {
				$this->checkForFeedback($post);
			}
		} while (count($allPosts) > 0);
	}

	public function getEnabledFeedbackChecks() {
		$self = $this;
		return array_filter($this->feedbackChecks, function($feedbackCheck) use ($self) {
			if ($self->isEnabledFeedbackCheck($feedbackCheck)) return true;
		});
	}

	public function checkForFeedback($post = null) {
		global $msbfLoader;
		$post = $post ?: get_the_post();
		if (($post->post_type == 'post' && !getOption('applyToPosts')) || ($post->post_type == 'page' && !getOption('applyToPages'))) return;
		$this->errors = array();
		foreach ($this->getEnabledFeedbackChecks() as $feedbackCheck) {
			if (!@$feedbackCheck->isValid($post)) {
				$errorLine = $feedbackCheck->getError($msbfLoader->options['feedbackLanguage'] == 'English' ? 'en_EN' : 'nl_NL');
				if (get_class($feedbackCheck) == 'BlankLines') {
					$action = $msbfLoader->options['feedbackLanguage'] == 'English' ? 'Actions' : 'Acties';
					$delete = $msbfLoader->options['feedbackLanguage'] == 'English' ? 'Delete the blank lines for me' : 'Verwijder de witregels voor me';
					$exception = $msbfLoader->options['feedbackLanguage'] == 'English' ? 'This is an exception, please leave me alone' : 'Dit is een uitzondering, laat me met rust';
					$errorLine .= '<div><div class="dashicons"></div> <span style="font-size:13px;">' . $action . ':</span> <a href="' . get_admin_url() . 'post.php?post=' . $post->ID . '&action=edit&msbf=delete-blank-lines" style="margin-left:10px;font-size:13px;">' . $delete . '</a> <a href="' . get_admin_url() . 'post.php?post=' . $post->ID . '&action=edit&msbf=add-blank-lines-exception" style="margin-left:10px;font-size:13px;">' . $exception . '</a></div>';
				} else if (get_class($feedbackCheck) == 'ToFewWordsInArticle') {
					$action = $msbfLoader->options['feedbackLanguage'] == 'English' ? 'Actions' : 'Acties';
					$leaveMeAlone = $msbfLoader->options['feedbackLanguage'] == 'English' ? 'This is a post/page where a less number of words was required so leave me alone' : 'Dit is een post/pagina waarbij een minder aantal worden was vereist dus laat me met rust';
					$errorLine .= '<div><div class="dashicons"></div> <span style="font-size:13px;">' . $action . ':</span> <a href="' . get_admin_url() . 'post.php?post=' . $post->ID . '&action=edit&msbf=add-few-words-exception" style="margin-left:10px;font-size:13px;">' . $leaveMeAlone . '</a></div>';
				} else if (get_class($feedbackCheck) == 'WrongImageLinks') {
					$action = $msbfLoader->options['feedbackLanguage'] == 'English' ? 'Actions' : 'Acties';
					$delete = $msbfLoader->options['feedbackLanguage'] == 'English' ? 'Delete the anchors of these images' : 'Klik hier om deze afbeeldingen niet meer aanklikbaar te maken';
					$exception = $msbfLoader->options['feedbackLanguage'] == 'English' ? 'Only images which the user can zoomin are clickable, please leave me alone' : 'Alleen de images die uitvergroot kunnen worden door de bezoeker zijn aanklikbaar en de rest niet, dus laat me met rust';
					$errorLine .= '<div><div class="dashicons"></div> <span style="font-size:13px;">' . $action . ':</span> <a href="' . get_admin_url() . 'post.php?post=' . $post->ID . '&action=edit&ssmbf=delete-wrong-image-links" style="margin-left:10px;font-size:13px;">' . $delete . '</a> <a href="' . get_admin_url() . 'post.php?post=' . $post->ID . '&action=edit&ssmbf=add-wrong-image-links-exception" style="margin-left:10px;font-size:13px;">' . $exception . '</a></div>';
				} else if (get_class($feedbackCheck) == 'ExtraSpaces') {
					$action = $msbfLoader->options['feedbackLanguage'] == 'English' ? 'Actions' : 'Acties';
					$delete = $msbfLoader->options['feedbackLanguage'] == 'English' ? 'Remove spaces for me' : 'Haal voor mij deze spaties weg';
					
					$errorLine .= '<div><div class="dashicons"></div> <span style="font-size:13px;">' . $action . ':</span> <a href="' . get_admin_url() . 'post.php?post=' . $post->ID . '&action=edit&ssmbf=delete-extra-spaces" style="margin-left:10px;font-size:13px;">' . $delete . '</a></div>';
				} 
				$this->errors []= $errorLine;
			}
		}
		// save errors in session, because after publish post wordpress redirects
		if (!empty($this->errors)) {
			$msbfLoader->options['feedbackErrors'][$post->ID] = $this->errors;
		} else {
			unset($msbfLoader->options['feedbackErrors'][$post->ID]);
		}
		$msbfLoader->save_options();
	}

	public function handleNonFeedbackOptions() {
		if (getOption('autoAddMoreTagFirstHeading')) {
			add_filter('the_content', function($content) {
				if (get_post_type() == 'post' && strpos($content, '<!--more-->') == false && strpos($content, 'id="more-' . get_the_ID() . '"') === false) {
					$pattern = '#<([^>]+?)(?: [^>]+)?><!--more--></(.+?)>#is';
					preg_match_all($pattern, $content, $matches, PREG_SET_ORDER);
					if (count($matches)) {
						//$content = str_replace($matches[0][0], "<!--more-->\n" . $matches[0][0], $content);
					}
				}
				return $content;
			});
		}

		if (getOption('moreTagOnlyText')) {
			add_filter('the_content', function($content) {
				$pattern = '#<([^>]+?)(?: [^>]+)?><!--more--></(.+?)>#is';

				//preg_match_all($pattern, $content, $matches, PREG_SET_ORDER); // no need to preg match all, there should only be one more tage
				preg_match($pattern, $content, $matches);
				if (count($matches)) {
					$newHTML = str_replace('<!--more-->', '', $matches[0][0]);
					//$content = str_replace($matches[0][0], $newHTML . "<!--more-->", $content);
				}
				return $content;
			});
		}

		if (getOption('moreTagClearBoth')) {
			add_filter('the_content', function($content) {
				//$content = str_replace('<!--more-->', '<div style="clear:both;"><!--more--></div>', $content);
				return $content;
			}, 1);
		}

		if (getOption('headingHasNoCSS')) {
			add_filter('the_content', function($content) {
				
				$pattern = '#<([^>]+?)(?: [^>]+)?></h\1></(.+?)>#is';

				preg_match_all($pattern, $content, $matches, PREG_SET_ORDER);
				if (!empty($matches)) {
					foreach ($matches[0] as $key => $headingHTML) {
						$headingNum = $matches[0][1];
						$headingStr = strip_tags($matches[0][2]);
						$correctHeadingHTML = '<h' . $headingNum . '>' . $headingStr . '</h' . $headingNum . '>';
						if (strlen($headingHTML) > strlen($correctHeadingHTML)) {
							//$content = str_replace($headingHTML, $correctHeadingHTML, $content);
						}
					}
				}
				return $content;
			});
		}
	}

	public function printAdminMessage() {
		if (count($this->getEnabledFeedbackChecks()) > 0 && (get_the_post()->post_type == 'post' && getOption('applyToPosts')) || (get_the_post()->post_type == 'page' && getOption('applyToPages'))) {
			echo $this->getAdminMessage();
		}

		global $msbfLoader;
		// show alert when published/scheduled post failed, because feedback is forced
		if (isset($msbfLoader->options['forcedFeedbackFailedPublished'][get_the_ID()]) && count($msbfLoader->options['forcedFeedbackFailedPublished'][get_the_ID()]) > 0) {
			unset($msbfLoader->options['forcedFeedbackFailedPublished'][get_the_ID()]);
			$msbfLoader->save_options();
			echo '<script>alert("You didn’t implement all the feedback points so you can’t publish or schedule an article. You first have to correct all the feedback.");</script>';
		}
	}

	/*public function getAdminMessage() {
		$published = get_the_post()->post_status == 'publish' || get_the_post()->post_status == 'future';
		$noFeedback = empty($this->errors);
		$feedbackLines = '';
		if (!$noFeedback ) {
			foreach ($this->errors as $error) {				
				if ($published) {
					$error = '<span style="font-size:' . optionOr('feedbackFontSize', 'inherit') . 'px;">' . $error . '</span>';
				}
				$feedbackLines .= '<li><div class="dashicons dashicons-no"></div> ' . $error . '</li>';
			}
			$feedbackLines = '<ul>' . $feedbackLines . '</ul>';
		}
		$okFeedback = array(
			'en_EN' => "Excellent! You've done everything correctly. Keep up the good work!",
			'nl_NL' => "Uitstekend! Je hebt alles correct gedaan. Ga zo door!"
		);
		$feedbackTitle = '<h3 style="color:inherit;"><div class="dashicons ' . ($noFeedback ? 'dashicons-yes' : 'dashicons-info') . '" style="font-size:35px;line-height:20px;margin-right:10px;"></div> ' . ($noFeedback ? $okFeedback[getOption('feedbackLanguage') == 'English' ? 'en_EN' : 'nl_NL'] . " - " : '') . 'Magnate Smart Blogger Feedback</h3>';
		$feedbackHTML = '<div id="msbf-feedback" style="' . ($noFeedback ? 'background-color:#7AD03A;border-left-color:#222;' : ($published ? 'color:' . optionOr('feedbackFontColor', '#DD3333') . ';background-color:' . optionOr('feedbackBackgroundColor', '#EEEE22') . ';' : '')) . '" class="' . ($noFeedback ? 'updated' : 'error') . '">' . $feedbackTitle . $feedbackLines . '</div>';

		return $feedbackHTML;
	}*/

	public function getAdminMessage($post = null, $errors = null, $adminMessage = true) {
		$post = $post ?: get_the_post();
		$errors = is_array($errors) ? $errors : $this->errors;

		$published = $post->post_status == 'publish' || $post->post_status == 'future';
		if (!$adminMessage) {
			$noFeedback = empty($errors);
		} else {
			$noFeedback = is_post_feedback_ignored($post->ID) ?: empty($errors);
		}
		$feedbackLines = '';
		if (!$noFeedback) {
			foreach ($errors as $error) {				
				if ($published) {
					$error = '<span style="font-size:' . optionOr('feedbackFontSize', 'inherit') . 'px;">' . $error . '</span>';
				}
				$feedbackLines .= '<li><div class="dashicons dashicons-no"></div> ' . $error . '</li>';
			}
			$feedbackLines = '<ul>' . $feedbackLines . '</ul>';
		}
		$okFeedback = array(
			'en_EN' => "Excellent! You've done everything correctly. Keep up the good work!",
			'nl_NL' => "Uitstekend! Je hebt alles correct gedaan. Ga zo door!"
		);
		$feedbackTitle = '<h3 style="color:inherit;"><div class="dashicons ' . ($noFeedback ? 'dashicons-yes' : 'dashicons-info') . '" style="font-size:35px;line-height:20px;margin-right:10px;"></div> ' . ($noFeedback ? $okFeedback[getOption('feedbackLanguage') == 'English' ? 'en_EN' : 'nl_NL'] . " - " : '') . 'Sharketing Smart Blogger Feedback</h3>';
		$feedbackHTML = '<div id="msbf-feedback" style="' . ($noFeedback ? 'background-color:#7AD03A;border-left-color:#222;' : ($published ? 'color:' . optionOr('feedbackFontColor', '#DD3333') . ';background-color:' . optionOr('feedbackBackgroundColor', '#EEEE22') . ';' : '')) . '" ' . ($adminMessage ? 'class="' . ($noFeedback ? 'updated' : 'error') . '"' : '') . '>';
		
		$feedbackHTML .= $feedbackTitle;

		$feedbackHTML .= $this->tipsHTML($post);

		$feedbackHTML .= $feedbackLines;

		if (!$noFeedback && is_truly_admin()) {
			$ignorelink = admin_url('options-general.php?page=sharketing-smart-blogger-feedback/admin/options.php&ignoreFeedback=' . $post->ID . '&returnpost=1');
			$feedbackHTML .= '<div><a href="' . $ignorelink . '">Ignore all feedback</a></div>';
		}

		$feedbackHTML .= '</div>';

		return $feedbackHTML;
	}

	public function hideTip($tip, $post) {
		$option = getOption('ssmbf_hide_tips');
		$option = $option ?: array();
		if (!isset($option[$tip][$post->ID])) {
			$option[$tip][$post->ID] = 1;
		}
		setOption('ssmbf_hide_tips', $option);
	}

	public function handleHideTips($post) {
		if ($hide_tip = $_GET['ssmbf_hide_tip']) {
			$this->hideTip($hide_tip, $post);
		}
	}

	public function isTipHidden($tip, $post) {
		$option = getOption('ssmbf_hide_tips');
		$option = $option ?: array();
		return isset($option[$tip][$post->ID]);
	}

	public function tipsHTML($post) {

		$this->handleHideTips($post);

		global $msbfLoader;
		$action = $msbfLoader->options['feedbackLanguage'] == 'English' ? 'Actions' : 'Acties';
		$lang = getOption('feedbackLanguage') == 'English' ? 'en_EN' : 'nl_NL';
		$leaveMeAlone = $msbfLoader->options['feedbackLanguage'] == 'English' ? 'Thanks for your tip, but hide this please' : 'Bedankt voor tip, maar verberg deze graag';
		$leaveMeAlone2 = $msbfLoader->options['feedbackLanguage'] == 'English' ? 'Thanks for your tip, but hide this please' : 'Bedankt voor tip, ik heb het toegepast';
		$html = '';
		
		if (!$this->isTipHidden('start', $post)) {
			$startTip = array(
				'en_EN' => "Start with a short story as it fits into the context of the article to greatly increase the engagement.",
				'nl_NL' => "Start met een kort verhaal als het past in de context van het artikel om de engagement sterk te verhogen."
			);
			$tip = $startTip[$lang];
			$html .= '<div><div class="dashicons dashicons-info"></div> ' . $tip . '</div>';		
			$html .= '<div><div class="dashicons"></div> <span style="font-size:13px;">' . $action . ':</span> <a href="' . get_admin_url() . 'post.php?post=' . $post->ID . '&action=edit&ssmbf_hide_tip=start" style="margin-left:10px;font-size:13px;">' . $leaveMeAlone . '</a></div>';
		}

		if (!$this->isTipHidden('bulletpoints', $post)) {
			$startTip = array(
				'en_EN' => "Tell briefly at the top with some bullet points what people will learn in the article so that they are curious to read further.",
				'nl_NL' => "Vertel bovenaan kort met een aantal bulletpoints wat mensen gaan leren in het artikel zodat ze nieuwsgierig worden om verder te lezen."
			);
			$tip = $startTip[$lang];
			$html .= '<div><div class="dashicons dashicons-info"></div> ' . $tip . '</div>';		
			$html .= '<div><div class="dashicons"></div> <span style="font-size:13px;">' . $action . ':</span> <a href="' . get_admin_url() . 'post.php?post=' . $post->ID . '&action=edit&ssmbf_hide_tip=bulletpoints" style="margin-left:10px;font-size:13px;">' . $leaveMeAlone . '</a></div>';
		}

		if (!$this->isTipHidden('permalink', $post)) {
			$startTip = array(
				'en_EN' => "Make sure you only put the most important words in your permalink and that it is short.",
				'nl_NL' => "Zorg ervoor dat je alleen de belangrijkste woorden in je permalink zet en dat deze kort is."
			);
			$tip = $startTip[$lang];
			$html .= '<div><div class="dashicons dashicons-info"></div> ' . $tip . '</div>';		
			$html .= '<div><div class="dashicons"></div> <span style="font-size:13px;">' . $action . ':</span> <a href="' . get_admin_url() . 'post.php?post=' . $post->ID . '&action=edit&ssmbf_hide_tip=permalink" style="margin-left:10px;font-size:13px;">' . $leaveMeAlone2 . '</a></div>';
		}

		return $html;

	}

}