<?php

class FormatHandler {

	public function init() {
		add_filter('tiny_mce_before_init', array(&$this, 'setupFormatTinyMCE'));
		add_filter('mce_buttons', array(&$this, 'buttonsTinyMCE'));
		$this->addCommentsButton();
		
		
		if (getOption('defaultNonClickableImageOnAdd')) {
			add_filter('pre_option_image_default_link_type', function($val) {
				return 'none';
			});
		}
		
		if (getOption('defaultEditorRemoveImageAttributes')) {
			add_filter('post_thumbnail_html', array($this, 'removeEditorImageAttributes'), 10);
			add_filter('image_send_to_editor', array($this, 'removeEditorImageAttributes'), 10);
		}
	}
	
	public function removeEditorImageAttributes($html) {
		// remove width and height attributes
		$html = preg_replace('/(width|height)="\d*"\s/', "", $html);
		// remove url parts "-300x188" -> we want the original file
		$html = preg_replace('/-\d*x\d*/', "", $html);
		return $html;
	}

	public function handleNonAdminFormatOptions() {
		// filter content, remove .msbf_comment_notification_tinymce
		add_filter('the_content', function($content) {
			preg_match_all("'<span class=\"msbf_comment_notification_tinymce\"(.*?)</span>'si", $content, $matches);
			foreach ($matches[0] as $key => $match) {
				$content = str_replace($match, end(explode('>', $matches[1][$key])), $content);
			}
			return $content;
		});
	}

	public function addCommentsButton() {
		add_action('admin_head', 'add_comment_button');

		function add_comment_button() {
			global $typenow;
			// check user permissions
			if ( !current_user_can('edit_posts') && !current_user_can('edit_pages') ) {
			return;
			}
			// verify the post type
			if( ! in_array( $typenow, array( 'post', 'page' ) ) )
				return;
			// check if WYSIWYG is enabled
			if ( get_user_option('rich_editing') == 'true') {
				add_filter("mce_external_plugins", "add_tinymce_plugin");
				add_filter('mce_buttons', 'register_add_comment_button');
			}
		}

		function add_tinymce_plugin($plugin_array) {
			$plugin_array['gavickpro_tc_button'] = plugins_url( '/msfb-comments-button.js', __FILE__ ); // CHANGE THE BUTTON SCRIPT HERE
			return $plugin_array;
		}

		function register_add_comment_button($buttons) {
		   array_push($buttons, "msbf_comment");
		   return $buttons;
		}

		function msfb_comment_button_css() {
			wp_enqueue_style('msfb-comment', plugins_url('/msfb-comments-button.css', __FILE__));
		}
		 
		add_action('admin_enqueue_scripts', 'msfb_comment_button_css');
	}

	public function setupFormatTinyMCE($in) {
		// collection of all available formats
		$baseFormats = array('Paragraph' => 'p', 'Address' => 'address', 'Pre' => 'pre', 'Heading 1' => 'h1', 'Heading 2' => 'h2', 'Heading 3' => 'h3', 'Heading 4' => 'h4', 'Heading 5' => 'h5', 'Heading 6' => 'h6');
		// notice! added a extra space in english translation, because else wordpress will translate it, this could be unwanted
		// when adding a extra space, wordpress won't translate it
		$defaultFormats = array(
			'en_EN' => array('Paragraph ' => 'p', 'Address' => 'address', 'Pre' => 'pre', 'Heading 1' => 'h1', 'Heading  2' => 'h2', 'Heading  3' => 'h3', 'Heading  4' => 'h4', 'Heading  5' => 'h5', 'Heading  6' => 'h6'),
			'nl_NL' => array('Paragraaf' => 'p', 'Address' => 'address', 'Pre' => 'pre', 'Koptekst 1' => 'h1', 'Koptekst 2' => 'h2', 'Koptekst 3' => 'h3', 'Koptekst 4' => 'h4', 'Koptekst 5' => 'h5', 'Koptekst 6' => 'h6')
		);
		$formats = $defaultFormats[langtoiso(getOption('formatOptionsLanguage'))];
		$blockFormats = array();
		foreach ($formats as $name => $tag) {
			if (!getOption('format' . str_replace(' ', '_', array_search($tag, $baseFormats)))) {
				$blockFormats []= $name . '=' . $tag;
			}
		}

		$in['block_formats'] = join(';', $blockFormats);
		if (getOption('defaultSecondToolbarVisible')) {
			$in['wordpress_adv_hidden'] = false;
		}

		$in['content_css'] = $in['content_css'] . ',' . plugins_url('/msfb-comments-button.css', __FILE__);
		return $in;
	}

	public function buttonsTinyMCE($buttons) {
		// only for authors
		if ($this->getUserRole() != 'author') return $buttons;

		$baseFormatsAuthors = array('Underline', 'Italic');
		$blockFormats = array();
		foreach ($baseFormatsAuthors as $tag) {
			if (getOption('format' . str_replace(' ', '_', $tag))) {
				$blockFormats []= strtolower($tag);
			}
		}
		return array_diff($buttons, $blockFormats);
	}

	public function getUserRole() {
		global $current_user;

		$user_roles = $current_user->roles;
		$user_role = array_shift($user_roles);

		return $user_role;
	}

}