<?php

class NotificationsHandler {

	public function __construct() {
		$this->handleSaveOptions();
		$this->sendNotifications();
	}

	public function handleSaveOptions() {
		if (isset($_POST['enableNotificationsIgnoringFeedback'])) {
			if (!getOption('enableNotificationsIgnoringFeedback')) {
				setOption('enableNotificationsIgnoresFeedbackActivated', timestamp());
			}
		}
		if (isset($_POST['enableNotificationsNoUpdates'])) {
			if (!getOption('enableNotificationsNoUpdates')) {
				setOption('enableNotificationsNoUpdatesActivated', timestamp());
			}
		}
	}

	public function checkSendNoficationMailIgnoresFeedback($postId) {	
		$post = get_post($postId, ARRAY_A);
		if ($post) {
			$postTime = strtotime($post['post_modified']);
			if ($postTime > getOption('enableNotificationsIgnoresFeedbackActivated')) {
				$diffSecs = timestamp() - $postTime;
				$maxSecs = (intOptionOr('notifyAfterHours', 0) + intOptionOr('notifyAfterDays', 0)*24)*3600;
				if ($maxSecs > 0 && $diffSecs > $maxSecs) {

					if (getOption('lastPostEdited_' . $postId) != $postTime) {
						// forget already send mails
						setOption('numSendNoficationMailIgnoresFeedback_' . $postId, 0);
						// update last post update
						setOption('lastPostEdited_' . $postId, $postTime);
					}

					$lastCheck = getOption('lastNoficationMailIgnoresFeedbackCheck_' . $postId);
					if (getOption('numSendNoficationMailIgnoresFeedback_' . $postId) <= 3 && (!$lastCheck || (timestamp() - $lastCheck) > $maxSecs)) {
						setOption('lastNoficationMailIgnoresFeedbackCheck_' . $postId, timestamp());
						return true;
					} else {		
						// dont send mail
					}

				}
			}
		}
		return false;
	}

	public function sendNoficationMailsIgnoresFeedback() {
		$allFeedbackErrors = getOption('feedbackErrors');
		foreach ($allFeedbackErrors as $postId => $feedbackErrors) {
			if ($postId > 0 && $this->checkSendNoficationMailIgnoresFeedback($postId)) {
				$post = get_post($postId, ARRAY_A);
				$optName = 'numSendNoficationMailIgnoresFeedback_' . $postId;

				// Fatal error: Call to undefined function get_userdata() in /home/versieren/domains/versiertrucs.com/public_html/wp-includes/author-template.php on line 121
				//$username = get_the_author_meta('user_login', 1);var_dump($username);die();
				$username = $post['post_author'];
				$url = get_permalink($postId, $leavename);

				$lastEditedTime = getOption('lastPostEdited_' . $postId) - getOption('enableNotificationsIgnoresFeedbackActivated');
				$lastEditedDays = floor($lastEditedTime/(24*3600));
				$lastEditedHours = floor(($lastEditedTime - ($lastEditedDays*(24*3600)))/3600);
				$hoursDays = $this->hoursDaysStr($lastEditedDays, $lastEditedHours);

				$this->sendNotificationMail($this->getNoficationMailIgnoresFeedback(), $this->getNoficationMailTitleIgnoresFeedback(), array('blogger wp username' => $username, 'number of hours/days' => $hoursDays, 'url' => $url), getOption($optName) > 0);			
				setOption($optName, getOption($optName) + 1);
			}
		}
	}

	public function hoursDaysStr($hours, $days) {
		$str = array();
		if ($days > 0) $str []= $days . ' day(s)';
		if ($hours > 0) $str []= $hours . ' hour(s)';
		return count($str) > 0 ? join($str, ' and ') : 'now';
	}

	public function checkSendNoficationMailNoUpdates() {
		$args = array(
			'numberposts' => 1,
			'offset' => 0,
			'category' => 0,
			'orderby' => 'post_date',
			'order' => 'DESC',
			'include' => '',
			'exclude' => '',
			'meta_key' => '',
			'meta_value' => '',
			'post_type' => 'post',
			'post_status' => 'publish',
			'suppress_filters' => true 
		);
		$latestPost = wp_get_recent_posts($args, ARRAY_A);
		if (!empty($latestPost)) {			
			$postTime = strtotime($latestPost[0]['post_date_gmt']);
			//if ($postTime > getOption('enableNotificationsNoUpdatesActivated')) {
				$diffSecs = timestamp() - $postTime;
				$maxSecs = (intOptionOr('notifyAfterHours2', 0) + intOptionOr('notifyAfterDays2', 0)*24)*3600;
				if ($maxSecs > 0 && $diffSecs > $maxSecs) {

					if (getOption('lastPostUpdate') != $postTime) {
						// forget already send mails
						setOption('numSendNoficationMailNoUpdates', 0);
						// update last post update
						setOption('lastPostUpdate', $postTime);
					}

					$lastCheck = getOption('lastNoficationMailNoUpdatesCheck');
					if (getOption('numSendNoficationMailNoUpdates') <= 3 && (!$lastCheck || (timestamp() - $lastCheck) > $maxSecs)) {
						setOption('lastNoficationMailNoUpdatesCheck', timestamp());
						return true;
					} else {		
						// dont send mail
					}

				}
			//}
		}
		return false;
	}

	public function sendNotifications() {
		if (getOption('enableNotificationsIgnoringFeedback')) {
			$this->sendNoficationMailsIgnoresFeedback();
		}
		if (getOption('enableNotificationsNoUpdates') && $this->checkSendNoficationMailNoUpdates()) {
			$lastUpdateTime = timestamp() - getOption('lastPostUpdate'); //getOption('enableNotificationsNoUpdatesActivated') - getOption('lastPostUpdate');
			$lastUpdateDays = floor($lastUpdateTime/(24*3600));
			$lastUpdateHours = floor(($lastUpdateTime - ($lastUpdateDays*(24*3600)))/3600);
			$this->sendNotificationMail($this->getNoficationMailNoUpdates(), $this->getNoficationMailTitleNoUpdates(), array('url' => get_site_url(), 'number of hours/days' => $this->hoursDaysStr($lastUpdateHours, $lastUpdateDays)), getOption('numSendNoficationMailNoUpdates') > 0);			
			setOption('numSendNoficationMailNoUpdates', getOption('numSendNoficationMailNoUpdates') + 1);
		}
	}

	public function sendNotificationMail($message, $title, array $params, $reminder = false) {
		if ($reminder) $title = 'REMINDER: ' . $title;
		foreach ($params as $param => $value) {
			$message = str_replace('[' . $param . ']', $value, $message);
			$title = str_replace('[' . $param . ']', $value, $title);
		}
		$to = explode(',', optionOr('notificationsEmail', get_option('admin_email')));
		foreach ($to as $t) {
			$headers = 'From: Sharketing Blogger Feedback <' . $to . '>' . "\r\n";
			wp_mail($to, $title, $message, $headers);
		}
	}

	public function getNoficationMailIgnoresFeedback() {
		return getOption('notificationMailIgnoresFeedback') ?: "Hi webmaster,

This is an automated message.

The blogger [blogger wp username] exceded the time frame you selected to correct the feedback for a specific blogpost.

For [number of hours/days] the feedback of the blogpost [url] has not been implemented.

Hope you got updated with this message.

Have a nice day!
Sharketing Smart Blogger Feedback

Whitelist code for gmail filters: at5bit3x";
	}

	public function getNoficationMailNoUpdates() {
		return getOption('notificationMailNoUpdates') ?: "Hi webmaster,

This is an automated message.

The blog [url] exceeds the time frame you selected to get a new blogpost.

For [number of hours/days] the blog is already not updated.

Hope you got updated with this message.

Have a nice day!
Sharketing Smart Blogger Feedback

Whitelist code for gmail filters: at5bit3x";
	}

	public function getNoficationMailTitleIgnoresFeedback() {
		return getOption('noficationMailTitleIgnoresFeedback') ?: "The blogger [blogger wp username] didn’t correct feedback";
	}

	public function getNoficationMailTitleNoUpdates() {
		return getOption('noficationMailTitleNoUpdates') ?: "The blog [url] isn’t updated with new blogposts for [number of hours/days]";
	}

}