<?php
	
function ssmbf_approve_comment_author_link($approved, $commentdata) {
	
	// force allow master users
	if (ssmbf_is_force_comments_allowed()) return '1';
	
	// only work when not in admin mode
	if (is_admin()) return $approved;
	
	if (getOption('autoDisproveCommentsWithAuthorLink') !== null && !getOption('autoDisproveCommentsWithAuthorLink')) return $approved;
	
	return strlen($commentdata['comment_author_url']) == 0 ? $approved : '0'; 
}
add_filter('pre_comment_approved' , 'ssmbf_approve_comment_author_link' , '99', 2);
	
function ssmbf_approve_comment_content($approved, $commentdata) {

	// force allow master users
	if (ssmbf_is_force_comments_allowed()) return '1';
	
	// only work when not in admin mode
	if (is_admin()) return $approved;
	
	// no auto disapprove, process default
	if (getOption('autoDisproveCommentsWithLinks') === '0') {
		return $approved;
	}
	
	// check if comment content contains anchors/links
	$xml = new DOMDocument(); 
	$xml->loadHTML(make_clickable(apply_filters('comment_text', $commentdata['comment_content']))); 
	$links = $xml->getElementsByTagName('a');

	return $links->length == 0 ? $approved : 'spam';
}
add_filter('pre_comment_approved' , 'ssmbf_approve_comment_content' , '99', 2);

	
function ssmbf_hide_all_links($comment_text) {
	
	if (getOption('hideAllLinksInComments') !== null && !getOption('hideAllLinksInComments')) return $comment_text;
	
	if (ssmbf_are_author_comments_allowed()) return $comment_text;
	
	return ssmbf_comment_remove_links_from_html($comment_text);
}
add_filter('comment_text', 'ssmbf_hide_all_links', 99);

function ssmbf_hide_all_username_links($comment_author) {
	
	if (getOption('hideAllUsernameLinksInComments') !== null && !getOption('hideAllUsernameLinksInComments')) return $comment_author;
	
	if (ssmbf_are_author_comments_allowed()) return $comment_author;
	
	return ssmbf_comment_remove_links_from_html($comment_author);
}
add_filter('get_comment_author_link', 'ssmbf_hide_all_username_links', 99);

function ssmbf_is_force_comments_allowed() {
	$master_roles = array('contributor', 'author', 'editor', 'administrator');
	return count(array_intersect(ssmbf_get_user_role(), $master_roles)) > 0;
}

function ssmbf_are_author_comments_allowed() {
	$exception_roles = array('contributor', 'author', 'editor', 'administrator');
	$user_role = ssmbf_get_current_comment_author_role();
	
	return $user_role && in_array($user_role, $exception_roles);
}

function ssmbf_get_current_comment_author_role() {
	$comment_author_user_id = get_comment(get_comment_ID())->user_id;
	$user_role = ssmbf_get_user_role($comment_author_user_id);
	return $user_role;
}

function ssmbf_comment_remove_links_from_html($html) {
	$xml = new DOMDocument(); 
	$xml->loadHTML($html); 
	
	$links = $xml->getElementsByTagName('a');
	
	//Loop through each <a> tags and replace them by their text content    
	for ($i = $links->length - 1; $i >= 0; $i--) {
	    $linkNode = $links->item($i);
	    $lnkText = $linkNode->textContent;
	    $newTxtNode = $xml->createTextNode($lnkText);
	    $linkNode->parentNode->replaceChild($newTxtNode, $linkNode);
	}
	
	return $xml->saveXML();
}