<?php

class ExtraSpaces extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'Extra spaces';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! You have one or more spaces at the beginning of paragraphs or headers.. Please remove spaces.',
			'nl_NL' => 'LET OP! Je hebt bij het begin van één of meerdere zinnen of kopjes één of meerdere spaties staan. Graag deze weghalen.'
		);
		$this->sort = 17;
	}

	public function isValid($post) {
		$content = wpautop(get_the_post_content($post));
		
		if (!$content)
			return true;
			
		$content = preg_replace('/[\x00-\x1F\x80-\xFF]/', '', $content);
		
		$elementsWithExtraSpaces = $this->getElementsWithExtraSpaces($content);
		
		if (count($elementsWithExtraSpaces) > 0 && $_GET['ssmbf'] == 'delete-extra-spaces') {
			$newContent = $this->deleteExtraSpaces($content, $elementsWithExtraSpaces);
			wp_update_post(array(
				'ID' => $post->ID,
				'post_content' => $newContent
			));
			// refetch post for latest version
			$post = get_post($post->ID);
			// re-validate this feedbackcheck
			unset($_GET['ssmbf']);
			return $this->isValid($post);
		}
		
		
		return count($elementsWithExtraSpaces) == 0;
	}

	public function getElementsWithExtraSpaces($content) {

		$dom = new DOMDocument('1.0', 'UTF-8');
		$dom->loadHTML($content);
		$p = $dom->getElementsByTagName('p');
		$h1 = $dom->getElementsByTagName('h1');
		$h2 = $dom->getElementsByTagName('h2');
		$h3 = $dom->getElementsByTagName('h3');
		$h4 = $dom->getElementsByTagName('h4');
		$h5 = $dom->getElementsByTagName('h5');
		$h6 = $dom->getElementsByTagName('h6');

		$getElementsWithExtraSpaces = function($els) {
			$elements = array();
			foreach ($els as $el) {
				$html = $el->ownerDocument->saveXML($el);
				// http://stackoverflow.com/questions/1176904/php-how-to-remove-all-non-printable-characters-in-a-string
				$text = strip_tags($html);
				if ($text[0] == ' ') $elements []= array($el, $html, $text);
			}
			return $elements;
		};

		return array_merge(
			$getElementsWithExtraSpaces($p), 
			$getElementsWithExtraSpaces($h1), 
			$getElementsWithExtraSpaces($h2), 
			$getElementsWithExtraSpaces($h3), 
			$getElementsWithExtraSpaces($h4), 
			$getElementsWithExtraSpaces($h5), 
			$getElementsWithExtraSpaces($h6)
		);
	}
	
	public function deleteExtraSpaces($content, $elements) {
		foreach ($elements as $el) {
			// simple replacement
			$content = str_replace('>' . $el[2] . '<', '>' . ltrim($el[2]) . '<', $content);
		}
		return $content;
	}
}