<?php

class NoHeadings extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'No headings';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! You didn’t use any headings! Use at least [min_head] headings in an article.',
			'nl_NL' => 'LET OP! Je hebt geen kopjes gebruikt! Gebruik ten minste [min_head] kopjes in een artikel.'
		);
		$this->sort = 8;
		$this->errorVars = array(
			'min_head' => intOptionOr('minHeadings', 2)
		);
	}

	public function isValid($post) {
		$pattern = '#<h([1-6])(?: [^>]+)?>(.+?)</h\1>#is';
		preg_match_all($pattern, get_the_post_content($post), $matches, PREG_SET_ORDER);
		$numHeadings = count($matches);
		return $numHeadings > 0;
	}
}