<?php

class NoMetaDescription extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'No meta description';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! You didn’t add a meta description! Check the SEO box below this article and make it minimum [min_mdesc] characters and maximum [max_mdesc].',
			'nl_NL' => 'LET OP! Je hebt geen meta description toegevoegd! Check de SEO box onder dit artikel en maak het minimaal [min_mdesc] tekens en maximaal [max_mdesc].'
		);
		$this->sort = 3;
		$this->errorVars = array(
			'min_mdesc' => intOptionOr('minMetaDescription', 130),
			'max_mdesc' => intOptionOr('maxMetaDescription', 155)
		);
	}

	public function isValid($post) {
		$metaDescription = get_the_post_meta_description($post);
		return strlen($metaDescription) > 0;
	}
}