<?php

class NoMoreTag extends AFeedbackCheck {
	public function __construct() {
		$this->name = "No 'more tag'";
		$this->defaultError = array(
			'en_EN' => "ATTENTION! You did not add a more tag!",
			'nl_NL' => "LET OP! Je hebt geen more tag toegevoegd."
		);
		$this->sort = 6;
	}

	public function isValid($post) {
		$post_content = get_the_post_content($post);
		return strpos($post_content, '<!--more-->');
	}
}