<?php

class PermalinkDuplicate extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'Permalink duplicate';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! You choosed a permalink that was already taken! Now you see a number at the end of the permalink. Please delete that and make a unique permalink without numbers in it.',
			'nl_NL' => 'LET OP! Je hebt een permalink gekozen die al gekozen is! Nu zie je een nummer aan het einde van de permalink. Verwijder deze aub en maak er een unieke permalink van zonder nummers.'
		);
		$this->sort = 12;
	}

	public function isValid($post) {
		$lastPartOfPermalink = end(explode('-', $post->post_name));//get_permalink(get_the_post()->ID)));
		return intval($lastPartOfPermalink) == 0;
	}
}