<?php

class ToFewHeadings extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'Too few headings';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! You used too few headings! Use at least [min_head] headings.',
			'nl_NL' => 'LET OP! Je hebt te weinig kopjes gebruikt! Gebruik tenminste [min_head] kopjes.'
		);
		$this->sort = 9;
		$this->errorVars = array(
			'min_head' => intOptionOr('minHeadings', 2)
		);
	}

	public function isValid($post) {
		$pattern = '#<h([1-6])(?: [^>]+)?>(.+?)</h\1>#is';
		preg_match_all($pattern, get_the_post_content($post), $matches, PREG_SET_ORDER);
		$numHeadings = count($matches);
		return $numHeadings == 0 || $numHeadings >= intOptionOr('minHeadings', 2);
	}
}