<?php

class ToFewWordsInArticle extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'To few words in article';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! You used to few words in your article! Use at least [min_words] words.',
			'nl_NL' => 'LET OP! Je hebt te weinig woorden gebruikt voor je artikel! Gebruik tenminste [min_words] woorden.'
		);
		$this->sort = 10;
		$this->errorVars = array(
			'min_words' => intOptionOr('minWords', 500)
		);
	}

	public function isValid($post) {
		if ($_GET['msbf'] == 'add-few-words-exception') {
			$this->ignorePost($post);
		}

		if ($this->ignoredPost($post)) return true;

		//$numWords = count(explode(' ', get_the_post_content()));
		$numWords = str_word_count(strip_tags(get_the_post_content($post))) + 10; // add 10 for error-margin of counting words method
		return $numWords >= intOptionOr('minWords', 500);
	}
}