<?php

class ToLongMetaDescription extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'Too long meta description';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! Your meta description is too long! Check the SEO box below this article and make it minimum [min_mdesc] characters and maximum [max_mdesc].',
			'nl_NL' => 'LET OP! Je meta description is te lang! Check de SEO box onder dit artikel en maak het minimaal [min_mdesc] tekens en maximaal [max_mdesc].'
		);
		$this->sort = 5;
		$this->errorVars = array(
			'min_mdesc' => intOptionOr('minMetaDescription', 130),
			'max_mdesc' => intOptionOr('maxMetaDescription', 155)
		);
	}

	public function isValid($post) {
		$metaDescriptionLen = strlen(get_the_post_meta_description($post));
		return $metaDescriptionLen <= intOptionOr('maxMetaDescription', 155);
	}
}