<?php

class TooFewQuotes extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'Too few quotes';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! Your article have to few quotes! A article should have a minimum of [min_quotes] quotes.',
			'nl_NL' => 'LET OP! Je artikel bevat te weinig quotes! Een artikel moeten minimaal [min_quotes] quotes bevatten.'
		);
		$this->sort = 15;
		$this->errorVars = array(
			'min_quotes' => intOptionOr('minQuotes', 2)
		);
	}

	public function isValid($post) {
		return substr_count(get_the_post_content($post), '<blockquote>') >= intOptionOr('minQuotes', 2);
	}
}