<?php

class TooLongSEOTitle extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'Too long SEO title';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! Your SEO title has a width of [wtit]px, that is too long! Make it maximum [max_tit]px like Google wants it.',
			'nl_NL' => 'LET OP! Je SEO titel heeft een breedte van [wtit]px, dat is te lang! Maak het maximaal [max_tit]px zoals Google het wilt.'
		);
		$this->sort = 2;
		$this->errorVars = array(
			'max_tit' => intOptionOr('maxSEOTitleWidth', 508)
		);
	}

	public function isValid($post) {
		$this->errorVars['wtit'] = $this->getWidthSEOTitle($post);
		return $this->getWidthSEOTitle($post) <= intOptionOr('maxSEOTitleWidth', 508);
	}

	public function getWidthSEOTitle($post) {

		$seotitle = get_the_post_seo_title($post);
		$seokeywords = get_the_post_seo_keywords($post);

		// Establish image factors:
		$text = $seotitle;
		$font_size = 13.5; // Font size is in pixels.
		$font_file = dirname(__FILE__) . '/ARIAL.TTF'; // This is the path to your font file.
		$fontSizeBold = 16;

		// Retrieve bounding box:
		$type_space = imagettfbbox($font_size, 0, $font_file, $text);

		// Determine image width and height, 10 pixels are added for 5 pixels padding:
		$image_width = abs($type_space[4] - $type_space[0]) + 5;
		$image_height = abs($type_space[5] - $type_space[1]) + 5;

		$widthWithoutKeywords = $image_width;

		$textOver = $text;
		foreach (explode(' ', $seokeywords) as $keyword) {
			if (strlen($keyword) == 0) continue;
			$num = substr_count($textOver, $keyword);
			$textOver = str_replace($keyword, '', $textOver);
			$doKeyword = '';
			for ($i = 0; $i < $num; $i++) $doKeyword .= $keyword;
			$type_space1 = imagettfbbox($font_size, 0, $font_file, $doKeyword);
			$type_space2 = imagettfbbox($fontSizeBold, 0, $font_file, $doKeyword);
			$diff = abs($type_space2[4] - $type_space2[0]) - abs($type_space1[4] - $type_space1[0]);
			$totalReplace = $diff*$num;
			$image_width += $diff;
		}

		return $image_width;

	}
}