<?php

class TooMuchTextBeforeMoreTag extends AFeedbackCheck {
	public function __construct() {
		$this->name = "Too much text before 'more tag'";
		$this->defaultError = array(
			'en_EN' => "ATTENTION! You used too much words before the `more tag` appears. Please put the ‘more tag’ earlier (max is [max_words] words)",
			'nl_NL' => "LET OP! Je hebt te veel woorden gebruikt voordat de `more tag` verschijnt. Plaats de ‘more tag’ eerder (de max is [max_words] woorden)."
		);
		$this->sort = 6.5;
		$this->errorVars = array(
			'max_words' => intOptionOr('maxWordsBeforeMoreTag', 140),
		);
	}

	public function isValid($post) {
		$post_content = get_the_post_content($post);
		$morepos = strpos($post_content, '<!--more-->');
		if ($morepos !== false) {
			$wordsBefore = count(explode(' ', substr($post_content, 0, $morepos)));
		}
		return $morepos === false || $wordsBefore <= intOptionOr('maxWordsBeforeMoreTag', 140);
	}
}