<?php

class TooShortArticleTitle extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'Too short article title';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! Your article title is too short! Make it minimum [min_tit] characters and maximum [max_tit].',
			'nl_NL' => 'LET OP! Je artikel titel is te kort! Maak het minimaal [min_tit] tekens en maximaal [max_tit].'
		);
		$this->sort = 2.1;
		$this->errorVars = array(
			'min_tit' => intOptionOr('minArticleTitle', 30),
			'max_tit' => intOptionOr('maxArticleTitle', 80),
		);
	}

	public function isValid($post) {
		$len = strlen($post->post_title);
		return $len >= intOptionOr('minArticleTitle', 30);
	}
}