<?php

class TooShortSEOTitle extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'Too short SEO title';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! Your SEO title is too short! Make it minimum [min_tit] characters.',
			'nl_NL' => 'LET OP! Je SEO titel is te kort! Maak het minimaal [min_tit] tekens.'
		);
		$this->sort = 1;
		$this->errorVars = array(
			'min_tit' => intOptionOr('minSEOTitle', 30),
		);
	}

	public function isValid($post) {
		$len = strlen(get_the_post_seo_title($post));
		return $len >= intOptionOr('minSEOTitle', 30);
	}
}