<?php

class WrongImageLinks extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'Wrong image links';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! You should not have images which have anchors to the source of the image!',
			'nl_NL' => 'LET OP! Je hoort geen afbeeldingen te hebben die linken naar de afbeelding zelf!'
		);
		$this->sort = 18;
	}

	public function isValid($post) {
		if ($_GET['ssmbf'] == 'add-wrong-image-links-exception') {
			$this->ignorePost($post);
		}

		if ($this->ignoredPost($post)) return true;
		
		$content = get_the_post_content($post);
		if (!$content) return true;
		
		$numWrongImageLinks = count($this->getWrongLinkedImages($content));

		if ($numWrongImageLinks > 0 && $_GET['ssmbf'] == 'delete-wrong-image-links') {
			$newContent = $this->deleteWrongImageLinks(get_the_post_content($post));
			wp_update_post(array(
				'ID' => $post->ID,
				'post_content' => $newContent
			));
			// refetch post for latest version
			$post = get_post($post->ID);
			// re-validate this feedbackcheck
			return $this->isValid($post);
		}
		
		return $numWrongImageLinks == 0;
	}
	
	public function getWrongLinkedImages($content) {
		
		$wrongLinkedImages = array();

		$dom = new DOMDocument();
		$dom->loadHTML($content);
		$as = $dom->getElementsByTagName('a');
		foreach ($as as $a) {
			foreach ($a->getElementsByTagName('img') as $img) {
				if ($a->getAttribute('href') == $img->getAttribute('src')) {
					$wrongLinkedImages []= array($img, $a);
				}
			}
		}

		return $wrongLinkedImages;
	}
	
	public function deleteWrongImageLinks($content) {
		$wrongLinkedImages = $this->getWrongLinkedImages($content);		
		
		foreach ($wrongLinkedImages as $wrongLinkedImage) {
			$imageHTML = $wrongLinkedImage[0]->ownerDocument->saveXML($wrongLinkedImage[0]);
			$anchorHTML = $wrongLinkedImage[1]->ownerDocument->saveXML($wrongLinkedImage[1]);
			
			// simple replacement
			$content = str_replace($anchorHTML, $imageHTML, $content);
			
			// normalize anchorHTML -----> "/></a> (domcoument) ----> " /></a> (wordpress)
			// so we can replace this version also
			$anchorHTML = str_replace('"/></a>', '" /></a>', $anchorHTML);
			$content = str_replace($anchorHTML, $imageHTML, $content);
		}
		
		return $content;
	}
}