<?php

/**
 * Compatibility with Beaver Builder
 *
 * @package WishListMember/Compatibility
 */

// Fix for Beaver Builder and Team Management JS conflict.
add_filter(
    'wishlistmember_team_management_load_scripts',
    function ($load_scripts) {
        $_get = wlm_arrval(wlm_get_data(true));

        /*
         * We dont want to load Team Management frontend scripts if Beaver Builder editor is active
         * because it conflicts with it.
         */
        if (isset($_get['fl_builder']) || isset($_get['fl_builder_ui'])) {
            return false;
        }

        return $load_scripts;
    }
);
